/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule;

import de.consist.bmu.rule.schema.Namespace;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BMUMessageTypeEnum {
    ENSNDokument(Namespace.EN, new String[]{"/descendant::lib:NachweisNr[not(ancestor::en:EGFDokument) and not(ancestor::ags:AGSBescheid) and not(ancestor::en:DADokument)]", "/descendant::en:VorlaeufigeENNr[not(ancestor::en:DADokument)]"}, "ENS", true),
    FRDokument(Namespace.EN, new String[]{"/descendant::lib:FreistellungsNr[1]", "/descendant::en:VorlaeufigeFRNr[1]"}, "FR", true),
    BGSDokument(Namespace.Begleitschein, new String[]{"/descendant::lib:PaginierNr[parent::bgs:BGSNummer][1]"}, "BGS", true),
    UNSDokument(Namespace.Begleitschein, new String[]{"/descendant::lib:PaginierNr[parent::bgs:UNSNummer][1]"}, "UNS", true),
    RegisterAnforderung(Namespace.Register, new String[]{"/descendant::lib:RegisterNr"}, "RA", false),
    RegisterAuszug(Namespace.Register, new String[]{"concat(/descendant::lib:RegisterNr,'_',/descendant::reg:LfdNrTeilauszug)"}, "RG", true),
    Abfallverbringungsdokument(Namespace.Notifizierung, new String[]{"/descendant::userram:NotificationIdentificationID", "concat(/descendant::userram:CorrespondingNotificationIdentificationID,'_',/descendant::userram:ConsecutiveTransportNumberNumeric)"}, "AVD", false),
    Quittung(Namespace.Nachricht, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "QT", false),
    Mitteilung(Namespace.Nachricht, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "MT", false),
    Registrierungsantrag(Namespace.ZKS, new String[]{"/descendant::zks:AntragUUID"}, "RAN", false),
    RegistrierungsantragZKS(Namespace.ZKS, new String[]{"/descendant::zks:AntragUUID"}, "RAN", false),
    Registrierungsauftrag(Namespace.ZKS, new String[]{"/descendant::zks:AntragUUID"}, "RAU", false),
    RegistrierungsauftragZKS(Namespace.ZKS, new String[]{"/descendant::zks:AntragUUID"}, "RAU", false),
    ZKSAuftrag(Namespace.ZKS, new String[]{"/descendant::zks:AuftragUUID"}, "ZKA", false),
    ZKSErgebnis(Namespace.ZKS, new String[]{"/descendant::zks:AuftragUUID"}, "ZKE", false),
    ZKSParameterAnfrage(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "PAN", false),
    ZKSParameterErgebnis(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "PAT", false),
    EGFDokument(Namespace.EN, new String[]{"/descendant::lib:NachweisNr"}, "EGF", false),
    AGSBescheid(Namespace.AGS, new String[]{"/descendant::lib:NachweisNr"}, "EGB", false),
    DADokument(Namespace.DA, new String[]{"/descendant::lib:NachweisNr"}, "DAD", false),
    Adressanfrage(Namespace.ZKS, new String[]{"/descendant::zks:AnfrageUUID"}, "ASA", false),
    Adressantwort(Namespace.ZKS, new String[]{"/descendant::zks:AnfrageUUID"}, "ASL", false),
    Adressanforderung(Namespace.ZKS, new String[]{"/descendant::zks:AnforderungUUID"}, "AST", false),
    Adressauskunft(Namespace.ZKS, new String[]{"/descendant::zks:AnforderungUUID"}, "ASZ", false),
    Nachweisliste(Namespace.ZKS, new String[]{"/descendant::lib:PaginierNr"}, "NWL", false),
    Zertifikatsuebermittlung(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "RZT", false),
    BGSNrAnforderung(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "NRA", false),
    BGSNrZuteilung(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "NRZ", false),
    Registrierungsquittung(Namespace.ZKS, new String[]{"/msg:Nachricht/@msg:MsgUUID"}, "RQT", false),
    ENSNVorlageLayerRE(Namespace.EN, new String[]{"/descendant::lib:NachweisNr", "/descendant::en:VorlaeufigeENNr"}, "Intern", false),
    Envelope(Namespace.osci, new String[]{"//osci:ControlBlock"}, "OSCI", false);

    private final Namespace _ns;
    private final String[] _xPathNummer;
    private final String _bmuType;
    private final boolean _layerDoc;
    private static final Map<String, BMUMessageTypeEnum> LOOKUPMAP;

    private BMUMessageTypeEnum(Namespace ns, String[] xPathNummer, String bmuType, boolean layerDoc) {
        this._ns = ns;
        this._xPathNummer = xPathNummer;
        this._bmuType = bmuType;
        this._layerDoc = layerDoc;
    }

    public Namespace getNS() {
        return this._ns;
    }

    public String[] getXPathNummer() {
        return this._xPathNummer;
    }

    public String getBMUType() {
        return this._bmuType;
    }

    public boolean isLayerDoc() {
        return this._layerDoc;
    }

    public static BMUMessageTypeEnum lookup(String msgType) {
        return LOOKUPMAP.get(msgType);
    }

    static {
        LOOKUPMAP = new HashMap<String, BMUMessageTypeEnum>();
        for (BMUMessageTypeEnum s : EnumSet.allOf(BMUMessageTypeEnum.class)) {
            LOOKUPMAP.put(s._bmuType, s);
        }
    }
}

