/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.def;

import de.consist.bmu.rule.BMUVersion;
import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.def.MeldungTypImpl;
import de.consist.bmu.rule.def.XmlBMUVersionAdapter;
import de.consist.bmu.rule.def.XmlDateAdapter;
import de.consist.bmu.rule.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ruledef", propOrder={"_version", "_id", "_name", "_docTypes", "_enabled", "_keyDate", "_cancel", "_meldung", "_beschreibung", "_keyToDate", "_useSignatureDate"})
@XmlRootElement(name="RuleDef")
public class RuleDefImpl
implements RuleDef {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Version")
    @XmlJavaTypeAdapter(value=XmlBMUVersionAdapter.class)
    private BMUVersion _version;
    @XmlElement(name="Id")
    private String _id;
    @XmlElement(name="Name")
    private String _name;
    @XmlElement(name="Dokumententypen")
    private List<String> _docTypes;
    @XmlElement(name="Aktiviert")
    private boolean _enabled;
    @XmlElement(name="Stichtag")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    private Date _keyDate;
    @XmlElement(name="Abbruch")
    private boolean _cancel;
    @XmlElement(name="Meldung", type=MeldungTypImpl.class)
    private MeldungTyp _meldung;
    @XmlElement(name="Info")
    private String _beschreibung;
    @XmlElement(name="StichtagBis")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    private Date _keyToDate;
    @XmlElement(name="VerwendeSignaturDatum")
    private boolean _useSignatureDate;

    public RuleDefImpl() {
    }

    public RuleDefImpl(String id, String name, List<String> docTypes, boolean enabled, Date keyDate, boolean cancel, MeldungTyp meldung, String beschreibung, Date keyToDate, boolean useSignatureDate) {
        this._id = id;
        this._name = name;
        this._docTypes = docTypes;
        this._enabled = enabled;
        this._keyDate = keyDate;
        this._cancel = cancel;
        this._meldung = meldung;
        this._version = BMUVersion.V104;
        this._beschreibung = beschreibung;
        this._keyToDate = keyToDate != null ? keyToDate : new Date(Long.MAX_VALUE);
        this._useSignatureDate = useSignatureDate;
    }

    public RuleDefImpl(RuleDef source) {
        this._id = source.getId();
        this._name = source.getName();
        if (source.getDocTypes() != null) {
            this._docTypes = new ArrayList<String>();
            for (String docType : source.getDocTypes()) {
                this._docTypes.add(docType);
            }
        }
        this._enabled = source.isEnabled();
        this._keyDate = source.getKeyDate();
        this._cancel = source.isAbbruch();
        this._meldung = new MeldungTypImpl(source.getMeldung());
        this._version = source.getVersion();
        this._beschreibung = source.getBeschreibung();
        this._keyToDate = source.getKeyToDate();
        this._useSignatureDate = source.getUseSignatureDate();
    }

    @Override
    public final String getId() {
        return this._id;
    }

    @Override
    public final void setId(String id) {
        this._id = id;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final void setName(String name) {
        this._name = name;
    }

    @Override
    public final List<String> getDocTypes() {
        return this._docTypes;
    }

    @Override
    public final void setDocTypes(List<String> docTypes) {
        this._docTypes = docTypes;
    }

    @Override
    public final boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public final Date getKeyDate() {
        return this._keyDate;
    }

    @Override
    public final void setKeyDate(Date keyDate) {
        this._keyDate = keyDate;
    }

    @Override
    public final boolean isAbbruch() {
        return this._cancel;
    }

    @Override
    public final void setAbbruch(boolean cancel) {
        this._cancel = cancel;
    }

    @Override
    public final MeldungTyp getMeldung() {
        return this._meldung;
    }

    @Override
    public final void setMeldung(MeldungTyp meldung) {
        this._meldung = meldung;
    }

    @Override
    public final BMUVersion getVersion() {
        return this._version;
    }

    @Override
    public final String getBeschreibung() {
        return this._beschreibung;
    }

    @Override
    public final void setBeschreibung(String beschreibung) {
        this._beschreibung = beschreibung;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version=" + this._version);
        builder.append(", Id=" + this._id);
        builder.append(", Name=" + this._name);
        builder.append(", Dokumenttypen: " + this._docTypes);
        builder.append(", Aktiviert=" + this._enabled);
        builder.append(", Stichtag=" + DateUtils.toDateString(this._keyDate));
        builder.append(", Abbruch=" + this._cancel);
        builder.append(", Meldung: {" + this._meldung + "}");
        builder.append(", Beschreibung=" + this._beschreibung);
        builder.append(", StichtagBis=" + (this._keyToDate != null ? DateUtils.toDateString(this._keyToDate) : "null"));
        builder.append(", VerwendeSignaturDatum=" + this._useSignatureDate);
        return builder.toString();
    }

    @Override
    public Date getKeyToDate() {
        if (this._keyToDate == null) {
            return new Date(Long.MAX_VALUE);
        }
        return this._keyToDate;
    }

    @Override
    public void setKeyToDate(Date keyToDate) {
        this._keyToDate = keyToDate;
    }

    @Override
    public boolean getUseSignatureDate() {
        return this._useSignatureDate;
    }

    @Override
    public void setUseSignatureDate(boolean useSignatureDate) {
        this._useSignatureDate = useSignatureDate;
    }

    public static class RuleDefComparator
    implements Comparator<RuleDef>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public final int compare(RuleDef o1, RuleDef o2) {
            if (o1.getMeldung().getStufe().ordinal() < o2.getMeldung().getStufe().ordinal()) {
                return -1;
            }
            if (o1.getMeldung().getStufe().ordinal() > o2.getMeldung().getStufe().ordinal()) {
                return 1;
            }
            if (o1.isAbbruch()) {
                if (!o2.isAbbruch()) {
                    return -1;
                }
            } else if (o2.isAbbruch()) {
                return 1;
            }
            return 0;
        }
    }

    public static class Adapter
    extends XmlAdapter<RuleDefImpl, RuleDef> {
        public final RuleDef unmarshal(RuleDefImpl ruleDefImpl) {
            return ruleDefImpl;
        }

        public final RuleDefImpl marshal(RuleDef ruleDef) {
            return (RuleDefImpl)ruleDef;
        }
    }
}

