/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplDateiname
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_DATEINAME = "/descendant::*[local-name()='Dateianhang' and @lib:id]";
    private static final char[] PATH_CHARS = new char[]{'/', '\\', ':', '*', '?'};
    private static final String TECHDOC = "\u00dcberpr\u00fcft das Attribut 'dateiname' in allen Dateianh\u00e4ngen (Element 'Dateianhang') auf das Vorkommen von " + String.valueOf(PATH_CHARS) + " Verwendeter XPath: /descendant::*[local-name()='Dateianhang' and @lib:id]";

    public RuleImplDateiname(RuleDef ruleDef) {
        super(ruleDef);
    }

    public boolean isValid(String dateiname) {
        if (dateiname == null) {
            throw new IllegalArgumentException("dateiname must not be null");
        }
        boolean valid = true;
        for (char pathChar : PATH_CHARS) {
            if (dateiname.indexOf(pathChar) < 0) continue;
            valid = false;
        }
        return valid;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_DATEINAME);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elemDateianhang = (Element)nl.item(i);
            String dateiname = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "dateiname");
            if (this.isValid(dateiname)) continue;
            String id = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

