/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;

public final class RuleImplEGFAktennummer
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_AKTENNUMMER = "(count(/descendant::lib:NachweisNr)=0 or contains(/descendant::lib:NachweisNr, 'XXXXXXXXX')) and string-length(/descendant::en:AktenNummer)<36";

    public RuleImplEGFAktennummer(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_AKTENNUMMER)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), 1, null));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("Es wird gepr\u00fcft, ob das Feld Sonstiges/Aktennumer gef\u00fcllt ist, wenn das Feld Nachweisnummer ");
        builder.append("\u0082EN?XXXXXXXXX\u0091 oder \u0082SN?XXXXXXXXX\u0091 enth\u00e4lt, wobei das '?' ");
        builder.append("durch den jeweiligen Landeskenner zu ersetzen ist, oder ob eines der beiden Felder ");
        builder.append("Nachweisnummer oder Sonstiges/Aktennummer gef\u00fcllt ist (Mindestl\u00e4nge 36 Zeichen).");
        builder.append(" XPath f\u00fcr die Pr\u00fcfung: ");
        builder.append(XPATH_AKTENNUMMER);
        return builder.toString();
    }
}

