/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.SchemaValidator;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public final class RuleImplFXSTyp
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplFXSTyp.class);

    public RuleImplFXSTyp(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> validateSubDoc(Node node, int index, String id) throws BMUException {
        LOGGER.debug((Object)("Validating sub-structure with id: " + id));
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = XmlUtils.newDocument(true);
        Node importedNode = doc.importNode(node, true);
        doc.appendChild(importedNode);
        doc.normalizeDocument();
        SchemaValidator.ValidationErrorHandler handler = SchemaValidator.getInstance().validate(doc.getDocumentElement());
        if (handler != null) {
            List<SAXParseException> errorList = handler.getErrorList();
            if (!errorList.isEmpty()) {
                for (SAXParseException saxParseException : errorList) {
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id + ", " + saxParseException.getMessage()));
                }
            }
        } else {
            LOGGER.error((Object)"Error validating document");
            throw new BMUException("Error validating document");
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        NodeList nodeList = null;
        Element elem = null;
        int index = 1;
        for (FXSTyp fxsTyp : FXSTyp.values()) {
            boolean typeMatch = false;
            for (BMUMessageTypeEnum bMUMessageTypeEnum : fxsTyp._parentTypes) {
                if (!bMUMessageTypeEnum.equals((Object)bmuDok.getMessageType().getEnumType())) continue;
                typeMatch = true;
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace((Object)("type match: " + bMUMessageTypeEnum));
            }
            if (!typeMatch) continue;
            try {
                nodeList = XPathFassade.getInstance().evaluateNodeList(doc, fxsTyp._xPath);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    elem = (Element)nodeList.item(i);
                    String id = XPathFassade.getInstance().evaluate(elem, "parent::*/@lib:id");
                    boolean docMatch = false;
                    for (FXSDoc fxsDoc : fxsTyp._fxsDocs) {
                        if (!fxsDoc._nodeName.equals(elem.getLocalName()) || !fxsDoc._nsURI.equals(elem.getNamespaceURI())) continue;
                        docMatch = true;
                        if (!LOGGER.isTraceEnabled()) break;
                        LOGGER.trace((Object)("doc match: " + fxsDoc));
                        break;
                    }
                    if (!docMatch) {
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                        continue;
                    }
                    List<RuleResult> list = this.validateSubDoc(elem, index, id);
                    index += list.size();
                    ruleResultList.addAll(list);
                }
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr AGSBescheid: ");
        builder.append(FXSTyp.AGSBESCHEID._xPath);
        builder.append("\n");
        builder.append("XPath f\u00fcr Deklarationsanalyse: ");
        builder.append(FXSTyp.DA._xPath);
        builder.append("\n");
        builder.append("XPath f\u00fcr Notifizierung: ");
        builder.append(FXSTyp.NTZ._xPath);
        builder.append("\n");
        builder.append("XPath f\u00fcr Versandbegleitformular: ");
        builder.append((Object)FXSTyp.VBF);
        builder.append("\n");
        builder.append("XPath f\u00fcr EUDINConfirmationOfMessageReceipt: ");
        builder.append((Object)FXSTyp.COMR);
        builder.append("\n");
        builder.append("XPath f\u00fcr EUDINWasteTransportStatement: ");
        builder.append((Object)FXSTyp.WTS);
        builder.append("\n");
        builder.append("XPath f\u00fcr FreieXMLStruktur in Registrierungsantrag: ");
        builder.append((Object)FXSTyp.BTR_UM);
        return builder.toString();
    }

    private static enum FXSTyp {
        AGSBESCHEID("/descendant::en:AGSBescheid/*", new FXSDoc[]{FXSDoc.AGSBESCHEID}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.ENSNDokument}),
        DA("/descendant::en:Deklarationsanalyse/*", new FXSDoc[]{FXSDoc.DA}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.ENSNDokument, BMUMessageTypeEnum.DADokument, BMUMessageTypeEnum.RegisterAuszug}),
        NTZ("/descendant::ntz:Notifzierung/*", new FXSDoc[]{FXSDoc.NTZ, FXSDoc.NTZ_G11}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.Abfallverbringungsdokument}),
        VBF("/descendant::ntz:VersandBegleitformular/*", new FXSDoc[]{FXSDoc.VBF_WR, FXSDoc.VBF_WD, FXSDoc.VBF_WM, FXSDoc.VBF_G11}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.Abfallverbringungsdokument}),
        COMR("/descendant::ntz:CoMR-Dokument/*", new FXSDoc[]{FXSDoc.COMR}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.Abfallverbringungsdokument}),
        WTS("/descendant::ntz:WasteTransportStatement/*", new FXSDoc[]{FXSDoc.WTS}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.Abfallverbringungsdokument}),
        BTR_UM("/descendant::zks:FreieXMLStruktur[parent::zks:Antrag]/*", new FXSDoc[]{FXSDoc.BTR_UM}, new BMUMessageTypeEnum[]{BMUMessageTypeEnum.Registrierungsantrag, BMUMessageTypeEnum.RegistrierungsantragZKS});

        private String _xPath;
        private FXSDoc[] _fxsDocs;
        private BMUMessageTypeEnum[] _parentTypes;

        private FXSTyp(String xPath, FXSDoc[] fxsDocs, BMUMessageTypeEnum[] parentTypes) {
            this._xPath = xPath;
            this._fxsDocs = fxsDocs;
            this._parentTypes = parentTypes;
        }
    }

    private static enum FXSDoc {
        AGSBESCHEID("AGSBescheid", "uri:BMU_Waste_Interface/AGS"),
        DA("Deklarationsanalyse", "uri:BMU_Waste_Interface/DA"),
        NTZ("EUDINNotificationDocument", "usr:EUDINNotificationDocument:2:1"),
        VBF_WR("EUDINCertificateOfWasteReceiptDocument", "usr:EUDINCertificateOfWasteReceiptDocument:2:1"),
        VBF_WD("EUDINCertificateOfWasteRecoveryDisposalDocument", "usr:EUDINCertificateOfWasteRecoveryDisposalDocument:2:1"),
        VBF_WM("EUDINWasteMovementDocument", "usr:EUDINWasteMovementDocument:2:1"),
        COMR("EUDINConfirmationOfMessageReceipt", "usr:EUDINConfirmationOfMessageReceipt:2:1"),
        WTS("EUDINWasteTransportStatement", "usr:EUDINWasteTransportStatement:2:1"),
        BTR_UM("Antragsobjekt", "urn:de:bmu:eanv:zks:ZKSBetriebUmhang:1:04"),
        NTZ_G11("Message", "Waste-WG-2018-Message"),
        VBF_G11("Message", "Waste-WG-2018-Message");

        private String _nodeName;
        private String _nsURI;

        private FXSDoc(String nodeName, String nsURI) {
            this._nodeName = nodeName;
            this._nsURI = nsURI;
        }
    }
}

