/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.SchemaValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public final class RuleImplSchemaValidationDT
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSchemaValidationDT.class);
    public static int MAX_MSG_LEN = 255;

    public RuleImplSchemaValidationDT(RuleDef ruleDef) {
        super(ruleDef);
    }

    List<RuleResult> executeInternal(Document doc) throws BMUException {
        ArrayList<RuleResult> ruleResultList;
        block6: {
            ruleResultList = new ArrayList<RuleResult>();
            int index = 1;
            try {
                SchemaValidator validator = SchemaValidator.getInstance();
                SchemaValidator.ValidationErrorHandler handler = validator.validateDt(doc.getDocumentElement());
                if (handler != null) {
                    List<SAXParseException> errorList = handler.getErrorList();
                    if (!errorList.isEmpty()) {
                        for (SAXParseException saxParseException : errorList) {
                            String msg = saxParseException.getLocalizedMessage();
                            if (msg.length() > MAX_MSG_LEN) {
                                msg = msg.substring(0, MAX_MSG_LEN);
                            }
                            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, msg));
                        }
                    }
                    break block6;
                }
                LOGGER.error((Object)"Error validating document");
                throw new BMUException("Error validating document");
            }
            catch (BMUException e) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, e.getMessage()));
            }
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        return this.executeInternal(bmuDok.getDocument());
    }

    public static String getTechDoc() {
        return "Die Schemavalidierung erfolgt mit der DOM3-Implementierung von Xerces-J";
    }
}

