/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.BMUKopfdaten;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureID
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String[] XPATH_BGS_SIG = new String[]{"/descendant::bgs:BGSVorlageLayer/ds:Signature", "/descendant::bgs:BGSErgaenzungsLayer/ds:Signature"};
    private static final String[] XPATH_BGS_SIG_ID = new String[]{"/descendant::bgs:BGSERZLayer/ds:Signature/@Id[not(starts-with(.,'ERZ'))]", "/descendant::bgs:BGSBEFLayer/ds:Signature/@Id[not(starts-with(.,'BEF'))]", "/descendant::bgs:BGSZWLLayer/ds:Signature/@Id[not(starts-with(.,'ZWL'))]", "/descendant::bgs:BGSENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]", "/descendant::bgs:BGSBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]"};
    private static final String[] XPATH_ENSN_SIG = new String[]{"/descendant::en:ENSNVorlageLayer/ds:Signature", "/descendant::en:ENSNErgaenzungsLayer/ds:Signature"};
    private static final String[] XPATH_ENSN_SIG_ID = new String[]{"/descendant::en:ENSNENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]", "/descendant::en:ENSNBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]"};
    private static final String XPATH_EN_SIG_ID = "/descendant::en:ENSNERZLayer/ds:Signature/@Id[not(starts-with(.,'ERZ')) and not(starts-with(.,'BVE'))]";
    private static final String XPATH_SN_SIG_ID = "/descendant::en:ENSNERZLayer/ds:Signature/@Id[not(starts-with(.,'BEF'))]";
    private static final String[] XPATH_UNS_SIG = new String[]{"/descendant::bgs:UNSVorlageLayer/ds:Signature", "/descendant::bgs:UNSBasisLayer/ds:Signature", "/descendant::bgs:UNSErgaenzungsLayer/ds:Signature"};
    private static final String[] XPATH_FR_SIG_ID = new String[]{"/descendant::en:FRENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]", "/descendant::en:FRBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]"};
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureID.class);

    public RuleImplSignatureID(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> checkSignatureIdATBRolle(Document doc, String xPath, int index) throws BMUException {
        NodeList sigNodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            sigNodeList = XPathFassade.getInstance().evaluateNodeList(doc, xPath);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int foundIndex = index;
        for (int i = 0; i < sigNodeList.getLength(); ++i) {
            String atbRolle;
            BMUKopfdaten.Rolle rolle;
            Element sigNode = (Element)sigNodeList.item(i);
            Element layerNode = (Element)sigNode.getParentNode();
            String sigID = sigNode.getAttribute("Id");
            if (sigID.startsWith((rolle = BMUKopfdaten.Rolle.valueOf(atbRolle = layerNode.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBRolle"))).getIDRolle())) continue;
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), foundIndex++, sigID));
        }
        return ruleResultList;
    }

    private List<RuleResult> checkSignatureId(Document doc, String xPath, int index) throws BMUException {
        NodeList layerNodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            layerNodeList = XPathFassade.getInstance().evaluateNodeList(doc, xPath);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        for (int i = 0; i < layerNodeList.getLength(); ++i) {
            Node sigIdNode = layerNodeList.item(i);
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index + i, sigIdNode.getTextContent()));
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        int index = 1;
        switch (msgType.getEnumType()) {
            case BGSDokument: {
                for (String xPath : XPATH_BGS_SIG) {
                    ruleResultList.addAll(this.checkSignatureIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                for (String xPath : XPATH_BGS_SIG_ID) {
                    ruleResultList.addAll(this.checkSignatureId(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case UNSDokument: {
                for (String xPath : XPATH_UNS_SIG) {
                    ruleResultList.addAll(this.checkSignatureIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case ENSNDokument: {
                for (String xPath : XPATH_ENSN_SIG) {
                    ruleResultList.addAll(this.checkSignatureIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                for (String xPath : XPATH_ENSN_SIG_ID) {
                    ruleResultList.addAll(this.checkSignatureId(doc, xPath, index + ruleResultList.size()));
                }
                if (BMUMessageType.ENStatus.EN.equals((Object)msgType.getENStatus())) {
                    ruleResultList.addAll(this.checkSignatureId(doc, XPATH_EN_SIG_ID, index + ruleResultList.size()));
                    break;
                }
                if (BMUMessageType.ENStatus.SN.equals((Object)msgType.getENStatus())) {
                    ruleResultList.addAll(this.checkSignatureId(doc, XPATH_SN_SIG_ID, index + ruleResultList.size()));
                    break;
                }
                LOGGER.warn((Object)"Pr\u00fcfregel 'SignatureID' wird nicht vollst\u00e4ndig angewendet, weil nicht ermittelt werden konnte, ob es sich um einen EN oder SN handelt!");
                break;
            }
            case FRDokument: {
                for (String xPath : XPATH_FR_SIG_ID) {
                    ruleResultList.addAll(this.checkSignatureId(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + msgType.getEnumType()));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Begleitscheinen");
        builder.append("\n");
        builder.append("1. Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_SIG));
        builder.append("\n");
        builder.append("2. Rolle in der Signatur-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_SIG_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von \u00dcbernahmescheinen (Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_UNS_SIG));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Nachweisen");
        builder.append("\n");
        builder.append("1. Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_SIG));
        builder.append("\n");
        builder.append("2. Rolle in der Signatur-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_SIG_ID));
        builder.append("\n");
        builder.append("XPath f\u00fcr die Pr\u00fcfung von Entsorgungsnachweisen: ");
        builder.append(XPATH_EN_SIG_ID);
        builder.append("\n");
        builder.append("XPath f\u00fcr die Pr\u00fcfung von Sammelentsorgungsnachweisen: ");
        builder.append(XPATH_SN_SIG_ID);
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Freistellungen (Rolle in der Signatur-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_FR_SIG_ID));
        return builder.toString();
    }
}

