/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplTextLength
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 255;
    private static final Log LOGGER = LogFactory.getLog(RuleImplTextLength.class);
    private static final String[] XPATH_ENS_TEXT_LENGTH = new String[]{"en:Erklaerung/en:Zusatz"};
    private static final String[] XPATH_MT_TEXT_LENGTH = new String[]{"msg:Mitteilung/msg:Thema", "msg:Mitteilung/msg:Bezug"};
    private static final String XPATH_BGS_SORTIMENT = "/descendant::bgs:Sortiment[parent::bgs:AltholzV]";

    public RuleImplTextLength(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> evalTextLength(Document doc, String[] xPathes) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (String xpFT : xPathes) {
            try {
                if (!XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "string-length(/descendant::" + xpFT + ")>255")) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, xpFT));
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
        }
        return ruleResultList;
    }

    private List<RuleResult> evalBGSSortiment(Document doc) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            NodeList nl = XPathFassade.getInstance().evaluateNodeList(doc, XPATH_BGS_SORTIMENT);
            int maxIndex = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                String indexString = e.getAttributeNS(Namespace.TypenBibliothek.getUri(), "Index");
                int index = Integer.parseInt(indexString);
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            int codeIndex = 1;
            for (int i = 0; i <= maxIndex; ++i) {
                String xPath = "/descendant::bgs:Sortiment[@lib:Index=" + i + "][last()]/bgs:Informationen";
                String info = XPathFassade.getInstance().evaluate(doc, xPath);
                if (info.length() <= 255) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), codeIndex++, xPath));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        switch (msgType.getEnumType()) {
            case ENSNDokument: {
                ruleResultList.addAll(this.evalTextLength(doc, XPATH_ENS_TEXT_LENGTH));
                break;
            }
            case BGSDokument: {
                ruleResultList.addAll(this.evalBGSSortiment(doc));
                break;
            }
            case Mitteilung: {
                ruleResultList.addAll(this.evalTextLength(doc, XPATH_MT_TEXT_LENGTH));
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + msgType.getEnumType()));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung von Sortimenten in Begleitscheinen: ");
        builder.append(XPATH_BGS_SORTIMENT);
        builder.append("\n");
        builder.append("XPath f\u00fcr die Pr\u00fcfung der L\u00e4nge des Elements 'Informationen' im 'Sortiment' mit Index X: ");
        builder.append("string-length(/descendant::bgs:Sortiment[@lib:Index=X][last()]/bgs:Informationen)>255");
        builder.append("\n");
        builder.append("XPath f\u00fcr die Pr\u00fcfung von Texten in Nachweisen: ");
        builder.append("string-length(/descendant::");
        builder.append(XPATH_ENS_TEXT_LENGTH[0]);
        builder.append(")>255");
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Texten in Mitteilungen: ");
        for (String xPath : XPATH_MT_TEXT_LENGTH) {
            builder.append("string-length(/descendant::");
            builder.append(xPath);
            builder.append(")>255, ");
        }
        return builder.toString();
    }
}

