/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUVersion;
import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.RuleSetResult;
import de.consist.bmu.rule.def.MeldungTypImpl;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.BMUKopfdaten;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.schema.SchemaValidator;
import de.consist.bmu.rule.util.DIN_SPEC_91379;
import de.consist.bmu.rule.util.XmlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="rulesetresult", propOrder={"_bmuDokument", "_ruleResultList", "_bezugResult", "_meldungTypList", "_zKSMeldungTypList", "_fehlerStufe", "_status"})
@XmlRootElement(name="Pruefergebnis")
public final class RuleSetResultImpl
implements RuleSetResult,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleSetResultImpl.class);
    public static final String UUID_FEHLER = "ABCDEF12-1234-1234-1234-123456789232";
    private transient RuleSet _ruleSet;
    @XmlElement(name="BMUDokument")
    private BMUDokument _bmuDokument;
    @XmlElement(name="Ergebnisse")
    private List<RuleResult> _ruleResultList;
    @XmlElement(name="Bezug", type=RuleResultImpl.class)
    private RuleResult _bezugResult;
    @XmlElement(name="Meldungen")
    private List<MeldungTyp> _meldungTypList = new ArrayList<MeldungTyp>();
    @XmlElement(name="ZKS-Meldungen")
    private List<MeldungTyp> _zKSMeldungTypList = new ArrayList<MeldungTyp>();
    @XmlElement(name="Fehlerstufe")
    private MeldungTyp.FehlerStufe _fehlerStufe;
    @XmlElement(name="Status")
    private RuleSetResult.Status _status;

    public RuleSetResultImpl() {
    }

    public RuleSetResultImpl(MeldungTyp.FehlerStufe stufe) {
        this._fehlerStufe = stufe;
        this._ruleResultList = new ArrayList<RuleResult>();
    }

    public RuleSetResultImpl(BMUDokument bmuDok, RuleSet ruleSet, List<RuleResult> list, RuleResult bezugResult, MeldungTyp.FehlerStufe fehlerStufe, RuleSetResult.Status status) {
        this._bmuDokument = bmuDok;
        this._ruleSet = ruleSet;
        this._ruleResultList = list;
        this._bezugResult = bezugResult;
        this._fehlerStufe = fehlerStufe;
        this._status = status;
    }

    @Override
    public List<RuleResult> getList() {
        return this._ruleResultList;
    }

    @Override
    public BMUDokument getBMUDokument() {
        return this._bmuDokument;
    }

    @Override
    public RuleSet getRuleSet() {
        return this._ruleSet;
    }

    @Override
    public void addMeldung(String klasse, String stufe, String beschreibung, String code, String abhilfe) {
        MeldungTypImpl meldung = new MeldungTypImpl(MeldungTyp.FehlerKlasse.valueOf(klasse), MeldungTyp.FehlerStufe.valueOf(stufe), beschreibung, code, abhilfe);
        this._meldungTypList.add(meldung);
        if (meldung.getStufe().ordinal() < this._fehlerStufe.ordinal()) {
            if (MeldungTyp.FehlerStufe.INFO.equals((Object)this._fehlerStufe)) {
                this._bezugResult = new RuleResultImpl(this._ruleSet.getRuleDefBezugError(), 1, this._bezugResult.getMessage());
            }
            this._fehlerStufe = meldung.getStufe();
        }
    }

    @Override
    public void addZKSMeldung(String klasse, String stufe, String beschreibung, String code, String abhilfe) {
        MeldungTypImpl meldung = new MeldungTypImpl(MeldungTyp.FehlerKlasse.valueOf(klasse), MeldungTyp.FehlerStufe.valueOf(stufe), beschreibung, code, abhilfe);
        this._zKSMeldungTypList.add(meldung);
    }

    @Override
    public RuleResult getBezugResult() {
        return this._bezugResult;
    }

    @Override
    public MeldungTyp.FehlerStufe getHoechsteFehlerstufe() {
        return this._fehlerStufe;
    }

    @Override
    public RuleSetResult.Status getStatus() {
        return this._status;
    }

    @Override
    public Document toQuittung() throws BMUException {
        Document docQuittung = null;
        docQuittung = XmlUtils.newDocument(true);
        Element quittung = docQuittung.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Quittung");
        quittung.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Spezifikationsversion", BMUVersion.V104.getVersion());
        String bezugMsgUUID = null;
        if (this._bmuDokument != null) {
            bezugMsgUUID = this._bmuDokument.getMessageType().getMsgUUID();
        }
        if (bezugMsgUUID == null || bezugMsgUUID.length() == 0) {
            bezugMsgUUID = UUID_FEHLER;
        }
        quittung.setAttributeNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":BezugMsgUUID", bezugMsgUUID);
        MeldungTypImpl bezugMeldung = (MeldungTypImpl)this._bezugResult.getRuleDef().getMeldung();
        Element bezug = bezugMeldung.toXml(docQuittung, this._bezugResult.getMessage(), this._bezugResult.getIndex());
        quittung.appendChild(bezug);
        for (RuleResult ruleResult : this._ruleResultList) {
            MeldungTyp meldungTyp = (MeldungTypImpl)ruleResult.getRuleDef().getMeldung();
            String msg = ruleResult.getMessage();
            if ("SchemaValidationDT".equals(ruleResult.getRuleDef().getName())) {
                LOGGER.debug((Object)"Unzulaessige Zeichen im Meldungstext werden durch 'X' ersetzt.");
                msg = DIN_SPEC_91379.replace(msg, 'X');
            }
            Element meldung = ((MeldungTypImpl)meldungTyp).toXml(docQuittung, msg, ruleResult.getIndex());
            quittung.appendChild(meldung);
        }
        int index = 1;
        for (MeldungTyp meldungTyp : this._meldungTypList) {
            Element meldung = ((MeldungTypImpl)meldungTyp).toXml(docQuittung, null, index++);
            quittung.appendChild(meldung);
        }
        Object var7_10 = null;
        if (this._bmuDokument != null && this._bmuDokument.getMessageType().isMessage()) {
            BMUKopfdaten bMUKopfdaten = BMUKopfdaten.getKopfdaten(this._bmuDokument.getDocument());
            if (bMUKopfdaten.getEmpfaenger() != null) {
                Element nachricht = docQuittung.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Nachricht");
                nachricht.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Spezifikationsversion", BMUVersion.V104.getVersion());
                nachricht.setAttributeNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":MsgUUID", UUID.randomUUID().toString());
                nachricht.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Nachrichtenstatus", "ORI");
                Element kopfdaten = bMUKopfdaten.toXml(docQuittung);
                nachricht.appendChild(kopfdaten);
                Element nutzdaten = docQuittung.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Nutzdaten");
                nachricht.appendChild(nutzdaten);
                nutzdaten.appendChild(quittung);
                docQuittung.appendChild(nachricht);
            } else {
                LOGGER.warn((Object)"Der Empfaenger in den Kopfdaten der Nachricht fehlt, Quittung wird als Nutzdatendokument erzeugt.");
                docQuittung.appendChild(quittung);
            }
        } else {
            LOGGER.info((Object)"Das BMU-Dokument ist nicht vom Typ 'Nachricht', Quittung wird als Nutzdatendokument erzeugt.");
            docQuittung.appendChild(quittung);
        }
        SchemaValidator.ValidationErrorHandler handler = SchemaValidator.getInstance().validate(docQuittung.getDocumentElement());
        if (handler != null) {
            List<SAXParseException> errorList = handler.getErrorList();
            if (!errorList.isEmpty()) {
                LOGGER.error((Object)"Die erzeugte BMU-Quittung ist nicht schemavalide.", (Throwable)errorList.get(0));
                throw new BMUException("Die erzeugte BMU-Quittung ist nicht schemavalide.", errorList.get(0));
            }
        } else {
            LOGGER.error((Object)"Fehler bei der Schemavalidierung der BMU-Quittung.");
            throw new BMUException("Fehler bei der Schemavalidierung der BMU-Quittung.");
        }
        return docQuittung;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nH\u00f6chste Fehlerstufe: " + this._fehlerStufe.toString());
        sb.append("\nBezug: ");
        sb.append(this._bezugResult);
        if (this._ruleResultList != null && this._ruleResultList.size() > 0) {
            sb.append("\nRuleResults (");
            sb.append(this._ruleResultList.size());
            sb.append("):");
            for (RuleResult ruleResult : this._ruleResultList) {
                sb.append("\n- [");
                sb.append(ruleResult);
                sb.append("] ");
            }
        }
        if (this._meldungTypList != null && this._meldungTypList.size() > 0) {
            sb.append("\nZus\u00e4tzliche Meldungen: ");
            for (MeldungTyp meldung : this._meldungTypList) {
                sb.append("[");
                sb.append(meldung);
                sb.append("] ");
            }
        }
        return sb.toString();
    }

    @Override
    public List<MeldungTyp> getMeldungList() {
        return this._meldungTypList;
    }

    @Override
    public void setFehlerstufe(MeldungTyp.FehlerStufe stufe) {
        this._fehlerStufe = stufe;
    }

    @Override
    public List<MeldungTyp> getZKSMeldungList() {
        return this._zKSMeldungTypList;
    }
}

