/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.schema;

import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BMUKopfdaten {
    private static final Log LOGGER = LogFactory.getLog(BMUKopfdaten.class);
    private static final String XPATH_ABSENDER = "/msg:Nachricht/msg:Kopfdaten/msg:Absender";
    private static final String XPATH_EMPFAENGER = "/msg:Nachricht/msg:Kopfdaten/msg:Empfaenger";
    private static final String XPATH_ANTWORT = "/msg:Nachricht/msg:Kopfdaten/msg:Antwort";
    private static final String XPATH_ZUGANGSTYP = "/@lib:Zugangstyp";
    private static final String XPATH_TEXT = "/lib:Text";
    private static final String XPATH_STRUKTUR = "/lib:Struktur";
    private static final String XPATH_BETRIEB = "/lib:BehoerdlicheNummer";
    private static final String XPATH_PROV = "/lib:Provider";
    private static final String XPATH_ZUSATZ = "/lib:Zusatzangaben";
    private static final String XPATH_BEHNR = "/lib:BehoerdlicheNr";
    private static final String XPATH_PRZ = "/lib:Pruefziffer";
    private static final String XPATH_ROLLE = "/@lib:ATBRolle";
    private BMUZugang _absender;
    private BMUZugang _empfaenger;
    private BMUZugang _antwort;

    private BehoerdlicheNummer getBehoerdlicheNummer(Document doc, String xPath) throws BMUException {
        BehoerdlicheNummer behNummer = null;
        XPathFassade xf = XPathFassade.getInstance();
        Element root = doc.getDocumentElement();
        try {
            if (xf.evalBool(root, "count(" + xPath + ") > 0")) {
                String behNr = xf.evaluate(doc, xPath + XPATH_BEHNR);
                String prz = xf.evaluate(doc, xPath + XPATH_PRZ);
                String r = xf.evaluate(doc, xPath + XPATH_ROLLE);
                Rolle rolle = Rolle.valueOf(r.trim());
                behNummer = new BehoerdlicheNummer(behNr, prz, rolle);
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Auswerten des XPath-Ausdrucks", e);
        }
        return behNummer;
    }

    private BMUZugang getZugang(Document doc, String xPath) throws BMUException {
        BMUZugang zugang;
        block7: {
            zugang = null;
            XPathFassade xf = XPathFassade.getInstance();
            Element root = doc.getDocumentElement();
            try {
                if (!xf.evalBool(root, "count(" + xPath + ") > 0")) break block7;
                String typ = xf.evaluate(doc, xPath + XPATH_ZUGANGSTYP);
                Zugangstyp zt = Zugangstyp.OSCI;
                try {
                    zt = Zugangstyp.valueOf(typ.trim());
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.info((Object)("Unbekannter Zugangstyp: " + typ));
                }
                if (xf.evalBool(root, "count(" + xPath + "/lib:Text) > 0")) {
                    String text = xf.evaluate(doc, xPath + XPATH_TEXT);
                    zugang = new BMUZugangText(zt, text);
                } else {
                    BehoerdlicheNummer btr = this.getBehoerdlicheNummer(doc, xPath + "/lib:Struktur/lib:BehoerdlicheNummer");
                    BehoerdlicheNummer prov = this.getBehoerdlicheNummer(doc, xPath + "/lib:Struktur/lib:Provider");
                    String zusatz = null;
                    if (xf.evalBool(doc.getDocumentElement(), "count(" + xPath + "/lib:Struktur/lib:Zusatzangaben) > 0")) {
                        zusatz = xf.evaluate(doc, xPath + "/lib:Struktur/lib:Zusatzangaben");
                    }
                    zugang = new BMUZugangStruktur(zt, btr, prov, zusatz);
                }
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Auswerten des XPath-Ausdrucks", e);
            }
        }
        return zugang;
    }

    private void init(Document doc) throws BMUException {
        this._absender = this.getZugang(doc, XPATH_ABSENDER);
        this._empfaenger = this.getZugang(doc, XPATH_EMPFAENGER);
        this._antwort = this.getZugang(doc, XPATH_ANTWORT);
    }

    public final BMUZugang getAbsender() {
        return this._absender;
    }

    public final BMUZugang getEmpfaenger() {
        return this._empfaenger;
    }

    public final BMUZugang getAntwort() {
        return this._antwort;
    }

    public static BMUKopfdaten getKopfdaten(Document doc) throws BMUException {
        BMUKopfdaten kp = new BMUKopfdaten();
        kp.init(doc);
        return kp;
    }

    public final Element toXml(Document doc) {
        Element kopfdaten = null;
        if (this.getEmpfaenger() != null && this.getAbsender() != null) {
            kopfdaten = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Kopfdaten");
            if (this._empfaenger != null) {
                Element absender = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Absender");
                absender.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Zugangstyp", this._empfaenger.getZugangstyp().toString());
                absender.appendChild(this._empfaenger.toXml(doc));
                kopfdaten.appendChild(absender);
            }
            BMUZugang empfZugang = null;
            if (this._antwort != null) {
                empfZugang = this._antwort;
            } else if (this._absender != null) {
                empfZugang = this._absender;
            }
            if (empfZugang != null) {
                Element empfaenger = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Empfaenger");
                empfaenger.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Zugangstyp", Zugangstyp.ZKS.toString());
                empfaenger.appendChild(empfZugang.toXml(doc));
                kopfdaten.appendChild(empfaenger);
            }
        } else {
            LOGGER.debug((Object)"Keine Empf\u00e4nger und kein Absender eingetragen");
        }
        return kopfdaten;
    }

    public static class BehoerdlicheNummer {
        private String _behNr;
        private String _pz;
        private Rolle _rolle;

        public BehoerdlicheNummer(String behNr, String pz, Rolle rolle) {
            this._behNr = behNr;
            this._pz = pz;
            this._rolle = rolle;
        }

        public final String getBehNr() {
            return this._behNr;
        }

        public final String getPZ() {
            return this._pz;
        }

        public final Rolle getRolle() {
            return this._rolle;
        }

        public final Element toXml(Document doc, String name) {
            Element behoerdlicheNummer = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":" + name);
            behoerdlicheNummer.setAttributeNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":ATBRolle", this._rolle.toString());
            Element behoerdlicheNr = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":BehoerdlicheNr");
            behoerdlicheNr.setTextContent(this._behNr);
            behoerdlicheNummer.appendChild(behoerdlicheNr);
            Element pruefziffer = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Pruefziffer");
            pruefziffer.setTextContent(this._pz);
            behoerdlicheNummer.appendChild(pruefziffer);
            return behoerdlicheNummer;
        }
    }

    public class BMUZugangText
    extends BMUZugang {
        private String _text;

        BMUZugangText(Zugangstyp typ, String text) {
            super(typ);
            this._text = text;
        }

        public final String getText() {
            return this._text;
        }

        @Override
        public final Element toXml(Document doc) {
            Element text = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Text");
            text.setTextContent(this._text);
            return text;
        }
    }

    public class BMUZugangStruktur
    extends BMUZugang {
        private BehoerdlicheNummer _behNummer;
        private BehoerdlicheNummer _provider;
        private String _zusatzAngaben;

        BMUZugangStruktur(Zugangstyp typ, BehoerdlicheNummer btr, BehoerdlicheNummer prov, String zusatz) {
            super(typ);
            this._behNummer = btr;
            this._provider = prov;
            this._zusatzAngaben = zusatz;
        }

        public final BehoerdlicheNummer getBehNummer() {
            return this._behNummer;
        }

        public final BehoerdlicheNummer getProvider() {
            return this._provider;
        }

        public final String getZusatzangaben() {
            return this._zusatzAngaben;
        }

        @Override
        public final Element toXml(Document doc) {
            Element struktur = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Struktur");
            Element behoerdlicheNummer = this._behNummer.toXml(doc, "BehoerdlicheNummer");
            struktur.appendChild(behoerdlicheNummer);
            if (this._provider != null) {
                Element provider = this._provider.toXml(doc, "Provider");
                struktur.appendChild(provider);
            }
            if (this._zusatzAngaben != null) {
                Element zusatzangaben = doc.createElementNS(Namespace.TypenBibliothek.getUri(), Namespace.TypenBibliothek.getPrefix() + ":Zusatzangaben");
                zusatzangaben.setTextContent(this._zusatzAngaben);
                struktur.appendChild(zusatzangaben);
            }
            return struktur;
        }
    }

    public abstract class BMUZugang {
        private Zugangstyp _zugangsTyp;

        BMUZugang(Zugangstyp typ) {
            this._zugangsTyp = typ;
        }

        public final Zugangstyp getZugangstyp() {
            return this._zugangsTyp;
        }

        public abstract Element toXml(Document var1);
    }

    public static enum Zugangstyp {
        ZKS,
        OSCI,
        EMAIL,
        SONST;

    }

    public static enum Rolle {
        ERZ("ERZ"),
        BEF("BEF"),
        ZWL("ZWL"),
        ENT("ENT"),
        BEH("BEH"),
        BEVERZ("BVE"),
        PROV("PRV"),
        MAK("MAK"),
        SONST("SNT");

        private String _idRolle;

        private Rolle(String idRolle) {
            this._idRolle = idRolle;
        }

        public String getIDRolle() {
            return this._idRolle;
        }
    }
}

