/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.schema;

import de.consist.bmu.rule.schema.LSInputImpl;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class BMUSchemaResourceResolver
implements LSResourceResolver {
    private static final Log LOGGER = LogFactory.getLog(BMUSchemaResourceResolver.class);
    private static final Map<String, String> RESOURCE_MAPPING = new HashMap<String, String>();
    private final String _schemaFilePath;

    public BMUSchemaResourceResolver(String aSchemaFilePath) {
        this._schemaFilePath = aSchemaFilePath;
    }

    public final LSInput resolveResource(String publicId, String systemId, String baseURI) {
        return this.resolveResource(null, null, publicId, systemId, baseURI);
    }

    @Override
    public final LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOGGER.debug((Object)("trying to resolve: publicId=" + publicId + ", systemId=" + systemId + ", baseURI=" + baseURI));
        LSInputImpl lsInput = new LSInputImpl();
        URL url = null;
        if (systemId != null) {
            url = RESOURCE_MAPPING.containsKey(systemId) ? this.getClass().getResource(this._schemaFilePath + RESOURCE_MAPPING.get(systemId)) : this.getClass().getResource(this._schemaFilePath + systemId);
        }
        if (url == null && publicId != null && RESOURCE_MAPPING.containsKey(publicId)) {
            url = this.getClass().getResource(this._schemaFilePath + RESOURCE_MAPPING.get(publicId));
        }
        if (url == null && namespaceURI != null && RESOURCE_MAPPING.containsKey(namespaceURI)) {
            url = this.getClass().getResource(this._schemaFilePath + RESOURCE_MAPPING.get(namespaceURI));
        }
        if (url == null) {
            LOGGER.error((Object)("unable to resolve: systemId=" + systemId + ", pubicId=" + publicId + ", namespaceURI=" + namespaceURI));
        } else {
            try {
                lsInput.setByteStream(url.openStream());
                LOGGER.debug((Object)("resolved: " + url));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error resolving resource: " + url.getPath()), (Throwable)e);
            }
        }
        return lsInput;
    }

    static {
        RESOURCE_MAPPING.put("http://www.w3.org/2001/XMLSchema.dtd", "2001/XMLSchema.dtd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:data:documentation:CoreComponentTypeSchemaModule:2:1", "Eudin_XSD/standard/common/CCTS_CCT_SchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:codelist:specification:54217:2001", "Eudin_XSD/standard/common/CodeList_CurrencyCode_ISO_7_04.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:codelist:specification:5639:1988", "Eudin_XSD/standard/common/CodeList_LanguageCode_ISO_7_04.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaTypes:2003", "Eudin_XSD/standard/common/CodeList_MIMEMediaTypeCode_IANA_7_04.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:codelist:specification:66411:2001", "Eudin_XSD/standard/common/CodeList_UnitCode_UNECE_7_04.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:data:specification:QualifiedDataTypeSchemaModule:2:1", "Eudin_XSD/standard/common/QualifiedDataTypeSchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:data:specification:ReusableAggregateBusinessInformationEntitySchemaModule:2:1", "Eudin_XSD/standard/common/ReusableAggregateBusinessInformationEntitySchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2:1", "Eudin_XSD/standard/common/UnqualifiedDataTypeSchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("usr:QualifiedDataTypeSchemaModule:2:1", "Eudin_XSD/user/common/QualifiedDataTypeSchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("usr:ReusableAggregateBusinessInformationEntitySchemaModule:2:1", "Eudin_XSD/user/common/ReusableAggregateBusinessInformationEntitySchemaModule-2.1.xsd");
        RESOURCE_MAPPING.put("usr:EUDINCertificateOfWasteReceiptDocument:2:1", "Eudin_XSD/user/maindoc/EUDINCertificateOfWasteReceiptDocument-2.1.xsd");
        RESOURCE_MAPPING.put("usr:EUDINCertificateOfWasteRecoveryDisposalDocument:2:1", "Eudin_XSD/EUDINCertificateOfWasteRecoveryDisposalDocument-2.1.xsd");
        RESOURCE_MAPPING.put("usr:EUDINConfirmationOfMessageReceipt:2:1", "Eudin_XSD/user/maindoc/EUDINConfirmationOfMessageReceipt-2.1.xsd");
        RESOURCE_MAPPING.put("usr:EUDINWasteMovementDocument:2:1", "Eudin_XSD/user/maindoc/EUDINWasteMovementDocument-2.1.xsd");
        RESOURCE_MAPPING.put("usr:EUDINWasteTransportStatement:2:1", "Eudin_XSD/user/maindoc/EUDINWasteTransportStatement-2.1.xsd");
        RESOURCE_MAPPING.put("DA_ParameterlisteTeil_3_Anhang_E.xsd", "DA_XSD/DA_ParameterlisteTeil_3_Anhang_E.xsd");
        RESOURCE_MAPPING.put("uri:BMU_Waste_Interface/DA", "DA_XSD/DA_Teil_2_Anhang_E.xsd");
        RESOURCE_MAPPING.put("uri:BMU_Waste_Interface/DATypen", "DA_XSD/DA_Typen_Teil_1-Anhang_E.xsd");
        RESOURCE_MAPPING.put("uri:AnzeigeErlaubnis/AbfAEV", "AbfAEV/FreieXMLStruktur-AbfAEV.xsd");
        RESOURCE_MAPPING.put("uri:AnzeigeErlaubnis/Kopie_TypBibliothek", "AbfAEV/Kopie_TypBibliothek.xsd");
        RESOURCE_MAPPING.put("uri:AnzeigeErlaubnis/Kopie_Kataloge", "AbfAEV/Kopie_Kataloge.xsd");
        RESOURCE_MAPPING.put("uri:ErzeugerStammdaten/ErzStamm", "ErzStamm/FreieXMLStrukturErzStamm.xsd");
        RESOURCE_MAPPING.put("uri:ErzeugerStammdaten/ErzStammTypBibliothek", "ErzStamm/ErzStammTypBibliothek.xsd");
        RESOURCE_MAPPING.put("uri:ErzeugerStammdaten/ErzStammKataloge", "ErzStamm/ErzStammKataloge.xsd");
        RESOURCE_MAPPING.put("Waste-WG-2018-Message", "waste-shipment-guidelines-11/message.xsd");
        RESOURCE_MAPPING.put("codelists.xsd", "waste-shipment-guidelines-11/codelists.xsd");
        RESOURCE_MAPPING.put("basetypes.xsd", "waste-shipment-guidelines-11/basetypes.xsd");
        RESOURCE_MAPPING.put("annex7.xsd", "waste-shipment-guidelines-11/annex7.xsd");
        RESOURCE_MAPPING.put("notification.xsd", "waste-shipment-guidelines-11/notification.xsd");
        RESOURCE_MAPPING.put("statement.xsd", "waste-shipment-guidelines-11/statement.xsd");
        RESOURCE_MAPPING.put("wastemovement.xsd", "waste-shipment-guidelines-11/wastemovement.xsd");
    }
}

