/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu.viewer;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.DocumentController;
import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.RuleSetResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.BMUDokumentImpl;
import de.consist.bmu.rule.impl.FXSDokument;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;
import de.itu.bmu.BMUAttachment;
import de.itu.bmu.BMURegAuszug;
import de.itu.bmu.BMUUtils;
import de.itu.bmu.BmuNamespaceContext;
import de.itu.bmu.viewer.BMUViewerInitializer;
import de.itu.error.ITUException;
import de.itu.util.FileUtil;
import de.itu.xml.SchemaValidator;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import de.itu.xml.XmlUtil;
import de.itu.xmlsec.FileSignInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BMUController {
    public static final String BEREICH_BB = "Beh\u00f6rdenbest\u00e4tigung";
    public static final String BEREICH_ANHAENGE = "unsignierte Anh\u00e4nge";
    public static final String BEREICH_ALLE_SEITEN_RE = "alle Seiten RE";
    public static final String BEREICH_ALLE_SEITEN = "alle Seiten";
    public static final String BEREICH_AGS = "AGS Bescheid";
    public static final String BEREICH_EGF = "Erg\u00e4nzendes Formblatt";
    public static final String BEREICH_DA = "Deklarationanalyse";
    public static final String BEREICH_NF = "Nachforderung";
    public static final String BEREICH_BB_ANO = "Beh\u00f6rdenbest\u00e4tigung / Anordnung";
    public static final String BEREICH_EB = "Eingangsbest\u00e4tigung";
    public static final String BEREICH_AE = "Annahmeerkl\u00e4rung";
    public static final String BEREICH_VE_SEITE_2 = "Verantwortliche Erkl\u00e4rung - Seite 2";
    public static final String BEREICH_VE_SEITE_1 = "Verantwortliche Erkl\u00e4rung - Seite 1";
    public static final String BEREICH_DECKBLATT = "Deckblatt";
    public static final String BEREICH_UEBERSICHT = "\u00dcbersicht";
    public static final String BEREICH_XTRA = "Weitere Angaben";
    public static final String BEREICH_G11_FORMULAR = "Formularansicht";
    public static final String BEREICH_ERZ_ENT_UEBERSICHT = "\u00dcbersicht";
    public static final String BEREICH_ERZ_ENT_VOLLSTAENDIG = "Vollst\u00e4ndig";
    public static final String BEREICH_G11_VOLLSTAENDIG = "Vollst\u00e4ndige Ansicht";
    private static final Logger _logger = LogManager.getLogger(BMUController.class);
    private static final String PROP_KEY_DISABLE_VALIDATE_PARSE = "disableValidateOnParse";
    private static final String PROP_KEY_BMU_TEST = "testBMU";
    private static final String PROP_KEY_FXSCONFIG_PATH = "fxsConfigPath";
    private static final String PROP_KEY_XSD_PATH = "fxsSchemaPath";
    private static RuleFactory.RuleConfig _ruleConfig = null;
    private static RuleSet _ruleSet = null;

    public static void setRuleConfig(RuleFactory.RuleConfig ruleConfig) {
        _ruleConfig = ruleConfig;
    }

    public static void init() {
        String userHome = System.getProperty("user.home");
        File userHomeViewer = new File(userHome + "/.BMU-Viewer");
        if (!userHomeViewer.exists()) {
            userHomeViewer.mkdirs();
        }
        File userHomePropFile = new File(userHomeViewer, "BMUViewer.properties");
        File propFile = new File("config/BMUViewer.properties");
        if (!userHomePropFile.exists()) {
            try {
                if (propFile.exists()) {
                    FileUtil.copyfile(propFile, userHomePropFile, false);
                }
            }
            catch (ITUException e) {
                e.printStackTrace();
            }
        }
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        Properties props = BMUViewerInitializer.getInstance().init(userHomePropFile.getAbsolutePath());
        try {
            XmlSecFassade.getInstance().init();
            RuleFactory ruleFactory = RuleFactory.getInstance();
            if (_ruleConfig == null) {
                _ruleConfig = RuleFactory.RuleConfig.BMUVIEWER;
            }
            XPathFacade.getInstance().setNamespaceContext(BmuNamespaceContext.getNamespaceContext());
            if (props != null) {
                Object testBMU;
                String fxsConfigPath = props.getProperty(PROP_KEY_FXSCONFIG_PATH);
                String fxsSchemaPath = props.getProperty(PROP_KEY_XSD_PATH);
                if (fxsConfigPath != null && fxsSchemaPath != null) {
                    _logger.info("fxsConfigPath : " + fxsConfigPath + ", fxsSchemaPath : " + fxsSchemaPath);
                } else {
                    fxsConfigPath = "config/FXSConfig.xml";
                    fxsSchemaPath = "xsd";
                }
                File fxsConfigFile = new File(fxsConfigPath);
                File fxsSchemaFile = new File(fxsSchemaPath);
                if (fxsConfigFile.exists() && fxsSchemaFile.exists()) {
                    _logger.debug("loading fxs-config: " + fxsConfigFile.getAbsolutePath() + ", xsd-path: " + fxsSchemaFile.getAbsolutePath());
                    ruleFactory.loadFXSConfig(fxsConfigFile, fxsSchemaFile);
                } else {
                    _logger.info("fxs-config NOT loaded: " + fxsConfigFile.getAbsolutePath() + ", xsd-path: " + fxsSchemaFile.getAbsolutePath());
                }
                Object disableValidateOnParse = props.get(PROP_KEY_DISABLE_VALIDATE_PARSE);
                if (disableValidateOnParse != null && Boolean.parseBoolean(disableValidateOnParse.toString())) {
                    BMUDokumentImpl.setValidateParse(false);
                    _logger.info("Keine Schema-Validierung beim parsen!");
                }
                if ((testBMU = props.get(PROP_KEY_BMU_TEST)) != null && Boolean.parseBoolean(testBMU.toString())) {
                    _ruleConfig = RuleFactory.RuleConfig.TEST;
                    _logger.info("Test-Konfiguration der Pr\u00fcfbibliothek aktiviert!");
                }
            } else if (_ruleConfig == null || !_ruleConfig.equals((Object)RuleFactory.RuleConfig.ASYS)) {
                _logger.warn("Propery file not found: " + propFile.getAbsolutePath());
            }
            _ruleSet = ruleFactory.createRuleSet(ruleFactory.loadRuleSetDef(_ruleConfig));
        }
        catch (BMUException e) {
            _logger.error("Fehler beim Initialisieren der Pr\u00fcfbibliothek");
        }
    }

    public static Document transformDoc(InputStream inStream, Map<String, Object> params, String bereich) {
        try {
            BMUDokument bmuDok = DocumentController.parseBMU(inStream, _ruleSet);
            Document trans = null;
            trans = BMUController.transformDoc(bmuDok, params, bereich);
            return trans;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Document transformDoc(Document doc, Map<String, Object> params, String bereich) {
        Document trans = null;
        try {
            String docAsString = XmlUtil.getDocAsString(doc);
            BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
            BMUMessageType bmt = bmuDok.getMessageType();
            _logger.info("BMU Nachrichtentyp: " + bmt);
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            InputStream is = BMUController.selectXslt(bmuDok, params, bereich);
            trans = XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trans;
    }

    public static Document transformDoc(BMUDokument bmuDok, Map<String, Object> params, String bereich) {
        Document trans = null;
        try {
            BMUMessageType bmt = bmuDok.getMessageType();
            _logger.info("BMU Nachrichtentyp: " + bmt);
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            InputStream is = BMUController.selectXslt(bmuDok, params, bereich);
            trans = XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trans;
    }

    public static File transform(String filePath, Map<String, Object> params, String bereich) {
        try {
            File input = new File(filePath);
            BMUDokument bmuDok = DocumentController.parseBMU(new FileInputStream(input), _ruleSet);
            BMUMessageType bmt = bmuDok.getMessageType();
            _logger.info("BMU Nachrichtentyp: " + bmt);
            Document trans = null;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            InputStream is = BMUController.selectXslt(bmuDok, params, bereich);
            trans = XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
            File f = File.createTempFile(bmt.getBMUType() + "Temp", ".htm");
            XmlUtil.save(trans, f);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File transform(BMUDokument bmuDok, Map<String, Object> params, String bereich) {
        try {
            Document trans = null;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            InputStream is = BMUController.selectXslt(bmuDok, params, bereich);
            trans = XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
            File f = File.createTempFile(bmuDok.getMessageType().getBMUType() + "Temp", ".htm");
            XmlUtil.save(trans, f);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static File transform(Document doc, Map<String, Object> params, String bereich) {
        try {
            Document trans = null;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            String docAsString = XmlUtil.getDocAsString(doc);
            BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
            InputStream is = BMUController.selectXslt(bmuDok, params, bereich);
            trans = XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
            File f = File.createTempFile(bmuDok.getMessageType().getBMUType() + "Temp", ".htm");
            XmlUtil.save(trans, f);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File transformHTML(BMUDokument bmuDok, Map<String, Object> params, String bereich) {
        try {
            InputStream is;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            if ((is = BMUController.selectXslt(bmuDok, params, bereich)) != null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setURIResolver(new MyResolver("/xslt"));
                Transformer tf = factory.newTransformer(new StreamSource(is));
                tf.setOutputProperty("method", "html");
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("omit-xml-declaration", "yes");
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    tf.setParameter(entry.getKey(), entry.getValue());
                }
                File f = File.createTempFile(bmuDok.getMessageType().getBMUType() + "Temp", ".htm");
                tf.transform(new DOMSource(bmuDok.getDocument()), new StreamResult(f));
                return f;
            }
        }
        catch (Exception e) {
            _logger.error("Fehler in transformHTML:", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static File transformHTML(Document doc, Map<String, Object> params, String bereich) {
        try {
            String docAsString;
            BMUDokument bmuDok;
            InputStream is;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            if ((is = BMUController.selectXslt(bmuDok = DocumentController.parseBMU(new ByteArrayInputStream((docAsString = XmlUtil.getDocAsString(doc)).getBytes()), _ruleSet), params, bereich)) != null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setURIResolver(new MyResolver("/xslt"));
                Transformer tf = factory.newTransformer(new StreamSource(is));
                tf.setOutputProperty("method", "html");
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("omit-xml-declaration", "yes");
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    tf.setParameter(entry.getKey(), entry.getValue());
                }
                File f = File.createTempFile(bmuDok.getMessageType().getBMUType() + "Temp", ".htm");
                tf.transform(new DOMSource(bmuDok.getDocument()), new StreamResult(f));
                return f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SortedMap<String, String> getLayerMap(BMUDokument bmuDok) throws Exception {
        return BMUUtils.getBMULayer(bmuDok);
    }

    @Deprecated
    public static SortedMap<String, String> getLayerMap(Document doc) throws Exception {
        String docAsString = XmlUtil.getDocAsString(doc);
        BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
        return BMUUtils.getBMULayer(bmuDok);
    }

    public static List<BMUAttachment> getAttachmentList(BMUDokument bmuDok) throws Exception {
        List<BMUAttachment> blist = BMUUtils.getAttachmentList(bmuDok);
        return blist;
    }

    @Deprecated
    public static List<BMUAttachment> getAttachmentList(Document doc) throws Exception {
        String docAsString = XmlUtil.getDocAsString(doc);
        BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
        List<BMUAttachment> blist = BMUUtils.getAttachmentList(bmuDok);
        return blist;
    }

    @Deprecated
    public static void extractAttachment(String inputPath, String name, String docID, String outPath) {
    }

    public static void extractAttachment(BMUDokument bmuDok, String name, String docID, String outPath) {
        try {
            InputStream is = BMUController.class.getResourceAsStream("/xslt/extract.xslt");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("DOCNAME", name);
            params.put("DOCPATH", outPath);
            params.put("DOCID", docID);
            XmlUtil.transform(bmuDok.getDocument(), is, "/xslt", params);
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void extractAttachment(Document doc, String name, String docID, String outPath) {
        try {
            InputStream is = BMUController.class.getResourceAsStream("/xslt/extract.xslt");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("DOCNAME", name);
            params.put("DOCPATH", outPath);
            params.put("DOCID", docID);
            XmlUtil.transform(doc, is, "/xslt", params);
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
    }

    public static RuleSetResult validate(BMUDokument bmuDok) throws Exception {
        return _ruleSet.execute(bmuDok);
    }

    @Deprecated
    public static boolean validate(Document doc, String fileName) throws Exception {
        SchemaValidator sv = SchemaValidator.getInstance(true);
        sv.setSchemaRootDir("xsd");
        File xsdFile = new File("xsd/Nachricht.xsd");
        boolean result = sv.validate(doc, xsdFile, fileName);
        if (!result) {
            File xmlFile = null;
            if (fileName != null) {
                xmlFile = new File(fileName);
            }
            if (xmlFile != null && xmlFile.exists()) {
                result = sv.validate(new File(fileName), xsdFile);
            } else {
                _logger.error("Dateiname wurde nicht angegeben oder Datei existiert nicht: " + fileName);
            }
        }
        return result;
    }

    public static Map<String, FileSignInfo> checkSignature(File f, BMUDokument bmuDok, int pos) throws Exception {
        SortedMap<String, FileSignInfo> result = BMUUtils.verifyLayerSignature(f, bmuDok, pos);
        return result;
    }

    @Deprecated
    public static Map<String, FileSignInfo> checkSignature(File f, Document doc, int pos) throws Exception {
        String docAsString = XmlUtil.getDocAsString(doc);
        BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
        SortedMap<String, FileSignInfo> result = BMUUtils.verifyLayerSignature(f, bmuDok, pos);
        return result;
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static RuleSet getRuleSet() {
        return _ruleSet;
    }

    private static InputStream selectXslt(BMUDokument bmuDok, Map<String, Object> params, String bereich) throws Exception {
        InputStream xslt = null;
        Object xsltPath = null;
        BMUMessageType bmt = bmuDok.getMessageType();
        _logger.info("Nachrichtentyp: " + bmt.getEnumType() + ", bereich: " + bereich + ", layer-Doc: " + bmt.isLayerDoc() + ", params: " + params);
        if (bmt.isLayerDoc()) {
            if (BMUMessageTypeEnum.ENSNDokument.equals((Object)bmt.getEnumType()) || BMUMessageTypeEnum.FRDokument.equals((Object)bmt.getEnumType())) {
                xsltPath = bereich != null ? BMUController.selectBereichXslt(bmt.getEnumType(), bereich) : BMUController.selectBereichXslt(bmt.getEnumType(), "");
            } else if (BMUMessageTypeEnum.BGSDokument.equals((Object)bmt.getEnumType()) || BMUMessageTypeEnum.UNSDokument.equals((Object)bmt.getEnumType())) {
                xsltPath = "/xslt/bgs.xsl";
            } else if (BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmt.getEnumType())) {
                xsltPath = bereich != null && bereich.length() > 0 ? BMUController.selectBereichXslt(bmt.getEnumType(), bereich) : "/xslt/reg_ra.xsl";
            }
            if (!params.containsKey("layerName")) {
                String layerName = BMUUtils.getBMULayer(bmuDok).keySet().iterator().next();
                int cut = layerName.indexOf(".");
                params.put("layerName", layerName.substring(cut + 2));
            }
            if (!params.containsKey("positionsnummer")) {
                params.put("positionsnummer", 1);
            }
        } else {
            switch (bmt.getEnumType()) {
                case EGFDokument: {
                    xsltPath = "/xslt/egf.xsl";
                    break;
                }
                case AGSBescheid: {
                    xsltPath = "/xslt/agsb.xsl";
                    break;
                }
                case Abfallverbringungsdokument: {
                    if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), "count(descendant::wmsg:NotificationDocument) > 0")) {
                        if (BEREICH_G11_FORMULAR.equals(bereich)) {
                            xsltPath = "/xslt/ntz_11.xsl";
                            break;
                        }
                        xsltPath = "/xslt/ntz_11_full.xsl";
                        break;
                    }
                    if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), "count(descendant::wmsg:WasteMovementDocument) > 0")) {
                        if (BEREICH_G11_FORMULAR.equals(bereich)) {
                            xsltPath = "/xslt/bgf_11.xsl";
                            break;
                        }
                        xsltPath = "/xslt/bgf_11_full.xsl";
                        break;
                    }
                    xsltPath = "/xslt/bgf.xsl";
                    break;
                }
                case Mitteilung: {
                    List<FXSDokument> fxsList = bmt.getFXSDokumentList();
                    if (fxsList.isEmpty()) {
                        xsltPath = "/xslt/mt.xsl";
                        break;
                    }
                    FXSDokument fxsDok = fxsList.get(0);
                    xsltPath = "/xslt/fx_" + fxsDok.getFxsType().getId() + ".xsl";
                    if ("\u00dcbersicht".equals(bereich)) {
                        xsltPath = "/xslt/fx_" + fxsDok.getFxsType().getId() + "_short.xsl";
                        Date today = new Date();
                        String val = new SimpleDateFormat("yyyy-MM-dd").format(today);
                        params.put("CURRENT_DATE", val);
                    }
                    if ((xslt = BMUController.class.getResourceAsStream((String)(xsltPath = ((String)xsltPath).toLowerCase()))) != null) break;
                    xsltPath = "/xslt/mt.xsl";
                    break;
                }
                case Quittung: {
                    xsltPath = "/xslt/qt.xsl";
                    break;
                }
                case Registrierungsantrag: 
                case RegistrierungsantragZKS: {
                    xsltPath = "/xslt/ran.xsl";
                    break;
                }
                case Registrierungsauftrag: 
                case RegistrierungsauftragZKS: {
                    xsltPath = "/xslt/rau.xsl";
                    break;
                }
                case RegisterAnforderung: {
                    xsltPath = "/xslt/reg.xsl";
                    break;
                }
                case Adressantwort: {
                    xsltPath = "/xslt/adress_antwort.xsl";
                    break;
                }
                case Adressauskunft: {
                    xsltPath = "/xslt/adress_auskunft.xsl";
                    break;
                }
                case Nachweisliste: {
                    xsltPath = "/xslt/nwl.xsl";
                    break;
                }
                case DADokument: {
                    xsltPath = "/xslt/da.xsl";
                    break;
                }
                case BGSNrZuteilung: {
                    xsltPath = "/xslt/nrz.xsl";
                    break;
                }
                case Envelope: {
                    xsltPath = "/xslt/osci_quittung.xsl";
                    break;
                }
                case ENSNVorlageLayerRE: {
                    xsltPath = bereich != null && bereich.length() > 0 ? BMUController.selectBereichXslt(bmt.getEnumType(), bereich) : BMUController.selectBereichXslt(bmt.getEnumType(), "");
                    params.put("layerName", "ENSNVorlageLayerRE");
                    break;
                }
                case ZKSAuftrag: {
                    xsltPath = "/xslt/zka.xsl";
                    break;
                }
                case ZKSErgebnis: {
                    xsltPath = "/xslt/zke.xsl";
                    break;
                }
                case Registrierungsquittung: {
                    xsltPath = "/xslt/rqt.xsl";
                    break;
                }
                default: {
                    _logger.warn("Nachrichtentyp wird nicht unterst\u00fctzt: " + bmt.getEnumType());
                }
            }
        }
        _logger.info("xslt: " + (String)xsltPath);
        if (xsltPath != null) {
            xslt = BMUController.class.getResourceAsStream((String)xsltPath);
        }
        return xslt;
    }

    private static String selectBereichXslt(BMUMessageTypeEnum bmt, String bereich) {
        String xslt = null;
        if (bmt.equals((Object)BMUMessageTypeEnum.ENSNDokument) || bmt.equals((Object)BMUMessageTypeEnum.RegisterAuszug)) {
            xslt = bereich.equals(BEREICH_DECKBLATT) ? "/xslt/deckblatt_en.xsl" : (bereich.equals(BEREICH_VE_SEITE_1) ? "/xslt/ve_en.xsl" : (bereich.equals(BEREICH_VE_SEITE_2) ? "/xslt/ve2_en.xsl" : (bereich.equals(BEREICH_AE) ? "/xslt/ae_en.xsl" : (bereich.equals(BEREICH_EB) ? "/xslt/eb_en.xsl" : (bereich.equals(BEREICH_BB_ANO) ? "/xslt/bb_en.xsl" : (bereich.equals(BEREICH_NF) ? "/xslt/nf_en.xsl" : (bereich.equals(BEREICH_DA) ? "/xslt/da_en.xsl" : (bereich.equals(BEREICH_EGF) ? "/xslt/egf_en.xsl" : (bereich.equals(BEREICH_AGS) ? "/xslt/agsb_en.xsl" : (bereich.equals(BEREICH_ALLE_SEITEN) ? "/xslt/all_en.xsl" : (bereich.equals(BEREICH_ALLE_SEITEN_RE) ? "/xslt/all_en_ra.xsl" : (bereich.equals(BEREICH_ANHAENGE) ? "/xslt/anhang_en.xsl" : (bereich.equals("\u00dcbersicht") ? "/xslt/uebersicht_en.xsl" : (bereich.equals(BEREICH_XTRA) ? "/xslt/xtra_en.xsl" : "/xslt/deckblatt_en.xsl"))))))))))))));
        } else if (bmt.equals((Object)BMUMessageTypeEnum.FRDokument)) {
            xslt = bereich.equals(BEREICH_DECKBLATT) ? "/xslt/fr.xsl" : (bereich.equals(BEREICH_BB) ? "/xslt/bb_fr.xsl" : (bereich.equals(BEREICH_ALLE_SEITEN) ? "/xslt/all_fr.xsl" : "/xslt/fr.xsl"));
        } else if (bmt.equals((Object)BMUMessageTypeEnum.ENSNVorlageLayerRE)) {
            xslt = bereich.equals(BEREICH_DECKBLATT) ? "/xslt/deckblatt_en.xsl" : (bereich.equals(BEREICH_VE_SEITE_1) ? "/xslt/ve_en.xsl" : (bereich.equals(BEREICH_VE_SEITE_2) ? "/xslt/ve2_en.xsl" : (bereich.equals(BEREICH_AE) ? "/xslt/ae_en.xsl" : (bereich.equals(BEREICH_DA) ? "/xslt/da_en.xsl" : (bereich.equals(BEREICH_ALLE_SEITEN_RE) ? "/xslt/all_en_ra.xsl" : "/xslt/deckblatt_en.xsl")))));
        }
        return xslt;
    }

    public static BMURegAuszug getRegAuszug(BMUDokument bmuDok) throws Exception {
        BMURegAuszug regAuszug = null;
        if (BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmuDok.getMessageType().getEnumType())) {
            regAuszug = BMUUtils.getRegAuszug(bmuDok);
        } else {
            _logger.warn("Dokument ist kein Registerauszug!");
        }
        return regAuszug;
    }

    public static BMURegAuszug getRegAuszug(Document doc) throws Exception {
        BMURegAuszug regAuszug = null;
        String docAsString = XmlUtil.getDocAsString(doc);
        BMUDokument bmuDok = DocumentController.parseBMU(new ByteArrayInputStream(docAsString.getBytes()), _ruleSet);
        if (BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmuDok.getMessageType().getEnumType())) {
            regAuszug = BMUUtils.getRegAuszug(bmuDok);
        } else {
            _logger.warn("Dokument ist kein Registerauszug!");
        }
        return regAuszug;
    }

    public static class MyResolver
    implements URIResolver {
        private String _xsltBaseDir;

        public MyResolver(String baseDir) {
            this._xsltBaseDir = baseDir;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            StreamSource src = null;
            _logger.debug("<resolve> href=" + href + ", base=" + base);
            String name = this._xsltBaseDir + "/" + href;
            InputStream is = BMUController.class.getResourceAsStream(name);
            if (is != null) {
                src = new StreamSource(is);
                _logger.debug("<resolve> source found: " + name);
            } else {
                _logger.warn("<resolve> source not found: " + name);
            }
            return src;
        }
    }
}

