/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.itu.bmu.BMUAdressAntwortEntry;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BMUAdressAntwort {
    private static final Logger _logger = LogManager.getLogger(BMUAdressAntwort.class);
    private boolean _initialized = false;
    private BMUDokument _doc = null;
    private int _treffer = -1;
    private String _tempFilePath = null;
    private String _fehlerKlasse = null;
    private String _fehlerStufe = null;
    private String _fehlerMeldung = null;
    private List<BMUAdressAntwortEntry> _adressListe = new ArrayList<BMUAdressAntwortEntry>();

    public BMUAdressAntwort(BMUDokument doc, String tempFilePath) {
        this._doc = doc;
        this._tempFilePath = tempFilePath;
        this._initialized = this.init(doc);
    }

    private boolean init(BMUDokument doc) {
        boolean retVal = false;
        if (doc != null) {
            XPathFacade xpf = XPathFacade.getInstance();
            try {
                BMUMessageType bmt = this._doc.getMessageType();
                switch (bmt.getEnumType()) {
                    case Adressantwort: {
                        NodeList nl = xpf.evaluateNodeList(doc.getDocument(), "/msg:Nachricht/msg:Nutzdaten/zks:Adressantwort/zks:Liste");
                        if (nl != null && nl.getLength() > 0) {
                            this._treffer = nl.getLength();
                            for (int i = 0; i < nl.getLength(); ++i) {
                                Node n = nl.item(i);
                                BMUAdressAntwortEntry adresse = new BMUAdressAntwortEntry((Element)n);
                                this._adressListe.add(adresse);
                            }
                            break;
                        }
                        this._treffer = (int)xpf.evalNumber(doc.getDocument().getDocumentElement(), "/msg:Nachricht/msg:Nutzdaten/zks:Adressantwort/zks:Trefferanzahl");
                        break;
                    }
                    case Quittung: {
                        this._treffer = -1;
                        this._fehlerKlasse = xpf.evaluate(doc.getDocument(), "/msg:Nachricht/msg:Nutzdaten/msg:Quittung/msg:Meldung/msg:Klasse");
                        this._fehlerStufe = xpf.evaluate(doc.getDocument(), "/msg:Nachricht/msg:Nutzdaten/msg:Quittung/msg:Meldung/msg:Stufe");
                        this._fehlerMeldung = xpf.evaluate(doc.getDocument(), "/msg:Nachricht/msg:Nutzdaten/msg:Quittung/msg:Meldung/msg:Beschreibung");
                        break;
                    }
                    default: {
                        this._treffer = -1;
                        this._fehlerKlasse = "SONSTIGES";
                        this._fehlerStufe = "FATAL";
                        this._fehlerMeldung = "Unerwarteter Dokumenttyp: " + bmt.toString();
                        _logger.warn("Unerwarteter Dokumenttyp: " + bmt.toString());
                    }
                }
            }
            catch (XmlException e) {
                _logger.error("Fehler bei der XPath Auswertung", (Throwable)e);
            }
        }
        return retVal;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public BMUDokument getDocument() {
        return this._doc;
    }

    public int getTreffer() {
        return this._treffer;
    }

    public List<BMUAdressAntwortEntry> getAdressListe() {
        return this._adressListe;
    }

    public String getTempFilePath() {
        return this._tempFilePath;
    }

    public String getFehlerKlasse() {
        return this._fehlerKlasse;
    }

    public String getFehlerStufe() {
        return this._fehlerStufe;
    }

    public String getFehlerMeldung() {
        return this._fehlerMeldung;
    }
}

