/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMURegCharge;
import de.itu.bmu.BMURegChargeBGS;
import de.itu.bmu.BMURegChargeBGSDok;
import de.itu.bmu.BMURegChargeBGSExzerpt;
import de.itu.bmu.BMURegChargeUNS;
import de.itu.bmu.BMURegChargeUNSDok;
import de.itu.bmu.BMURegChargeUNSExzerpt;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BMURegChargeBGSMitUNS
extends BMURegCharge {
    private static final Logger _logger = LogManager.getLogger(BMURegChargeBGSMitUNS.class);
    private BMURegChargeBGS _bgs;
    private SortedMap<String, BMURegChargeUNS> _unsMap = new TreeMap<String, BMURegChargeUNS>();

    public BMURegChargeBGSMitUNS(Element charge, int index, Object parent) {
        super(BMURegCharge.ChargeType.BGSmitUNS, index, parent);
        try {
            String bgsTypeNodeName = XPathFacade.getInstance().evaluate(charge, "local-name(reg:BGSmitUNS/reg:BGS/*)");
            BMURegChargeBGS.ChargeBGSType chargeTypeBGS = BMURegChargeBGS.ChargeBGSType.valueOf(bgsTypeNodeName);
            if (BMURegChargeBGS.ChargeBGSType.BGSDokument.equals((Object)chargeTypeBGS)) {
                this._bgs = new BMURegChargeBGSDok(charge, 1, (Object)this);
            } else if (BMURegChargeBGS.ChargeBGSType.BGSExzerpt.equals((Object)chargeTypeBGS)) {
                this._bgs = new BMURegChargeBGSExzerpt(charge, 1, (Object)this);
            }
            NodeList nl = XPathFacade.getInstance().evaluateNodeList(charge, "reg:BGSmitUNS/reg:UNS");
            BMURegChargeUNS regCharge = null;
            String sizeString = Integer.toString(nl.getLength());
            int digits = sizeString.length();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node chargeNode = nl.item(i);
                String unsTypeNodeName = XPathFacade.getInstance().evaluate((Element)chargeNode, "local-name(*)");
                BMURegChargeUNS.ChargeUNSType chargeTypeUNS = BMURegChargeUNS.ChargeUNSType.valueOf(unsTypeNodeName);
                if (BMURegChargeUNS.ChargeUNSType.UNSDokument.equals((Object)chargeTypeUNS)) {
                    regCharge = new BMURegChargeUNSDok((Element)chargeNode, i, (Object)this);
                } else if (BMURegChargeUNS.ChargeUNSType.UNSExzerpt.equals((Object)chargeTypeUNS)) {
                    regCharge = new BMURegChargeUNSExzerpt((Element)chargeNode, i, (Object)this);
                }
                Object indexString = Integer.toString(i + 1);
                for (int j = ((String)indexString).length(); j < digits; ++j) {
                    indexString = "0" + (String)indexString;
                }
                this._unsMap.put("UNS[" + (String)indexString + "]", regCharge);
            }
        }
        catch (XmlException e) {
            _logger.error("Fehler beim ermitteln der Daten", (Throwable)e);
        }
    }

    public BMURegChargeBGS getBGS() {
        return this._bgs;
    }

    public SortedMap<String, BMURegChargeUNS> getUNSMap() {
        return this._unsMap;
    }

    @Override
    public String getNummer() {
        return null;
    }

    public BMURegCharge getCharge(String nr) {
        BMURegCharge retVal = null;
        if (this._bgs != null && nr.equals(this._bgs.getNummer())) {
            retVal = this._bgs;
        } else {
            for (BMURegChargeUNS uns : this._unsMap.values()) {
                if (!nr.equals(uns.getNummer())) continue;
                retVal = uns;
            }
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BMURegChargeBGSMitUNS)) {
            return false;
        }
        if (this._bgs == null) {
            return ((BMURegChargeBGSMitUNS)obj)._bgs == null;
        }
        return this._bgs.equals(((BMURegChargeBGSMitUNS)obj)._bgs);
    }
}

