/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.schema.Namespace;
import de.itu.bmu.BMUAttachment;
import de.itu.bmu.BMURegAuszug;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import de.itu.xmlsec.FileSignInfo;
import de.itu.xmlsec.XmlSecException;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BMUUtils {
    private static final Logger _logger = LogManager.getLogger(BMUUtils.class);

    public static String createSubject(String empfaenger, String nummer, String sender, String filename) {
        StringBuffer buf = new StringBuffer();
        buf.append(empfaenger);
        while (buf.length() < 16) {
            buf.append(' ');
        }
        buf.append(sender);
        while (buf.length() < 32) {
            buf.append(' ');
        }
        buf.append("ASY");
        buf.append(nummer);
        if (filename != null) {
            while (buf.length() < 60) {
                buf.append(' ');
            }
            buf.append(filename);
        }
        return buf.toString();
    }

    public static String getSubjectValue(String subject, SubjectEntry entry) {
        String value = null;
        if (subject != null && subject.length() > entry._startPos) {
            value = subject.substring(entry._startPos, Math.min(subject.length(), entry._startPos + entry._length));
        } else {
            _logger.warn("invalid subject: " + subject);
        }
        return value;
    }

    public static String getFileName(String subject) {
        StringBuffer fileNameBuf = new StringBuffer();
        String asysFileName = SubjectEntry.AsysFileName.getEntry(subject);
        if (asysFileName != null) {
            fileNameBuf.append(asysFileName);
        } else {
            fileNameBuf.append(SubjectEntry.DokTyp.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.Absender.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.AbsRolle.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.Empfaenger.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.EmpfRolle.getEntry(subject));
            fileNameBuf.append("_");
            String docNr = SubjectEntry.DokNummer.getEntry(subject);
            docNr = docNr.replaceAll("[^A-Za-z0-9_.]", "_");
            _logger.debug("Dok-Nr,:" + docNr);
            fileNameBuf.append(docNr);
        }
        fileNameBuf.append(".");
        fileNameBuf.append(new Date().getTime());
        return fileNameBuf.toString();
    }

    private static String getLayerName(Element layerElem, int layerNum) {
        String lfdNr;
        Object index = String.valueOf(layerNum + 1);
        if (layerNum < 9) {
            index = "0" + (String)index;
        }
        String layerName = (String)index + ". " + layerElem.getLocalName();
        String rolle = layerElem.getAttribute("lib:ATBRolle");
        if (rolle != null && rolle.length() > 0) {
            layerName = layerName + " Rolle:" + rolle;
        }
        if ((lfdNr = layerElem.getAttribute("lib:ATBBefLfdNummer")) != null) {
            layerName = layerName + lfdNr;
        }
        return layerName;
    }

    private static Element getFirstChildElement(Element parent) {
        Element retVal = null;
        Node childNode = parent.getFirstChild();
        while (!(childNode instanceof Element)) {
            childNode = childNode.getNextSibling();
        }
        if (childNode instanceof Element) {
            retVal = (Element)childNode;
        }
        return retVal;
    }

    private static String getBGFName(Element layerElem, int layerNum) throws Exception {
        Object index = String.valueOf(layerNum + 1);
        if (layerNum < 9) {
            index = "0" + (String)index;
        }
        Element child = BMUUtils.getFirstChildElement(layerElem);
        String layerName = (String)index + ". " + layerElem.getLocalName();
        if (child != null) {
            String childName = child.getLocalName();
            _logger.debug("getChildName: " + childName);
            if ("EUDINCertificateOfWasteRecoveryDisposalDocument".equals(childName)) {
                layerName = (String)index + ". Entsorgungsbest\u00e4tigung";
            } else if ("EUDINCertificateOfWasteReceiptDocument".equals(childName)) {
                layerName = (String)index + ". Empfangsbest\u00e4tigung";
            } else if ("EUDINWasteMovementDocument".equals(childName)) {
                layerName = (String)index + ". Transportanmeldung";
            }
        }
        layerName = layerName + " (" + layerElem.getParentNode().getLocalName() + ")";
        return layerName;
    }

    public static SortedMap<String, String> getBMULayer(BMUDokument doc) throws Exception {
        BMUMessageType bmt = doc.getMessageType();
        return BMUUtils.getBMULayer(doc.getDocument().getDocumentElement(), bmt);
    }

    public static SortedMap<String, String> getBMULayer(Element elem, BMUMessageType bmt) throws Exception {
        return BMUUtils.getBMULayer(elem, bmt.getEnumType());
    }

    public static SortedMap<String, String> getBMULayer(Element elem, BMUMessageTypeEnum bmt) throws Exception {
        TreeMap<String, String> layerMap = new TreeMap<String, String>();
        NodeList nl = null;
        boolean bgf = false;
        switch (bmt) {
            case ENSNDokument: {
                nl = XPathFacade.getInstance().evaluateNodeList(elem, "descendant::*[starts-with(local-name(),'ENSN') and contains(local-name(),'Layer')]");
                break;
            }
            case BGSDokument: {
                nl = XPathFacade.getInstance().evaluateNodeList(elem, "descendant::*[starts-with(local-name(),'BGS') and contains(local-name(),'Layer')]");
                break;
            }
            case FRDokument: {
                nl = XPathFacade.getInstance().evaluateNodeList(elem, "descendant::*[starts-with(local-name(),'FR') and contains(local-name(),'Layer')]");
                break;
            }
            case UNSDokument: {
                nl = XPathFacade.getInstance().evaluateNodeList(elem, "descendant::*[starts-with(local-name(),'UNS') and contains(local-name(),'Layer')]");
                break;
            }
            case Abfallverbringungsdokument: {
                nl = XPathFacade.getInstance().evaluateNodeList(elem, "//ntz:VersandBegleitformular");
                bgf = true;
                break;
            }
        }
        if (nl != null) {
            int i;
            if (bgf) {
                for (i = 0; i < nl.getLength(); ++i) {
                    Element layerNode = (Element)nl.item(i);
                    String layerID = Integer.toString(i + 1);
                    String layerName = BMUUtils.getBGFName(layerNode, nl.getLength() - i - 1);
                    _logger.debug("id=" + layerID + ", Name=" + layerName);
                    layerMap.put(layerName, layerID);
                }
            } else {
                for (i = 0; i < nl.getLength(); ++i) {
                    Element layerNode = (Element)nl.item(i);
                    String layerID = layerNode.getAttribute("lib:LayerID");
                    String layerName = BMUUtils.getLayerName(layerNode, nl.getLength() - i - 1);
                    _logger.debug("layerID=" + layerID + ", layerName=" + layerName);
                    layerMap.put(layerName, layerID);
                }
            }
        } else {
            _logger.error("Dokument ist kein Layer-Dokument: " + String.valueOf(bmt));
        }
        TreeMap<String, String> reverseLayerMap = new TreeMap<String, String>(Collections.reverseOrder());
        reverseLayerMap.putAll(layerMap);
        return reverseLayerMap;
    }

    public static SortedMap<String, FileSignInfo> verifyLayerSignature(File xmlFile, BMUDokument doc, int layerPos) throws XmlSecException, XmlException {
        TreeMap<CallSite, FileSignInfo> sigInfoMap = new TreeMap<CallSite, FileSignInfo>();
        if (xmlFile.exists()) {
            BMUMessageType bmt = doc.getMessageType();
            if (bmt.isLayerDoc() && !BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmt.getEnumType())) {
                NodeList nl = null;
                switch (bmt.getEnumType()) {
                    case ENSNDokument: {
                        nl = XPathFacade.getInstance().evaluateNodeList(doc.getDocument(), "//*[starts-with(local-name(),'ENSN') and contains(local-name(),'Layer')]");
                        break;
                    }
                    case BGSDokument: {
                        nl = XPathFacade.getInstance().evaluateNodeList(doc.getDocument(), "//*[starts-with(local-name(),'BGS') and contains(local-name(),'Layer')]");
                        break;
                    }
                    case FRDokument: {
                        nl = XPathFacade.getInstance().evaluateNodeList(doc.getDocument(), "//*[starts-with(local-name(),'FR') and contains(local-name(),'Layer')]");
                        break;
                    }
                    case UNSDokument: {
                        nl = XPathFacade.getInstance().evaluateNodeList(doc.getDocument(), "//*[starts-with(local-name(),'UNS') and contains(local-name(),'Layer')]");
                        break;
                    }
                }
                if (nl != null) {
                    if (layerPos > 0) {
                        if (layerPos > nl.getLength()) {
                            _logger.error("Layerposition ung\u00fcltig: " + layerPos);
                        } else {
                            Element layerElem = (Element)nl.item(layerPos - 1);
                            String layerName = BMUUtils.getLayerName(layerElem, nl.getLength() - layerPos);
                            NodeList childNodes = layerElem.getChildNodes();
                            int sigIndex = 1;
                            for (int i = 0; i < childNodes.getLength(); ++i) {
                                Node childNode = childNodes.item(i);
                                if (!"Signature".equals(childNode.getLocalName())) continue;
                                Element sigElem = (Element)childNode;
                                FileSignInfo fsi = new FileSignInfo(xmlFile, doc, sigElem, layerName);
                                sigInfoMap.put((CallSite)((Object)(layerName + "(" + sigIndex + ")")), fsi);
                                ++sigIndex;
                            }
                        }
                    } else {
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Element layerElem = (Element)nl.item(i);
                            String layerName = BMUUtils.getLayerName(layerElem, nl.getLength() - i - 1);
                            NodeList childNodes = layerElem.getChildNodes();
                            int sigIndex = 1;
                            for (int j = 0; j < childNodes.getLength(); ++j) {
                                Node childNode = childNodes.item(j);
                                if (!"Signature".equals(childNode.getLocalName())) continue;
                                Element sigElem = (Element)childNode;
                                FileSignInfo fsi = new FileSignInfo(xmlFile, doc, sigElem, layerName);
                                sigInfoMap.put((CallSite)((Object)(layerName + "(" + sigIndex + ")")), fsi);
                                ++sigIndex;
                            }
                        }
                    }
                }
            } else {
                NodeList nl = doc.getDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element sigElem = (Element)nl.item(i);
                    FileSignInfo fsi = new FileSignInfo(xmlFile, doc, sigElem, sigElem.getParentNode().getLocalName());
                    sigInfoMap.put((CallSite)((Object)("Signature " + fsi.getSigID())), fsi);
                }
            }
        } else {
            _logger.error("Datei nicht gefunden: " + xmlFile.getAbsolutePath());
        }
        TreeMap<String, FileSignInfo> reverseLayerMap = new TreeMap<String, FileSignInfo>(Collections.reverseOrder());
        reverseLayerMap.putAll(sigInfoMap);
        return reverseLayerMap;
    }

    public static List<BMUAttachment> getAttachmentList(BMUDokument bmuDok) throws Exception {
        ArrayList<BMUAttachment> attachmentList = new ArrayList<BMUAttachment>();
        int layerCount = Integer.valueOf(XPathFacade.getInstance().evaluate(bmuDok.getDocument(), "count(descendant::*[@lib:LayerID])"));
        NodeList nl = XPathFacade.getInstance().evaluateNodeList(bmuDok.getDocument(), "//*[local-name()='Dateianhang']");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element attachment = (Element)nl.item(i);
            String nsURI = attachment.getNamespaceURI();
            if (nsURI != null && (nsURI.startsWith("uri:BMU_Waste_Interface/") || nsURI.startsWith("uri:AnzeigeErlaubnis/"))) {
                String nsBibURI = Namespace.TypenBibliothek.getUri();
                if (Namespace.abfaev.getUri().equals(nsURI)) {
                    nsBibURI = Namespace.aevlib.getUri();
                }
                String id = attachment.getAttributeNS(nsBibURI, "id");
                String fileName = attachment.getAttributeNS(nsBibURI, "dateiname");
                int fileSize = Integer.parseInt(attachment.getAttributeNS(nsBibURI, "dateigroesse"));
                String contentType = attachment.getAttributeNS(nsBibURI, "inhaltsTyp");
                String checksum = "";
                NodeList nlPS = attachment.getElementsByTagNameNS(nsBibURI, "Pruefsumme");
                if (nlPS.getLength() > 0) {
                    checksum = nlPS.item(0).getTextContent();
                }
                String checksumMethod = "";
                nlPS = attachment.getElementsByTagNameNS(nsBibURI, "Methode");
                if (nlPS.getLength() > 0) {
                    checksumMethod = nlPS.item(0).getTextContent();
                }
                String section = attachment.getParentNode().getLocalName();
                NodeList layerList = XPathFacade.getInstance().evaluateNodeList(attachment, "ancestor::*[starts-with(local-name(), 'ENSN') and contains(local-name(), 'Layer')]");
                Object layerName = "";
                if (layerList.getLength() > 0) {
                    String lfdNr;
                    Element layer = (Element)layerList.item(layerList.getLength() - 1);
                    int reverseIndex = layerCount - layerList.getLength() + 1;
                    Object index = String.valueOf(reverseIndex);
                    if (reverseIndex < 10) {
                        index = "0" + (String)index;
                    }
                    layerName = (String)index + ". " + layer.getLocalName();
                    String rolle = layer.getAttribute("lib:ATBRolle");
                    if (rolle != null && rolle.length() > 0) {
                        layerName = (String)layerName + " Rolle:" + rolle;
                    }
                    if ((lfdNr = layer.getAttribute("lib:ATBBefLfdNummer")) != null) {
                        layerName = (String)layerName + lfdNr;
                    }
                    String layerID = layer.getAttributeNS("uri:BMU_Waste_Interface/Bibliothek", "LayerID");
                    _logger.debug("layerID=" + layerID + ", layerName=" + (String)layerName);
                }
                BMUAttachment ba = new BMUAttachment(id, fileName, fileSize, contentType, (String)layerName, section, checksum, checksumMethod);
                attachmentList.add(ba);
                continue;
            }
            _logger.warn("Dateianhang nicht aus BMU-Namensraum: " + nsURI);
        }
        return attachmentList;
    }

    public static BMURegAuszug getRegAuszug(BMUDokument doc) throws Exception {
        BMURegAuszug retVal = null;
        BMUMessageType bmt = doc.getMessageType();
        try {
            if (BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmt.getEnumType())) {
                Node regAuszug = XPathFacade.getInstance().evaluateNode(doc.getDocument(), "//reg:Auszug");
                retVal = new BMURegAuszug((Element)regAuszug);
            }
        }
        catch (Exception e) {
            _logger.error("Fehler", (Throwable)e);
        }
        return retVal;
    }

    public static String normalize(String text) {
        String specials1 = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
        String specials2 = "aeoeueaeoeuesz";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int pos = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df".indexOf(c);
            if (pos >= 0) {
                buf.append("aeoeueaeoeuesz".charAt(pos + pos));
                buf.append("aeoeueaeoeuesz".charAt(pos + pos + 1));
                continue;
            }
            if (c == ' ') {
                buf.append('_');
                continue;
            }
            buf.append(Character.toLowerCase(c));
        }
        return buf.toString();
    }

    public static String getSignatureParentNodePath(BMUDokument bmuDok) throws XmlException {
        String nodePath = null;
        BMUMessageType bmt = bmuDok.getMessageType();
        BMUMessageTypeEnum bmte = bmt.getEnumType();
        String prefix = bmte.getNS().getPrefix();
        String name = prefix + ":" + bmte.name();
        if (bmte.isLayerDoc() && !BMUMessageTypeEnum.RegisterAuszug.equals((Object)bmte)) {
            String xPathSigNode = "/descendant::" + name + "/" + prefix + ":Layer/*";
            _logger.debug("XPath Signature-Node: " + xPathSigNode);
            Node layerNode = XPathFacade.getInstance().evaluateNode(bmuDok.getDocument(), xPathSigNode);
            if (layerNode != null) {
                String layerNodeName = prefix + ":" + layerNode.getLocalName();
                _logger.debug("Zu signierender Layer: " + layerNodeName);
                String layerIDName = "descendant::" + layerNodeName + "/@lib:LayerID";
                Node layerIDNode = XPathFacade.getInstance().evaluateNode(bmuDok.getDocument(), layerIDName);
                if (layerIDNode != null) {
                    String layerIDNodeName = layerIDNode.getNodeName();
                    String layerID = XPathFacade.getInstance().evaluate(bmuDok.getDocument(), "descendant::" + layerNodeName + "/@" + layerIDNodeName);
                    _logger.debug("ID des zu signierenden Layers: " + layerID);
                    nodePath = "descendant::*[local-name()='" + layerNode.getLocalName() + "'][@*[local-name()='" + layerIDNode.getLocalName() + "']='" + layerID + "']";
                    _logger.debug("nodePath: " + (String)nodePath);
                } else {
                    _logger.error("Layer ID nicht gefunden: " + layerIDName);
                }
            } else {
                _logger.error("Layer-Element nicht gefunden: " + xPathSigNode);
            }
        } else {
            String xPathSigNode = "descendant::" + name;
            _logger.debug("XPath Signature-Node: " + xPathSigNode);
            Element sigNode = (Element)XPathFacade.getInstance().evaluateNode(bmuDok.getDocument(), xPathSigNode);
            if (sigNode != null) {
                nodePath = "descendant::*[local-name()='" + sigNode.getLocalName() + "']";
            } else {
                _logger.error("Element nicht gefunden: " + xPathSigNode);
            }
        }
        _logger.debug("returning nodePath: " + nodePath);
        return nodePath;
    }

    public static enum SubjectEntry {
        Empfaenger(0, 10),
        EmpfRolle(10, 6),
        Absender(16, 10),
        AbsRolle(26, 6),
        DokTyp(32, 3),
        DokNummer(35, 15),
        KFZ(50, 10),
        AsysFileName(60, 70);

        private final int _startPos;
        private final int _length;

        private SubjectEntry(int startPos, int length) {
            this._startPos = startPos;
            this._length = length;
        }

        public String getEntry(String subject) {
            String entry = null;
            if (subject != null && subject.length() > this._startPos) {
                entry = subject.substring(this._startPos, Math.min(this._startPos + this._length, subject.length())).trim();
            }
            _logger.debug("<getEntry> " + this.toString() + ": subject=" + subject + ", entry=" + entry + ", start=" + this._startPos + ", length=" + this._length);
            return entry;
        }
    }
}

