/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.util.LogUtils;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import de.itu.xml.XmlUtil;
import de.itu.xml.XmlValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    public static final String[] ID_XS_DTD = new String[]{"-//W3C//DTD XMLSchema 200102//EN", "/de/itu/xml/XMLSchema.dtd"};
    private static File _schemaDir = null;
    private static final Logger _logger = LogManager.getLogger(SchemaValidator.class);
    private static final String SCHEMA_RESOURCE_ROOT = "/de/itu/res/xsd/";
    private static SchemaValidator _theInstance = null;
    private SchemaFactory _schemaFactory = null;
    private File _schemaRootDir = new File(System.getProperty("user.dir"));
    private Map<String, Schema> _schemaMap = new HashMap<String, Schema>();
    private List<SAXParseException> _errorList = new ArrayList<SAXParseException>();
    private List<SAXParseException> _warningList = new ArrayList<SAXParseException>();
    private DOMImplementationLS _domImplLS = null;
    private boolean _resolveLocal = false;

    private SchemaValidator(boolean resolveLocal) {
        this._resolveLocal = resolveLocal;
    }

    public static SchemaValidator getInstance(boolean resolveLocal) {
        if (_theInstance == null) {
            _theInstance = new SchemaValidator(resolveLocal);
            _theInstance.initialize();
        }
        return _theInstance;
    }

    private void initialize() {
        this._schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this._schemaFactory.setResourceResolver(new SchemaResolver());
        this._schemaFactory.setErrorHandler(new ValidationErrorHandler());
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMImplementationSourceImpl");
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementation impl = registry.getDOMImplementation("XML 1.0 LS");
            if (impl == null) {
                _logger.error("DOM3 implementation not found!");
            } else {
                this._domImplLS = (DOMImplementationLS)((Object)impl);
            }
        }
        catch (Exception e) {
            _logger.error("Fehler beim Initialisieren des Schemavalidator", (Throwable)e);
        }
        _logger.debug("<initialize> done!");
    }

    public void setSchemaRootDir(String rootDir) throws XmlException {
        File file = new File(rootDir);
        if (!file.exists() || !file.isDirectory()) {
            _logger.error("error setting schema root dir " + rootDir);
            throw new XmlException("error setting schema root dir " + rootDir);
        }
        this._schemaRootDir = file;
    }

    private Schema getSchema(String schemaName) throws XmlException {
        Schema schema = this._schemaMap.get(schemaName);
        if (schema == null) {
            Source source = this.getSchemaSource(schemaName);
            if (source != null) {
                try {
                    schema = this._schemaFactory.newSchema(source);
                    this._schemaMap.put(schemaName, schema);
                }
                catch (SAXException ex) {
                    _logger.error("Error creating schema", (Throwable)ex);
                    throw new XmlException(ex, "Error creating schema");
                }
            } else {
                _logger.error("error getting schema source");
                throw new XmlException("Error getting schema source");
            }
        }
        return schema;
    }

    public boolean validateIDNode(File file, File schemaFile, String idNodeName) throws XmlException, FileNotFoundException {
        this.setSchemaRootDir(schemaFile.getParent());
        return this.validate(new SAXSource(new InputSource(new FileInputStream(file))), schemaFile.getAbsolutePath(), idNodeName, file.getAbsolutePath(), true);
    }

    public boolean validate(Document doc, File schemaFile, String fileName) {
        boolean valid = false;
        try {
            this.setSchemaRootDir(schemaFile.getParent());
            valid = this.validate(new DOMSource(doc), schemaFile.getAbsolutePath(), null, fileName, false);
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        return valid;
    }

    public boolean validate(File file, File schemaFile) throws XmlException, FileNotFoundException {
        this.setSchemaRootDir(schemaFile.getParent());
        return this.validate(new SAXSource(new InputSource(new FileInputStream(file))), schemaFile.getAbsolutePath(), null, file.getAbsolutePath(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validate(Source source, String schemaName, String idNodeName, String fileName, boolean processErrors) throws XmlException {
        boolean valid = false;
        Schema schema = this.getSchema(schemaName);
        if (schema != null) {
            Schema schema2 = schema;
            synchronized (schema2) {
                Validator validator = schema.newValidator();
                try {
                    this._errorList.clear();
                    this._warningList.clear();
                    validator.setErrorHandler(new ValidationErrorHandler());
                    validator.validate(source);
                    boolean bl = valid = this._errorList.size() == 0;
                    if (processErrors && this._errorList.size() > 0) {
                        _logger.error("***************** Schema validation failed *****************");
                        Document doc = null;
                        if (fileName != null) {
                            _logger.error("Xml-File: " + fileName);
                            doc = XmlUtil.parse(new File(fileName));
                        }
                        _logger.error("Schema-File: " + schemaName);
                        for (int i = 0; i < this._errorList.size(); ++i) {
                            SAXParseException exc = this._errorList.get(i);
                            String msg = exc.getMessage();
                            _logger.error("Error in line:" + exc.getLineNumber() + ", column:" + exc.getColumnNumber() + ", message:" + exc.getMessage());
                            if (doc == null || idNodeName == null || !msg.startsWith("cvc-type")) continue;
                            String tmp = msg.substring(msg.indexOf(39) + 1);
                            String val = tmp.substring(0, tmp.indexOf(39));
                            tmp = tmp.substring(tmp.indexOf(39) + 1);
                            tmp = tmp.substring(tmp.indexOf(39) + 1);
                            String elem = tmp.substring(0, tmp.indexOf(39));
                            String xPath = "//*[descendant::" + elem + "[child::text()='" + val + "']]/" + idNodeName;
                            NodeList nl = XPathFacade.getInstance().evaluateNodeList(doc, xPath);
                            StringBuffer context = new StringBuffer();
                            for (int j = 0; j < nl.getLength(); ++j) {
                                Node node = nl.item(j);
                                if (!node.hasChildNodes()) continue;
                                if (context.length() > 0) {
                                    context.append(", ");
                                }
                                context.append(node.getNodeName() + "=" + node.getFirstChild().getNodeValue());
                            }
                            _logger.error("*** " + context.toString() + " ***");
                        }
                        _logger.error("************************************************************");
                        throw new XmlValidationException("Schema validation failed, errors: " + this._errorList.size() + ", warnings: " + this._warningList.size(), this._errorList);
                    }
                    if (this._warningList.size() <= 0) return valid;
                }
                catch (SAXException ex) {
                    _logger.error("Error validating doc with schema " + schemaName);
                    throw new XmlException(ex, "Error validating doc with schema " + schemaName);
                }
                catch (IOException ex) {
                    _logger.error("IO-Error when validating with schema " + schemaName);
                    throw new XmlException(ex, "IO-Error when validating with schema " + schemaName);
                }
                {
                    // empty if block
                }
                return valid;
            }
        } else {
            _logger.error("schema is null!");
            throw new XmlException("schema is null!");
        }
    }

    private Source getSchemaSource(String schemaName) {
        File schemaFile;
        StreamSource source = null;
        Object schemaFileName = schemaName;
        if (!((String)schemaFileName).endsWith(".xsd")) {
            schemaFileName = (String)schemaFileName + ".xsd";
        }
        if ((schemaFile = new File((String)schemaFileName)).exists()) {
            source = new StreamSource(schemaFile);
            _logger.info("schema loaded from filesystem: " + schemaFile.getAbsolutePath());
        } else {
            InputStream resourceStream = SchemaValidator.class.getResourceAsStream(SCHEMA_RESOURCE_ROOT + (String)schemaFileName);
            source = new StreamSource(resourceStream);
            _logger.info("schema loaded from jar: " + (String)schemaFileName);
        }
        return source;
    }

    public List<SAXParseException> getErrorList() {
        return this._errorList;
    }

    public static void main(String[] args) {
        String xmlFilePath = "c:/temp/ACS_CNG_NI_00314_fehler.txt.xml";
        String schemaRootPath = "c:/java/workspace/mbs_sun/mbs_transform/xsd";
        String schemaName = "c:/java/workspace/mbs_sun/mbs_transform/xsd/ABFKPF-ENSN.xsd";
        LogUtils.initLogging(Level.INFO);
        File xmlFile = new File(xmlFilePath);
        File schemaFile = new File(schemaName);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            SchemaValidator sv = SchemaValidator.getInstance(true);
            sv.setSchemaRootDir(schemaRootPath);
            boolean valid = sv.validateIDNode(xmlFile, schemaFile, "en_nr");
            _logger.info(xmlFile.getAbsolutePath() + " is " + (valid ? "valid" : "not valid"));
        }
        catch (Exception ex) {
            _logger.error("error validating " + xmlFilePath + " with schema " + schemaName, (Throwable)ex);
        }
    }

    public class SchemaResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInput lsi = null;
            _logger.debug("<resolveResource> type=" + type + ", namespaceURI=" + namespaceURI + ", publicID=" + publicId + ", systemID=" + systemId + ", baseURI=" + baseURI + ", resolveLocal=" + SchemaValidator.this._resolveLocal);
            if (SchemaValidator.this._resolveLocal) {
                File f = new File(SchemaValidator.this._schemaRootDir, systemId);
                try {
                    if (!f.exists() && !(f = new File(_schemaDir, systemId)).exists()) {
                        f = new File(SchemaValidator.this._schemaRootDir, new URL(systemId).getPath());
                    }
                    if (f.exists()) {
                        _schemaDir = f.getParentFile();
                        FileInputStream is = new FileInputStream(f);
                        lsi = SchemaValidator.this._domImplLS.createLSInput();
                        lsi.setByteStream(is);
                    } else {
                        _logger.warn("Datei nicht gefunden: " + f.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    _logger.error("Fehler beim Laden von " + systemId, (Throwable)e);
                }
            }
            return lsi;
        }
    }

    private class ValidationErrorHandler
    implements ErrorHandler {
        private ValidationErrorHandler() {
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            SchemaValidator.this._errorList.add(arg0);
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            _logger.fatal(arg0.getMessage());
            throw arg0;
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            SchemaValidator.this._warningList.add(arg0);
        }
    }
}

