/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import de.itu.xml.XmlValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

@Deprecated
public class XercesAdapter {
    private static XercesAdapter theInstance = null;
    private static Logger _logger = LogManager.getLogger(XercesAdapter.class);
    public static final String ENCODING = "UTF-8";
    public static String[] ID_XS_DTD = new String[]{"-//W3C//DTD XMLSchema 200102//EN", "/de/itu/xml/XMLSchema.dtd"};

    private XercesAdapter() {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
    }

    public static synchronized XercesAdapter getInstance() {
        if (theInstance == null) {
            theInstance = new XercesAdapter();
        }
        return theInstance;
    }

    public Document createDocument(boolean namespaceaware) throws XmlException {
        DocumentBuilder db = this.getDocumentBuilder(namespaceaware);
        Document retVal = db.newDocument();
        return retVal;
    }

    public Document parseReader(Reader r, boolean namespaceaware) throws XmlException {
        DocumentBuilder db = this.getDocumentBuilder(namespaceaware);
        Document retVal = null;
        try {
            retVal = db.parse(new InputSource(r));
        }
        catch (IOException ioe) {
            throw new XmlException(ioe, "IOException");
        }
        catch (SAXException se) {
            throw new XmlException(se, "SAXException");
        }
        return retVal;
    }

    public Document parseFile(String pathname, boolean namespaceaware) throws XmlException {
        return this.parseFile(new File(pathname), namespaceaware);
    }

    public Document parseFile(File file, boolean namespaceaware) throws XmlException {
        DocumentBuilder db = this.getDocumentBuilder(namespaceaware);
        Document retVal = this.parseFile0(db, file);
        return retVal;
    }

    public Document parse(InputSource is, boolean namespaceaware) throws XmlException {
        DocumentBuilder db = this.getDocumentBuilder(namespaceaware);
        Document retVal = this.parseInputSource(db, is);
        return retVal;
    }

    public Document parseNSFile(String xmlName, String schemaName) throws XmlException {
        return this.parseNSFile(new File(xmlName), schemaName);
    }

    public Document parseNSFile(File xml, String schemaName) throws XmlException {
        return this.parseFile(xml, schemaName, null, true);
    }

    public Document parseFile(File xml, String schemaName, String idNodeName, boolean namespaceaware) throws XmlException {
        ParserErrorHandler eh = new ParserErrorHandler();
        DocumentBuilder db = this.getDocumentBuilderWithSchema(schemaName, namespaceaware);
        db.setErrorHandler(eh);
        Document retVal = null;
        _logger.debug("parsing '" + xml.getAbsolutePath() + "' with schema '" + schemaName);
        retVal = this.parseFile0(db, xml);
        _logger.debug("parsing with schema done, fatals: " + eh.fatals + ", errors: " + eh.errors);
        if (eh.errors > 0 || eh.fatals > 0) {
            _logger.error("***************** Schema validation failed *****************");
            _logger.error("XML-File: " + xml.getAbsolutePath());
            _logger.error("Schema-File: " + schemaName);
            for (int i = 0; i < eh._excList.size(); ++i) {
                SAXParseException exc = eh._excList.get(i);
                String msg = exc.getMessage();
                _logger.error("Error in line:" + exc.getLineNumber() + ", column:" + exc.getColumnNumber() + ", message:" + exc.getMessage());
                if (idNodeName == null || !msg.startsWith("cvc-type")) continue;
                String tmp = msg.substring(msg.indexOf(39) + 1);
                String val = tmp.substring(0, tmp.indexOf(39));
                tmp = tmp.substring(tmp.indexOf(39) + 1);
                tmp = tmp.substring(tmp.indexOf(39) + 1);
                String elem = tmp.substring(0, tmp.indexOf(39));
                String xPath = "//*[descendant::" + elem + "[child::text()='" + val + "']]/" + idNodeName;
                NodeList nl = XPathFacade.getInstance().evaluateNodeList(retVal, xPath);
                StringBuffer context = new StringBuffer();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node node = nl.item(j);
                    if (!node.hasChildNodes()) continue;
                    if (context.length() > 0) {
                        context.append(", ");
                    }
                    context.append(node.getNodeName() + "=" + node.getFirstChild().getNodeValue());
                }
                _logger.error("*** " + context.toString() + " ***");
            }
            _logger.error("************************************************************");
            throw new XmlValidationException("Schema validation failed, errors: " + eh.errors + ", fatals: " + eh.fatals, eh._excList);
        }
        return retVal;
    }

    public void saveDocument(Document doc, String pathname) throws XmlException {
        this.saveDocument(doc, new File(pathname));
    }

    public void saveDocument(Document doc, String pathname, String encoding) throws XmlException {
        this.saveDocument(doc, new File(pathname), encoding);
    }

    public void saveDocument(Document doc, File file) throws XmlException {
        this.saveDocument(doc, file, ENCODING);
    }

    public void saveDocument(Document doc, File file, String encoding) throws XmlException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        }
        catch (FileNotFoundException fnfe) {
            throw new XmlException(fnfe, "FileNotFoundException: " + fnfe.getMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new XmlException(uee, "UnsupportedEncodingException");
        }
        this.saveDocument(doc, pw, encoding);
        pw.flush();
        pw.close();
    }

    public void saveDocument(Document doc, PrintWriter pw) throws XmlException {
        this.saveDocument(doc, pw, ENCODING);
    }

    @Deprecated
    public void saveDocument(Document doc, PrintWriter pw, String encoding) throws XmlException {
        OutputFormat of = new OutputFormat(doc);
        of.setLineSeparator("\n");
        of.setIndenting(true);
        of.setIndent(2);
        of.setLineWidth(255);
        of.setEncoding(encoding);
        of.setPreserveSpace(true);
        SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"xml");
        Serializer ser = factory.makeSerializer((Writer)pw, of);
        try {
            DOMSerializer ds = ser.asDOMSerializer();
            ds.serialize(doc);
        }
        catch (IOException ioe) {
            throw new XmlException(ioe, "IOException");
        }
    }

    public Properties getFeatures() {
        Properties props = new Properties();
        DOMParser parser = new DOMParser();
        Vector<String> features = this.getFeatureNames();
        Enumeration<String> en = features.elements();
        while (en.hasMoreElements()) {
            String value;
            String key = en.nextElement().toString();
            try {
                value = new Boolean(parser.getFeature(key)).toString();
            }
            catch (SAXNotSupportedException e) {
                value = "not supported";
            }
            catch (SAXNotRecognizedException e) {
                value = "not recognized";
            }
            props.setProperty(key, value);
        }
        return props;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        DOMParser parser = new DOMParser();
        Vector<String> properties = this.getPropertyNames();
        Enumeration<String> en = properties.elements();
        while (en.hasMoreElements()) {
            String value;
            String key = en.nextElement().toString();
            try {
                Object temp = parser.getProperty(key);
                value = temp == null ? "- null -" : temp.toString();
            }
            catch (SAXNotSupportedException e) {
                value = "not supported";
            }
            catch (SAXNotRecognizedException e) {
                value = "not recognized";
            }
            props.setProperty(key, value);
        }
        return props;
    }

    private DocumentBuilder getDocumentBuilder(boolean namespaceaware) throws XmlException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceaware);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e, "ParserConfigurationException");
        }
        return db;
    }

    private DocumentBuilder getDocumentBuilderWithSchema(String schema, boolean namespaceAware) throws XmlException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        dbf.setValidating(true);
        dbf.setAttribute("http://apache.org/xml/features/validation/schema", new Boolean(true));
        dbf.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", new Boolean(true));
        if (namespaceAware) {
            dbf.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", schema);
        } else {
            dbf.setAttribute("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", schema);
        }
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
            db.setEntityResolver(new MyEntityResolver());
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e, "ParserConfigurationException");
        }
        return db;
    }

    private Document parseFile0(DocumentBuilder db, File file) throws XmlException {
        Document retVal = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new XmlException(fnfe, "FileNotFoundException: " + fnfe.getMessage());
        }
        try {
            retVal = db.parse(fis);
        }
        catch (IOException ioe) {
            throw new XmlException(ioe, "IOException");
        }
        catch (SAXException se) {
            throw new XmlException(se, "SAXException");
        }
        return retVal;
    }

    private Document parseInputSource(DocumentBuilder db, InputSource is) throws XmlException {
        Document retVal = null;
        try {
            retVal = db.parse(is);
        }
        catch (IOException ioe) {
            throw new XmlException(ioe, "IOException");
        }
        catch (SAXException se) {
            throw new XmlException(se, "SAXException");
        }
        return retVal;
    }

    private Vector<String> getFeatureNames() {
        Enumeration en = Constants.getXercesFeatures();
        Vector<String> names = new Vector<String>();
        while (en.hasMoreElements()) {
            names.addElement("http://apache.org/xml/features/" + (String)en.nextElement());
        }
        return names;
    }

    private Vector<String> getPropertyNames() {
        Enumeration en = Constants.getXercesProperties();
        Vector<String> names = new Vector<String>();
        while (en.hasMoreElements()) {
            names.addElement("http://apache.org/xml/properties/" + (String)en.nextElement());
        }
        return names;
    }

    private class ParserErrorHandler
    implements ErrorHandler {
        int errors = 0;
        int fatals = 0;
        List<SAXParseException> _excList = new ArrayList<SAXParseException>();

        private ParserErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this._excList.add(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ++this.errors;
            this._excList.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ++this.fatals;
            this._excList.add(exception);
        }
    }

    public class MyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
            _logger.debug("<resolveEntity> publicID=" + publicID + ", systemID=" + systemID);
            if (ID_XS_DTD[0].equals(publicID)) {
                try {
                    InputStream is = EntityResolver.class.getResourceAsStream(ID_XS_DTD[1]);
                    if (is != null) {
                        _logger.debug("<resolveEntity> inputStream loaded: " + ID_XS_DTD[1]);
                        return new InputSource(is);
                    }
                    _logger.warn("failed to resolve entity: " + ID_XS_DTD[1]);
                }
                catch (Exception ex) {
                    _logger.warn("failed to resolve: " + publicID, (Throwable)ex);
                }
            }
            return null;
        }
    }
}

