/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.config.schema.fxs;

import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.config.schema.fxs.FXSSCHEMATYPE;
import de.consist.bmu.rule.config.schema.fxs.FXSSchemaResourceResolver;
import de.consist.bmu.rule.error.BMUException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FXSSchemaValidator {
    private static final Log LOGGER = LogFactory.getLog(FXSSchemaValidator.class);
    private Schema _schema = null;

    public FXSSchemaValidator(List<FXSSCHEMATYPE> fxsSchemaList) {
        try {
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            for (FXSSCHEMATYPE fxsschematype : fxsSchemaList) {
                try {
                    File f = new File(fxsschematype.getLocation());
                    if (!f.exists() && !f.isAbsolute()) {
                        f = new File(RuleFactory.getInstance().getFxsSchemaBaseDir(), fxsschematype.getLocation());
                    }
                    if (f.exists()) {
                        sourceList.add(new StreamSource(new FileInputStream(f)));
                        continue;
                    }
                    LOGGER.error((Object)("Schema nicht gefunden: " + f.getAbsolutePath()));
                }
                catch (FileNotFoundException e) {
                    LOGGER.error((Object)("Schema not found: " + fxsschematype.getLocation()), (Throwable)e);
                }
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new FXSSchemaResourceResolver(fxsSchemaList));
            schemaFactory.setErrorHandler(new ValidationErrorHandler());
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMImplementationSourceImpl");
            this._schema = schemaFactory.newSchema(sourceList.toArray(new Source[0]));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error creating SchemaValidator", (Throwable)e);
        }
    }

    public final ValidationErrorHandler validate(Element document) throws BMUException {
        return this.validate(this._schema, document);
    }

    private final ValidationErrorHandler validate(Schema schema, Element document) throws BMUException {
        ValidationErrorHandler handler = null;
        try {
            Validator validator = schema.newValidator();
            handler = new ValidationErrorHandler();
            validator.setErrorHandler(handler);
            validator.validate(new DOMSource(document));
        }
        catch (SAXException e) {
            throw new BMUException("Schema validation error", e);
        }
        catch (IOException e) {
            throw new BMUException("Error loading schema", e);
        }
        return handler;
    }

    public static String exceptionToString(SAXException e) {
        Object retVal = "";
        if (e instanceof SAXParseException) {
            SAXParseException e2 = (SAXParseException)e;
            retVal = e2.getLocalizedMessage() + " (line " + Integer.toString(e2.getLineNumber()) + ", column " + Integer.toString(e2.getColumnNumber()) + ")";
        } else {
            retVal = e.getMessage();
        }
        return retVal;
    }

    public static class ValidationErrorHandler
    implements ErrorHandler {
        private static final int INT_10 = 10;
        private List<SAXParseException> _errorList = new ArrayList<SAXParseException>();
        private List<SAXParseException> _warningList = new ArrayList<SAXParseException>();

        public final List<SAXParseException> getErrorList() {
            return this._errorList;
        }

        public final List<SAXParseException> getWarningList() {
            return this._warningList;
        }

        @Override
        public final void error(SAXParseException arg0) throws SAXException {
            this._errorList.add(arg0);
            if (this._errorList.size() <= 10 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<error> " + FXSSchemaValidator.exceptionToString(arg0)));
            }
        }

        @Override
        public final void fatalError(SAXParseException arg0) throws SAXException {
            LOGGER.info((Object)("<fatalError>: " + FXSSchemaValidator.exceptionToString(arg0)), (Throwable)arg0);
            throw arg0;
        }

        @Override
        public final void warning(SAXParseException arg0) throws SAXException {
            this._warningList.add(arg0);
            if (this._warningList.size() <= 10 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<warning>: " + FXSSchemaValidator.exceptionToString(arg0)));
            }
        }
    }
}

