/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.config.schema.fxs.FXSSchemaValidator;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.FXSDokument;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public final class RuleImplFXSSchema
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplFXSSchema.class);

    public RuleImplFXSSchema(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> validateSubDoc(Node node, int index, String id) throws BMUException {
        LOGGER.debug((Object)("Validating sub-structure with id: " + id));
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = XmlUtils.newDocument(true);
        Node importedNode = doc.importNode(node, true);
        doc.appendChild(importedNode);
        doc.normalizeDocument();
        FXSSchemaValidator.ValidationErrorHandler handler = RuleFactory.getInstance().getFXSSchemaValidator().validate(doc.getDocumentElement());
        if (handler != null) {
            List<SAXParseException> errorList = handler.getErrorList();
            if (!errorList.isEmpty()) {
                for (SAXParseException saxParseException : errorList) {
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id + ", " + saxParseException.getMessage()));
                }
            }
        } else {
            LOGGER.error((Object)"Error validating document");
            throw new BMUException("Error validating document");
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        List<FXSDokument> fxsList = bmuDok.getMessageType().getFXSDokumentList();
        try {
            for (FXSDokument fxsDokument : fxsList) {
                Element elem = fxsDokument.getRootElement();
                String id = XPathFassade.getInstance().evaluate(elem, "parent::*/@lib:id");
                List<RuleResult> rrl = this.validateSubDoc(elem, index, id);
                index += rrl.size();
                ruleResultList.addAll(rrl);
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        return builder.toString();
    }
}

