/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.BMUKopfdaten;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplLayerID
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String[] XPATH_BGS_LAYER = new String[]{"/descendant::bgs:BGSVorlageLayer", "/descendant::bgs:BGSErgaenzungsLayer"};
    private static final String[] XPATH_BGS_LAYER_ID = new String[]{"/descendant::bgs:BGSERZLayer/@lib:LayerID[not(starts-with(.,'ERZ'))]", "/descendant::bgs:BGSBEFLayer/@lib:LayerID[not(starts-with(.,'BEF'))]", "/descendant::bgs:BGSZWLLayer/@lib:LayerID[not(starts-with(.,'ZWL'))]", "/descendant::bgs:BGSENTLayer/@lib:LayerID[not(starts-with(.,'ENT'))]", "/descendant::bgs:BGSBEHLayer/@lib:LayerID[not(starts-with(.,'BEH'))]"};
    private static final String[] XPATH_ENS_LAYER = new String[]{"/descendant::en:ENSNVorlageLayer", "/descendant::en:ENSNErgaenzungsLayer"};
    private static final String[] XPATH_EN_LAYER_ID = new String[]{"/descendant::en:ENSNERZLayer/@lib:LayerID[not(starts-with(.,'ERZ')) and not(starts-with(.,'BVE'))]", "/descendant::en:ENSNENTLayer/@lib:LayerID[not(starts-with(.,'ENT'))]", "/descendant::en:ENSNBEHLayer/@lib:LayerID[not(starts-with(.,'BEH'))]"};
    private static final String[] XPATH_SN_LAYER_ID = new String[]{"/descendant::en:ENSNERZLayer/@lib:LayerID[not(starts-with(.,'BEF'))]", "/descendant::en:ENSNENTLayer/@lib:LayerID[not(starts-with(.,'ENT'))]", "/descendant::en:ENSNBEHLayer/@lib:LayerID[not(starts-with(.,'BEH'))]"};
    private static final String[] XPATH_UNS_LAYER = new String[]{"/descendant::bgs:UNSVorlageLayer", "/descendant::bgs:UNSBasisLayer", "/descendant::bgs:UNSErgaenzungsLayer"};
    private static final String[] XPATH_FR_LAYER_ID = new String[]{"/descendant::en:FRENTLayer/@lib:LayerID[not(starts-with(.,'ENT'))]", "/descendant::en:FRBEHLayer/@lib:LayerID[not(starts-with(.,'BEH'))]"};
    private static final Log LOGGER = LogFactory.getLog(RuleImplLayerID.class);

    public RuleImplLayerID(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> checkLayerIdATBRolle(Document doc, String xPath, int index) throws BMUException {
        NodeList layerNodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            layerNodeList = XPathFassade.getInstance().evaluateNodeList(doc, xPath);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int foundIndex = index;
        for (int i = 0; i < layerNodeList.getLength(); ++i) {
            BMUKopfdaten.Rolle rolle;
            Element layerNode = (Element)layerNodeList.item(i);
            String atbRolle = layerNode.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBRolle");
            String layerID = layerNode.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID");
            if (layerID.startsWith((rolle = BMUKopfdaten.Rolle.valueOf(atbRolle)).getIDRolle())) continue;
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), foundIndex++, layerID));
        }
        return ruleResultList;
    }

    private List<RuleResult> checkLayerId(Document doc, String xPath, int index) throws BMUException {
        NodeList layerNodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            layerNodeList = XPathFassade.getInstance().evaluateNodeList(doc, xPath);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        for (int i = 0; i < layerNodeList.getLength(); ++i) {
            Node layerIdNode = layerNodeList.item(i);
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index + i, layerIdNode.getTextContent()));
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        int index = 1;
        switch (msgType.getEnumType()) {
            case BGSDokument: {
                for (String xPath : XPATH_BGS_LAYER) {
                    ruleResultList.addAll(this.checkLayerIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                for (String xPath : XPATH_BGS_LAYER_ID) {
                    ruleResultList.addAll(this.checkLayerId(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case UNSDokument: {
                for (String xPath : XPATH_UNS_LAYER) {
                    ruleResultList.addAll(this.checkLayerIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case ENSNDokument: {
                for (String xPath : XPATH_ENS_LAYER) {
                    ruleResultList.addAll(this.checkLayerIdATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                String[] xPathList = null;
                if (BMUMessageType.ENStatus.EN.equals((Object)msgType.getENStatus())) {
                    xPathList = XPATH_EN_LAYER_ID;
                } else if (BMUMessageType.ENStatus.SN.equals((Object)msgType.getENStatus())) {
                    xPathList = XPATH_SN_LAYER_ID;
                } else {
                    LOGGER.warn((Object)"Pr\u00fcfregel 'LayerID' wird nicht vollst\u00e4ndig angewendet, weil nicht ermittelt werden konnte, ob es sich um einen EN oder SN handelt!");
                }
                if (xPathList == null) break;
                for (String xPath : xPathList) {
                    ruleResultList.addAll(this.checkLayerId(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case FRDokument: {
                for (String xPath : XPATH_FR_LAYER_ID) {
                    ruleResultList.addAll(this.checkLayerId(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + String.valueOf((Object)msgType.getEnumType())));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Begleitscheinen");
        builder.append("\n");
        builder.append("1. Rolle in der Layer-ID muss der Rolle in ATBRolle des Layers entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_LAYER));
        builder.append("\n");
        builder.append("2. Rolle in der Layer-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_LAYER_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von \u00dcbernahmescheinen (Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_UNS_LAYER));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Nachweisen (Rolle in der Layer-ID muss der Rolle in ATBRolle des Layers entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_ENS_LAYER));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Entsorgungsnachweisen (Rolle in der Layer-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_EN_LAYER_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Sammelentsorgungsnachweisen (Rolle in der Layer-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_SN_LAYER_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Freistellungen (Rolle in der Signatur-ID muss der f\u00fcr diesen Layer zu erwartenden Rolle entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_FR_LAYER_ID));
        return builder.toString();
    }
}

