/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSchemaDefaultNS
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSchemaDefaultNS.class);
    private static final String XPATH_DEFAULT_NS = "//*/namespace::*[name()='']";

    public RuleImplSchemaDefaultNS(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            NodeList nodeList = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_DEFAULT_NS);
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                Attr a = (Attr)n;
                Element node = a.getOwnerElement();
                String path = XmlUtils.getNodePathShort(node);
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, path));
                LOGGER.debug((Object)("DefaultNSDeklaration gefunden: " + path));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_DEFAULT_NS);
        return builder.toString();
    }
}

