/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.JAMonDetailValue;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.MonitorImp;
import com.jamonapi.Range;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.Misc;
import com.jamonapi.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MonitorComposite
extends Monitor
implements DetailData {
    private static final long serialVersionUID = 279L;
    public static final String LOCAL = "local";
    private final Monitor[] monitors;
    private final int numRows;
    private static final int TYPICAL_NUM_CHILDREN = 200;
    private Map<MonKey, Monitor> map;
    private Date dateCreated;
    private String instanceName = "local";

    public MonitorComposite(Monitor[] monitors) {
        this.monitors = monitors;
        this.numRows = monitors == null ? 0 : monitors.length;
        this.initializeForLookUps();
        this.dateCreated = new Date();
    }

    private void initializeForLookUps() {
        this.map = new HashMap<MonKey, Monitor>();
        if (this.monitors != null) {
            Monitor[] monitorArray = this.monitors;
            int n = this.monitors.length;
            int n2 = 0;
            while (n2 < n) {
                Monitor mon = monitorArray[n2];
                this.map.put(mon.getMonKey(), mon);
                ++n2;
            }
        }
    }

    MonitorComposite() {
        this((Monitor[])null);
    }

    public Monitor[] getMonitors() {
        return this.monitors;
    }

    private Monitor[] getMonitorsWithUnits(String units) {
        if (this.monitors == null || units == null) {
            return null;
        }
        if ("AllMonitors".equalsIgnoreCase(units)) {
            return this.monitors;
        }
        int size = this.monitors.length;
        ArrayList<Monitor> rows = new ArrayList<Monitor>(this.monitors.length);
        int i = 0;
        while (i < size) {
            if (units.equalsIgnoreCase(this.monitors[i].getMonKey().getRangeKey())) {
                rows.add(this.monitors[i]);
            }
            ++i;
        }
        if (rows.size() == 0) {
            return null;
        }
        return rows.toArray(new MonitorImp[0]);
    }

    public Collection<String> getDistinctUnits() {
        TreeSet<String> units = new TreeSet<String>();
        int size = this.monitors.length;
        int i = 0;
        while (i < size) {
            units.add(this.monitors[i].getMonKey().getRangeKey());
            ++i;
        }
        return units;
    }

    public MonitorComposite filterByUnits(String units) {
        return new MonitorComposite(this.getMonitorsWithUnits(units)).setInstanceName(this.getInstanceName()).setDateCreated(this.getDateCreated());
    }

    public boolean exists(MonKey key) {
        return this.map.containsKey(key);
    }

    public Monitor getMonitor(MonKey key) {
        return this.map.get(key);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public MonitorComposite setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public boolean isLocalInstance() {
        return LOCAL.equalsIgnoreCase(this.instanceName);
    }

    public static MonitorComposite getMonitors(String[][] labels) {
        int numRows = labels == null ? 0 : labels.length;
        int numCols = labels[0] == null ? 0 : labels[0].length;
        Monitor[] monArray = new Monitor[numRows];
        int i = 0;
        while (i < numRows) {
            MonKeyImp key = null;
            if (numCols == 2) {
                key = new MonKeyImp(labels[i][0], labels[i][1]);
            } else if (numCols == 3) {
                key = new MonKeyImp(labels[i][0], labels[i][1], labels[i][2]);
            }
            monArray[i] = MonitorFactory.getMonitor(key);
            ++i;
        }
        return new MonitorComposite(monArray);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String[] getBasicHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getBasicHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public String[] getHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    public String[] getDisplayHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getDisplayHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public Object[][] getData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        int i = 0;
        while (i < this.numRows) {
            data[i] = this.getRowData((MonitorImp)this.monitors[i]);
            ++i;
        }
        return data;
    }

    public Object[][] getBasicData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        int i = 0;
        while (i < this.numRows) {
            data[i] = this.getBasicRowData((MonitorImp)this.monitors[i]);
            ++i;
        }
        return data;
    }

    public Object[][] getDisplayData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        int i = 0;
        while (i < this.numRows) {
            data[i] = this.getRowDisplayData((MonitorImp)this.monitors[i]);
            ++i;
        }
        return data;
    }

    public String getReport() {
        return this.getReport(0, "asc");
    }

    public String getReport(int sortCol, String sortOrder) {
        boolean LABEL = true;
        if (!this.hasData()) {
            return "";
        }
        String[] header = this.getBasicHeader();
        Object[][] data = Misc.sort(this.getBasicData(), sortCol, sortOrder);
        int rows = data.length;
        int cols = header.length;
        StringBuffer html = new StringBuffer(100000);
        html.append("\n<table border='1' rules='all'>\n");
        int i = 0;
        while (i < cols) {
            html.append("<th>" + header[i] + "</th>");
            ++i;
        }
        html.append("<th>" + header[1] + "</th>");
        html.append("\n");
        i = 0;
        while (i < rows) {
            html.append("<tr>");
            int j = 0;
            while (j < cols) {
                html.append("<td>" + String.valueOf(data[i][j]) + "</td>");
                ++j;
            }
            html.append("<td>" + String.valueOf(data[i][1]) + "</td>");
            html.append("</tr>\n");
            ++i;
        }
        html.append("</table>");
        return html.toString();
    }

    public boolean hasData() {
        return this.getNumRows() != 0;
    }

    private Object[] getRowData(MonitorImp mon) {
        ArrayList row = new ArrayList(200);
        mon.getRowData(row);
        return row.toArray();
    }

    private Object[] getBasicRowData(MonitorImp mon) {
        ArrayList row = new ArrayList();
        mon.getBasicRowData(row);
        return row.toArray();
    }

    private Object[] getRowDisplayData(MonitorImp mon) {
        ArrayList row = new ArrayList(200);
        mon.getRowDisplayData(row);
        return row.toArray();
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].reset();
            ++i;
        }
    }

    @Override
    public void disable() {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].disable();
            ++i;
        }
    }

    @Override
    public void enable() {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].enable();
            ++i;
        }
    }

    @Override
    public double getActive() {
        double value = 0.0;
        int i = 0;
        while (i < this.numRows) {
            value += this.monitors[i].getActive();
            ++i;
        }
        return value;
    }

    @Override
    public double getAvg() {
        double hits = this.getHits();
        double total = 0.0;
        int i = 0;
        while (i < this.numRows) {
            total += this.monitors[i].getTotal();
            ++i;
        }
        if (hits == 0.0) {
            return 0.0;
        }
        return total / hits;
    }

    @Override
    public double getAvgActive() {
        double weightedActive = 0.0;
        double totalHits = 0.0;
        int i = 0;
        while (i < this.numRows) {
            double hits = this.monitors[i].getHits();
            weightedActive = hits * this.monitors[i].getAvgActive();
            totalHits += hits;
            ++i;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedActive / totalHits;
    }

    @Override
    public Date getFirstAccess() {
        Date firstAccess = null;
        int i = 0;
        while (i < this.numRows) {
            Date thisDate = this.monitors[i].getFirstAccess();
            if (firstAccess == null || thisDate.compareTo(firstAccess) < 0) {
                firstAccess = thisDate;
            }
            ++i;
        }
        return firstAccess;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public MonitorComposite setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @Override
    public double getHits() {
        double value = 0.0;
        int i = 0;
        while (i < this.numRows) {
            value += this.monitors[i].getHits();
            ++i;
        }
        return value;
    }

    @Override
    public MonKey getMonKey() {
        if (!this.hasData()) {
            return null;
        }
        return this.getFirstMon().getMonKey();
    }

    @Override
    public Date getLastAccess() {
        Date lastAccess = null;
        int i = 0;
        while (i < this.numRows) {
            Date thisDate = this.monitors[i].getLastAccess();
            if (lastAccess == null || thisDate.compareTo(lastAccess) > 0) {
                lastAccess = thisDate;
            }
            ++i;
        }
        return lastAccess;
    }

    @Override
    public double getLastValue() {
        Date date = this.getLastAccess();
        int i = 0;
        while (i < this.numRows) {
            if (date.compareTo(this.monitors[i].getLastAccess()) >= 0) {
                return this.monitors[i].getLastValue();
            }
            ++i;
        }
        return 0.0;
    }

    @Override
    public double getMax() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numRows) {
            double thisMax = this.monitors[i].getMax();
            if (thisMax > max) {
                max = thisMax;
            }
            ++i;
        }
        return max;
    }

    @Override
    public double getMaxActive() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numRows) {
            double thisMax = this.monitors[i].getMaxActive();
            if (thisMax > max) {
                max = thisMax;
            }
            ++i;
        }
        return max;
    }

    @Override
    public double getMin() {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numRows) {
            double thisMin = this.monitors[i].getMin();
            if (thisMin < min) {
                min = thisMin;
            }
            ++i;
        }
        return min;
    }

    @Override
    public Range getRange() {
        return null;
    }

    @Override
    public double getStdDev() {
        double weightedStdDev = 0.0;
        double totalHits = 0.0;
        int i = 0;
        while (i < this.numRows) {
            double hits = this.monitors[i].getHits();
            weightedStdDev = hits * this.monitors[i].getStdDev();
            totalHits += hits;
            ++i;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedStdDev / totalHits;
    }

    @Override
    public double getTotal() {
        double value = 0.0;
        int i = 0;
        while (i < this.numRows) {
            value += this.monitors[i].getTotal();
            ++i;
        }
        return value;
    }

    @Override
    public boolean isEnabled() {
        int i = 0;
        while (i < this.numRows) {
            if (!this.monitors[i].isEnabled()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isPrimary() {
        int i = 0;
        while (i < this.numRows) {
            if (!this.monitors[i].isPrimary()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void setActive(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setActive(0.0);
            ++i;
        }
    }

    @Override
    public void setFirstAccess(Date date) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setFirstAccess(date);
            ++i;
        }
    }

    @Override
    public void setHits(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setHits(value);
            ++i;
        }
    }

    @Override
    public void setLastAccess(Date date) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setLastAccess(date);
            ++i;
        }
    }

    @Override
    public void setLastValue(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setLastValue(value);
            ++i;
        }
    }

    @Override
    public void setMax(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setMax(value);
            ++i;
        }
    }

    @Override
    public void setMaxActive(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setMaxActive(value);
            ++i;
        }
    }

    @Override
    public void setMin(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setMin(value);
            ++i;
        }
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setPrimary(isPrimary);
            ++i;
        }
    }

    @Override
    public void setTotal(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setTotal(value);
            ++i;
        }
    }

    @Override
    public void setTotalActive(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setTotalActive(value);
            ++i;
        }
    }

    @Override
    public Monitor start() {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].start();
            ++i;
        }
        return this;
    }

    @Override
    public Monitor stop() {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].stop();
            ++i;
        }
        return this;
    }

    private MonitorImp getFirstMon() {
        return (MonitorImp)this.monitors[0];
    }

    @Override
    public Monitor add(double value) {
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].add(value);
            ++i;
        }
        return this;
    }

    @Override
    public boolean hasListeners() {
        if (super.hasListeners()) {
            return true;
        }
        int i = 0;
        while (i < this.numRows) {
            if (this.monitors[i].hasListeners()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public JAMonDetailValue getJAMonDetailRow() {
        return JAMonDetailValue.NULL_VALUE;
    }

    @Override
    public void setActivityTracking(boolean trackActivity) {
        super.setActivityTracking(trackActivity);
        int i = 0;
        while (i < this.numRows) {
            this.monitors[i].setActivityTracking(trackActivity);
            ++i;
        }
    }

    public MonitorComposite copy() {
        return (MonitorComposite)SerializationUtils.deepCopy(this);
    }
}

