/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RangeHolder
implements Serializable {
    private static final long serialVersionUID = 278L;
    List ranges = new ArrayList();
    private boolean isLessThan = false;
    private String lastHeader = "";

    public RangeHolder(String logical) {
        this.isLessThan = "<".equals(logical);
    }

    public RangeHolder() {
    }

    public void add(String displayHeader, double endPoint) {
        this.ranges.add(new RangeHolderItem(displayHeader, endPoint));
    }

    public void addLastHeader(String lastHeader) {
        this.lastHeader = lastHeader;
    }

    String getLastHeader() {
        return this.lastHeader;
    }

    static RangeHolder getMSHolder() {
        RangeHolder rh = new RangeHolder("<");
        rh.add("LessThan_0ms", 0.0);
        rh.add("0_10ms", 10.0);
        rh.add("10_20ms", 20.0);
        rh.add("20_40ms", 40.0);
        rh.add("40_80ms", 80.0);
        rh.add("80_160ms", 160.0);
        rh.add("160_320ms", 320.0);
        rh.add("320_640ms", 640.0);
        rh.add("640_1280ms", 1280.0);
        rh.add("1280_2560ms", 2560.0);
        rh.add("2560_5120ms", 5120.0);
        rh.add("5120_10240ms", 10240.0);
        rh.add("10240_20480ms", 20480.0);
        rh.addLastHeader("GreaterThan_20480ms");
        return rh;
    }

    static RangeHolder getPercentHolder() {
        RangeHolder rh = new RangeHolder("<=");
        rh.add("LessThanEqual_0", 0.0);
        rh.add("0_10", 10.0);
        rh.add("10_20", 20.0);
        rh.add("20_30", 30.0);
        rh.add("30_40", 40.0);
        rh.add("40_50", 50.0);
        rh.add("50_60", 60.0);
        rh.add("60_70", 70.0);
        rh.add("70_80", 80.0);
        rh.add("80_90", 90.0);
        rh.add("90_100", 100.0);
        rh.addLastHeader("GreaterThan_100");
        return rh;
    }

    boolean isLessThan() {
        return this.isLessThan;
    }

    RangeHolderItem get(int i) {
        return (RangeHolderItem)this.ranges.get(i);
    }

    String[] getDisplayHeader() {
        int size = this.ranges.size();
        if (size == 0) {
            return null;
        }
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            RangeHolderItem item = (RangeHolderItem)this.ranges.get(i);
            array[i] = item.getDisplayHeader();
            ++i;
        }
        return array;
    }

    double[] getEndPoints() {
        int size = this.ranges.size();
        if (size == 0) {
            return null;
        }
        double[] array = new double[size];
        int i = 0;
        while (i < size) {
            RangeHolderItem item = (RangeHolderItem)this.ranges.get(i);
            array[i] = item.getEndPoint();
            ++i;
        }
        return array;
    }

    int getSize() {
        return this.ranges.size();
    }

    static class RangeHolderItem
    implements Serializable {
        private static final long serialVersionUID = 278L;
        private String displayHeader;
        private double endPoint;

        public RangeHolderItem(String displayHeader, double endPoint) {
            this.displayHeader = displayHeader;
            this.endPoint = endPoint;
        }

        public String getDisplayHeader() {
            return this.displayHeader;
        }

        public double getEndPoint() {
            return this.endPoint;
        }
    }
}

