/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.BasicTimingMonitor;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;

public class TestClassPerformance {
    private int testIterations;
    private Monitor testMon;

    public TestClassPerformance() {
        this(100000);
    }

    public TestClassPerformance(int testIterations) {
        this.testIterations = testIterations;
    }

    public void timingNoMonitor() throws Exception {
        System.out.println("\ntimingNoMonitor() - timing the old fashioned way with System.currentTimeMillis() (i.e.no monitors)");
        System.out.println("System.currentTimeMillis() - startTime");
        long startTime = 0L;
        int i = 0;
        while (i < this.testIterations) {
            startTime = System.currentTimeMillis() - System.currentTimeMillis() - startTime;
            ++i;
        }
    }

    public void basicTimingMonitor() throws Exception {
        System.out.println("\nbasicTimingMonitor() - this is the most lightweight of the Monitors");
        System.out.println("\tBasicTimingMonitor mon=new BasicTimingMonitor();");
        System.out.println("\tmon.start()");
        System.out.println("\tmon.stop()");
        BasicTimingMonitor mon = new BasicTimingMonitor();
        int i = 0;
        while (i < this.testIterations) {
            mon.start();
            mon.stop();
            ++i;
        }
    }

    public void nullMonitor() throws Exception {
        System.out.println("\nNullMonitor() - Factory disabled so a NullMonitor is returned");
        System.out.println("\tMonitorFactory.setEnabled(false);");
        System.out.println("\tMonitor mon=MonitorFactory.start();");
        System.out.println("\tmon.stop()");
        MonitorFactory.setEnabled(false);
        int i = 0;
        while (i < this.testIterations) {
            this.testMon = MonitorFactory.start();
            this.testMon.stop();
            ++i;
        }
        MonitorFactory.setEnabled(true);
    }

    public void nullMonitor2() throws Exception {
        System.out.println("\nNullMonitor2() - Factory disabled so a NullMonitor is returned");
        System.out.println("\tMonitorFactory.setEnabled(false);");
        System.out.println("\tMonitor mon=MonitorFactory.start('pages.admin');");
        System.out.println("\tmon.stop()");
        MonitorFactory.setEnabled(false);
        int i = 0;
        while (i < this.testIterations) {
            this.testMon = MonitorFactory.start("pages.admin");
            this.testMon.stop();
            ++i;
        }
        MonitorFactory.setEnabled(true);
    }

    public void factoryBasicMonitor() throws Exception {
        System.out.println("\nbasic Factory TimingMonitor()");
        System.out.println("\tMonitor mon=MonitorFactory.start();");
        System.out.println("\tmon.stop();");
        int i = 0;
        while (i < this.testIterations) {
            this.testMon = MonitorFactory.start();
            this.testMon.stop();
            ++i;
        }
    }

    public void factoryMonitor() throws Exception {
        System.out.println("\nFull Factory TimingMonitor()- uses cached version so doesn't create child monitors");
        System.out.println("\tMonitor mon=MonitorFactory.start('pages.admin');");
        System.out.println("\tmon.stop();");
        int i = 0;
        while (i < this.testIterations) {
            this.testMon = MonitorFactory.start("pages.admin");
            this.testMon.stop();
            ++i;
        }
        System.out.println(this.testMon);
    }

    public void addMonitor() throws Exception {
        System.out.println("Calling add...\n");
        System.out.println("\tMonitorFactory.add('label','units',1);");
        int i = 0;
        while (i < this.testIterations) {
            MonitorFactory.add("label", "units", 1.0);
            ++i;
        }
        System.out.println(MonitorFactory.getMonitor("label", "units"));
    }

    private static void log(Monitor mon) {
        System.out.println("It took " + String.valueOf(mon));
    }

    public static void main(String[] args) throws Exception {
        TestClassPerformance test;
        if (args.length == 0) {
            test = new TestClassPerformance();
        } else {
            int testIterations = Integer.parseInt(args[0]);
            test = new TestClassPerformance(testIterations);
        }
        System.out.println("\n***** Performance Tests:");
        System.out.println("All performance code loops " + test.testIterations + " times");
        Monitor totalTime = MonitorFactory.start();
        Monitor timingMon = MonitorFactory.start();
        test.timingNoMonitor();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.basicTimingMonitor();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.nullMonitor();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.nullMonitor2();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.factoryBasicMonitor();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.factoryMonitor();
        TestClassPerformance.log(timingMon.stop());
        System.out.println("\nExecuting full factory monitors a second time.  The second time reflects performance characteristics more accurately");
        timingMon.start();
        test.factoryMonitor();
        TestClassPerformance.log(timingMon.stop());
        timingMon.start();
        test.addMonitor();
        TestClassPerformance.log(timingMon.stop());
        Monitor delme = MonitorFactory.start("/jamon/jamonadmin.jsp");
        JAMonBufferListener jbl = new JAMonBufferListener();
        delme.addListener("max", jbl);
        MonitorFactory.getMonitor("/jamon/jamonadmin.jsp", "ms.").add(100.0);
        jbl = (JAMonBufferListener)MonitorFactory.getMonitor("/jamon/jamonadmin.jsp", "ms.").getListenerType("max").getListener();
        Object[][] data = jbl.getDetailData().getData();
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                System.out.println(data[i][j]);
                ++j;
            }
            ++i;
        }
        System.out.println("\n***** Total time for performance tests were: " + String.valueOf(totalTime.stop()));
    }
}

