/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.Monitor;
import java.util.Date;

class MonitorDelta {
    private String label;
    private String units;
    private double total;
    private double hits;
    private double avg;
    private double min;
    private double max;
    private double stdDev;
    private Date firstAccess;
    private Date lastAccess;
    private double lastValue;
    private double active;
    private double maxActive;
    private double avgActive;

    public MonitorDelta() {
    }

    public MonitorDelta(Monitor mon) {
        this.label = mon.getLabel();
        this.units = mon.getUnits();
        this.hits = mon.getHits();
        this.total = mon.getTotal();
        this.avg = mon.getAvg();
        this.min = mon.getMin();
        this.max = mon.getMax();
        this.stdDev = mon.getStdDev();
        this.firstAccess = mon.getFirstAccess();
        this.lastAccess = mon.getLastAccess();
        this.lastValue = mon.getLastValue();
        this.active = mon.getActive();
        this.maxActive = mon.getMaxActive();
        this.avgActive = mon.getAvgActive();
    }

    public MonitorDelta delta(MonitorDelta previous) {
        double currentAverage;
        MonitorDelta delta = new MonitorDelta();
        delta.label = this.label;
        delta.units = this.units;
        delta.hits = this.hits - previous.getHits();
        delta.total = this.total - previous.getTotal();
        delta.avg = currentAverage = this.hits > previous.getHits() ? (this.total - previous.getTotal()) / (this.hits - previous.getHits()) : 0.0;
        delta.min = this.min - previous.getMin();
        delta.max = this.max - previous.getMax();
        delta.stdDev = this.stdDev - previous.getStdDev();
        delta.firstAccess = this.firstAccess;
        delta.lastAccess = this.lastAccess;
        delta.lastValue = this.lastValue - previous.getLastValue();
        delta.active = this.active - previous.getActive();
        delta.maxActive = this.maxActive - previous.getMaxActive();
        delta.avgActive = this.avgActive - previous.getAvgActive();
        return delta;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnits() {
        return this.units;
    }

    public double getTotal() {
        return this.total;
    }

    public double getHits() {
        return this.hits;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public Date getFirstAccess() {
        return this.firstAccess;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    public double getActive() {
        return this.active;
    }

    public double getMaxActive() {
        return this.maxActive;
    }

    public double getAvgActive() {
        return this.avgActive;
    }
}

