/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.jmx.JamonJmxBeanProperty;
import com.jamonapi.jmx.JamonJmxBeanPropertyDefault;
import com.jamonapi.jmx.JmxUtils;
import com.jamonapi.jmx.MonitorMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MonitorMXBeanImp
implements MonitorMXBean {
    protected final List<JamonJmxBeanProperty> jmxProperties;
    protected final String label;
    protected final String units;
    protected final String name;

    public MonitorMXBeanImp(List<JamonJmxBeanProperty> jmxProperties) {
        this.label = jmxProperties.get(0).getLabel();
        this.units = jmxProperties.get(0).getUnits();
        this.name = jmxProperties.get(0).getName();
        this.jmxProperties = jmxProperties;
    }

    public MonitorMXBeanImp(String label, String units) {
        this(label, units, label);
    }

    public MonitorMXBeanImp(String label, String units, String name) {
        this(MonitorMXBeanImp.init(label, units, name));
    }

    private static List<JamonJmxBeanProperty> init(String label, String units, String name) {
        JamonJmxBeanPropertyDefault property = new JamonJmxBeanPropertyDefault(label, units, name);
        ArrayList<JamonJmxBeanProperty> properties = new ArrayList<JamonJmxBeanProperty>();
        properties.add(property);
        return properties;
    }

    @Override
    public String getLabel() {
        return (String)JmxUtils.getValue(this.jmxProperties, "label", this.label);
    }

    @Override
    public String getUnits() {
        return (String)JmxUtils.getValue(this.jmxProperties, "units", this.units);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getTotal() {
        return this.getDouble("total");
    }

    @Override
    public double getAvg() {
        return this.getDouble("avg");
    }

    @Override
    public double getMin() {
        return this.getDouble("min");
    }

    @Override
    public double getMax() {
        return this.getDouble("max");
    }

    @Override
    public double getHits() {
        return this.getDouble("hits");
    }

    @Override
    public double getStdDev() {
        return this.getDouble("stddev");
    }

    @Override
    public Date getFirstAccess() {
        return this.getDate("firstaccess");
    }

    @Override
    public Date getLastAccess() {
        return this.getDate("lastaccess");
    }

    @Override
    public double getLastValue() {
        return this.getDouble("lastvalue");
    }

    @Override
    public double getActive() {
        return this.getDouble("active");
    }

    @Override
    public double getMaxActive() {
        return this.getDouble("maxactive");
    }

    @Override
    public double getAvgActive() {
        return this.getDouble("avgactive");
    }

    private double getDouble(String value) {
        return JmxUtils.getDouble(this.jmxProperties, value);
    }

    private Date getDate(String value) {
        return JmxUtils.getDate(this.jmxProperties, value);
    }
}

