/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.BasicTimingMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxy;
import com.jamonapi.proxy.MonProxyFactory;
import com.jamonapi.proxy.MonProxyLabelerInt;
import com.jamonapi.proxy.Params;
import com.jamonapi.proxy.SQLDeArger;
import com.jamonapi.utils.Misc;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class JDBCMonProxy
extends MonProxy {
    private static Map statementsMap = Collections.synchronizedMap(new WeakHashMap());
    private static Long DEFAULT_SQL_TIME = new Long(-99L);
    private static int ARGS_SQL_STATEMENT = 0;
    private static int SQL_EXECUTION_TIME_IND = 2;
    private static int SQL_EXCEPTION_IND = 5;

    JDBCMonProxy(Object monitoredObj, Params params, MonProxyLabelerInt labelerInt) {
        super(monitoredObj, params, labelerInt);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BasicTimingMonitor mon = null;
        Object[] row = null;
        SQLDeArgMon sqlMon = null;
        String stackTrace = "";
        boolean isSQLSummaryEnabled = this.params.isSQLSummaryEnabled && this.params.isEnabled;
        boolean isSQLDetailEnabled = this.params.isSQLDetailEnabled && this.params.isEnabled;
        boolean executingQuery = this.isExecuteQueryMethod(method.getName());
        try {
            if (executingQuery && (isSQLSummaryEnabled || isSQLDetailEnabled)) {
                String actualSQL = null;
                mon = new BasicTimingMonitor();
                mon.start();
                int statementReuseCounter = 0;
                if (this.isStatementObject(args)) {
                    actualSQL = this.getSQL(args[ARGS_SQL_STATEMENT]);
                    sqlMon = new SQLDeArgMon("Statement", actualSQL, this.params.matchStrings);
                } else {
                    sqlMon = (SQLDeArgMon)statementsMap.get(this.getMonitoredObject());
                    statementReuseCounter = sqlMon.incrementCounter();
                    if (isSQLSummaryEnabled) {
                        MonitorFactory.add("MonProxy-SQL-PreparedStatement Reuse", "count", 2 * statementReuseCounter);
                    }
                    actualSQL = this.getSQL(sqlMon.getSQL());
                }
                if (isSQLSummaryEnabled) {
                    sqlMon.start();
                }
                if (isSQLDetailEnabled) {
                    row = new Object[]{new Long(++this.params.sqlID), new Date(), DEFAULT_SQL_TIME, new Integer(statementReuseCounter), actualSQL, "", method.toString()};
                    this.params.sqlBuffer.addRow(row);
                }
            }
            Object returnValue = super.invoke(proxy, method, args);
            if (!this.params.isEnabled || returnValue instanceof MonProxy) {
                Object object = returnValue;
                return object;
            }
            if ((isSQLSummaryEnabled || isSQLDetailEnabled) && this.returnsPreparedStatement(method.getName()) && this.isPreparedStatement(returnValue)) {
                String actualSQL = this.getSQL(args[ARGS_SQL_STATEMENT]);
                statementsMap.put(returnValue, new SQLDeArgMon("PreparedStatement", actualSQL, this.params.matchStrings));
                Object object = this.monitorJDBC(returnValue);
                return object;
            }
            if ((isSQLSummaryEnabled || isSQLDetailEnabled) && (this.shouldMonitorResultSet(returnValue) || this.shouldMonitorOtherJDBC(returnValue))) {
                Object object = this.monitorJDBC(returnValue);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        catch (Throwable e) {
            if (executingQuery && isSQLDetailEnabled && row != null) {
                row[JDBCMonProxy.SQL_EXCEPTION_IND] = stackTrace = Misc.getExceptionTrace(e);
            }
            throw e;
        }
        finally {
            if (mon != null && executingQuery) {
                long executionTime = mon.stop();
                if (isSQLDetailEnabled && row != null) {
                    row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime);
                }
                if (isSQLSummaryEnabled) {
                    sqlMon.add(executionTime).appendDetails(stackTrace).stop();
                }
            }
        }
    }

    private boolean isExecuteQueryMethod(String methodName) {
        return "executeQuery".equals(methodName) || "executeUpdate".equals(methodName) || "execute".equals(methodName);
    }

    private boolean returnsPreparedStatement(String methodName) {
        return "prepareStatement".equals(methodName) || "prepareCall".equals(methodName);
    }

    private boolean isStatementObject(Object[] args) {
        return args != null && args.length >= 1;
    }

    private boolean shouldMonitorOtherJDBC(Object value) {
        return value instanceof Statement || value instanceof Connection;
    }

    private boolean shouldMonitorResultSet(Object value) {
        return value instanceof ResultSet && this.params.isResultSetEnabled && this.params.isInterfaceEnabled;
    }

    private Object monitorJDBC(Object returnValue) {
        if (returnValue instanceof ResultSet) {
            returnValue = MonProxyFactory.monitor((ResultSet)returnValue);
            this.cloneLabeler(returnValue);
        } else if (returnValue instanceof CallableStatement) {
            returnValue = MonProxyFactory.monitor((CallableStatement)returnValue);
            this.cloneLabeler(returnValue);
        } else if (returnValue instanceof PreparedStatement) {
            returnValue = MonProxyFactory.monitor((PreparedStatement)returnValue);
            this.cloneLabeler(returnValue);
        } else if (returnValue instanceof Statement) {
            returnValue = MonProxyFactory.monitor((Statement)returnValue);
            this.cloneLabeler(returnValue);
        } else if (returnValue instanceof Connection) {
            returnValue = MonProxyFactory.monitor((Connection)returnValue);
            this.cloneLabeler(returnValue);
        }
        return returnValue;
    }

    private void cloneLabeler(Object returnValue) {
        MonProxyLabelerInt labeler = this.getLabeler();
        MonProxy monProxy = MonProxyFactory.getMonProxy((Proxy)returnValue);
        labeler = (MonProxyLabelerInt)labeler.clone();
        labeler.init(monProxy);
        monProxy.setLabeler(labeler);
    }

    private boolean isPreparedStatement(Object value) {
        return value instanceof PreparedStatement;
    }

    private String getSQL(Object sql) {
        return sql == null ? "null sql" : sql.toString();
    }

    private static class SQLDeArgMon {
        private int accessCounter = 0;
        private String sql;
        private int monRows;
        private static final int LABEL_IND = 0;
        private MonitorComposite monitors = null;
        private String[][] data = null;

        SQLDeArgMon(String statementType, String sql, List matchStrings) {
            SQLDeArger sqld = new SQLDeArger(sql, matchStrings, MonitorFactory.getMaxSqlSize());
            this.sql = sqld.getParsedSQL();
            this.data = sqld.getAll();
            this.monRows = this.data.length;
            int i = 0;
            while (i < this.monRows) {
                StringBuffer label = new StringBuffer("MonProxy-SQL-");
                this.data[i][0] = i == 0 ? label.append("Type: ").append(this.data[i][0]).toString() : (i == 1 ? label.append("Type: ").append(this.data[i][0]).toString() : (i == 2 ? label.append(statementType).append(": ").append(this.data[i][0]).toString() : label.append("Match: ").append(this.data[i][0]).toString()));
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SQLDeArgMon start() {
            SQLDeArgMon sQLDeArgMon = this;
            synchronized (sQLDeArgMon) {
                if (this.monitors == null) {
                    this.monitors = MonitorComposite.getMonitors(this.data);
                    this.data = null;
                }
            }
            this.monitors.start();
            return this;
        }

        private SQLDeArgMon appendDetails(String stackTrace) {
            if ("".equalsIgnoreCase(stackTrace)) {
                return this;
            }
            Monitor[] monArr = this.monitors.getMonitors();
            StringBuilder sb = new StringBuilder();
            sb.append(monArr[0].getMonKey().getDetails()).append("\n").append(stackTrace);
            int i = 0;
            while (i < monArr.length) {
                Monitor mon = monArr[i];
                mon.getMonKey().setDetails(sb.toString());
                ++i;
            }
            return this;
        }

        private SQLDeArgMon stop() {
            this.monitors.stop();
            return this;
        }

        private SQLDeArgMon add(double time) {
            this.monitors.add(time);
            return this;
        }

        private synchronized int incrementCounter() {
            return this.accessCounter++;
        }

        private String getSQL() {
            return this.sql;
        }

        public String toString() {
            return "accessCounter=" + this.accessCounter + ", sql=" + this.sql;
        }
    }
}

