<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:html="http://www.w3c.org/TR/xhtml1/" 
xmlns:dyn="http://exslt.org/dynamic" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
xmlns:msg="uri:BMU_Waste_Interface/Message" 
xmlns:ags="uri:BMU_Waste_Interface/AGS" 
xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
xmlns:cat="uri:BMU_Waste_Interface/Kataloge" 
xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
xmlns:en="uri:BMU_Waste_Interface/EN" 
xmlns:ntz="uri:BMU_Waste_Interface/Ntz" 
xmlns:reg="uri:BMU_Waste_Interface/Reg" 
xmlns:zks="uri:BMU_Waste_Interface/ZKS" 
xmlns:tfs="http://xsd.infotech.de/schema/tfs" 
xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" 
xmlns:b64="xalan://de.itu.util.Base64" 
xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
xmlns:x509="xalan://de.itu.util.X509CertHelper" 
xmlns:str="http://exslt.org/strings"
xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
xmlns:makst="uri:MaklerStammdaten/MakStamm"
xmlns:befst="uri:BefoerdererStammdaten/BefStamm"
xmlns:entst="uri:EntsorgerStammdaten/EntStamm"
xmlns:erzst="uri:ErzeugerStammdaten/ErzStamm"
xmlns:btrlib="uri:BetriebStammdaten/BtrStammTypBibliothek"
xmlns:eslib="uri:EntsorgerStammdaten/EntStammTypBibliothek"
xmlns:ezlib="uri:ErzeugerStammdaten/ErzStammTypBibliothek"
xmlns:wmsg="Waste-WG-2018-Message" 
extension-element-prefixes="dyn b64 crc32 x509" 
exclude-result-prefixes="xsl dyn lib msg ags bgs cat ds en ntz reg zks b64 crc32 x509 xades">
	<xsl:template name="Kopf">
		<!-- Kopf-->
		<table bgcolor="#CCCCCC" width="100%" border="0" id="noprint">
			<tr width="100%">
				<td width="5%"/>
				<td width="95%" align="right">
					<font id="Titel">
						<xsl:choose>
							<xsl:when test="string-length(//@lib:Spezifikationsversion)>0">
								BMU-Version <xsl:value-of select="//@lib:Spezifikationsversion"/>
							</xsl:when>
							<xsl:otherwise>
								kein BMU-Dokument
							</xsl:otherwise>
						</xsl:choose>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td width="5%"/>
				<td width="95%" align="left">
					<form>
						<input type="button" height="20" width="60" value="Drucken" onClick="window.print()"/>
					</form>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="formatDouble">
		<xsl:param name="wert"/>
		<xsl:param name="unit"/>
		<xsl:if test="string-length($wert)>0">
			<xsl:choose>
				<xsl:when test="contains($wert,'.') and contains($wert,',')">
					<!-- punkt und komma mal schauen-->
					<xsl:variable name="W1">
						<xsl:value-of select="translate(substring-before($wert,'.'),',','.')"/>
					</xsl:variable>
					<xsl:variable name="W2">
						<xsl:value-of select="substring-after($wert,'.')"/>
					</xsl:variable>
					<xsl:value-of select="concat($W1,',',$W2)"/>
				</xsl:when>
				<xsl:when test="contains($wert,'.')">
					<!-- nur punkt-->
					<xsl:value-of select="translate($wert,'.',',')"/>
				</xsl:when>
				<xsl:when test="contains($wert,',')">
					<!-- nur komma-->
					<xsl:value-of select="translate($wert,',','.')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$wert"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length($unit)>0">
			<xsl:value-of select="concat(' ',$unit)"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="formatDate">
		<xsl:param name="date"/>
		<xsl:if test="string-length($date)&gt;9">
			<xsl:value-of select="substring($date,9,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,6,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,1,4)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatTime">
		<xsl:param name="date"/>
		<xsl:if test="string-length($date)&gt;9">
			<xsl:value-of select="substring($date,12,8)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="replace_backslash">
		<xsl:param name="text"/>
		<xsl:param name="from"/>
		<xsl:param name="to"/>
		<xsl:choose>
			<xsl:when test="contains($text, $from)">
				<xsl:variable name="before" select="substring-before($text, $from)"/>
				<xsl:variable name="after" select="substring-after($text, $from)"/>
				<xsl:variable name="prefix" select="concat($before, $to)"/>
				<xsl:value-of select="$before"/>
				<xsl:value-of select="$to"/>
				<xsl:call-template name="replace_backslash">
					<xsl:with-param name="text" select="$after"/>
					<xsl:with-param name="from" select="$from"/>
					<xsl:with-param name="to" select="$to"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="reverseTag">
		<xsl:param name="tag"/>
		<xsl:choose>
			<xsl:when test="contains($tag, '/')">
				<xsl:call-template name="reverseTag">
					<xsl:with-param name="tag" select="substring-after($tag, '/')"/>
				</xsl:call-template>
				<xsl:value-of select="concat('[parent::', substring-before($tag, '/'))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$tag"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="setSlash">
		<xsl:param name="tag"/>
		<xsl:choose>
			<xsl:when test="contains($tag, '/')">
				<xsl:call-template name="setSlash">
					<xsl:with-param name="tag" select="substring-after($tag, '/')"/>
				</xsl:call-template>
				<xsl:value-of select="']'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getDateValue">
		<xsl:param name="TagName"/>
		<xsl:choose>
			<xsl:when test="boolean(dyn:evaluate($TagName))">
				<font id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="dyn:evaluate($TagName)"/>
					</xsl:call-template>
				</font>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="TagReverse">
					<xsl:call-template name="reverseTag">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
					<xsl:call-template name="setSlash">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
				</xsl:variable>
				<!--xsl:message><xsl:value-of select="$TagReverse"/></xsl:message-->
				<font id="Text">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="dyn:evaluate(concat('descendant::', $TagReverse, '[last()]'))"/>
					</xsl:call-template>
				</font>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getTextValue">
		<xsl:param name="TagName"/>
		<xsl:param name="TagAttr"/>
		<xsl:param name="first" select="false()"/>
		<xsl:choose>
			<xsl:when test="string-length(dyn:evaluate($TagName)) > 0">
				<font id="Aktuell">
					<xsl:choose>
						<xsl:when test="string-length($TagAttr) > 0">
							<xsl:value-of select="dyn:evaluate(concat($TagName, '/', $TagAttr))"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="dyn:evaluate($TagName)"/>
						</xsl:otherwise>
					</xsl:choose>
				</font>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="TagReverse">
					<xsl:call-template name="reverseTag">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
					<xsl:call-template name="setSlash">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
				</xsl:variable>
				<!--xsl:message><xsl:value-of select="$TagReverse"/></xsl:message-->
				<font id="Text">
					<xsl:choose>
						<xsl:when test="$first">
							<xsl:value-of select="dyn:evaluate(concat('descendant::', $TagReverse, '[1]'))"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="string-length($TagAttr) > 0">
									<xsl:value-of select="dyn:evaluate(concat('descendant::', $TagReverse, '[last()]', '/', $TagAttr))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="dyn:evaluate(concat('descendant::', $TagReverse, '[last()]'))"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</font>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getBooleanValue">
		<xsl:param name="TagName"/>
		<xsl:param name="invers" select="false()"/>
		<xsl:choose>
			<xsl:when test="boolean(dyn:evaluate($TagName))">
				<xsl:choose>
					<xsl:when test="($invers and (dyn:evaluate($TagName)='false' or dyn:evaluate($TagName)='0')) or (not($invers) and (dyn:evaluate($TagName)='true' or dyn:evaluate($TagName)='1'))">
						<font id="Aktuell">
							<xsl:value-of select="'X'"/>
						</font>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="boolean(dyn:evaluate(concat('descendant::', $TagName)))">
				<xsl:variable name="TagReverse">
					<xsl:call-template name="reverseTag">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
					<xsl:call-template name="setSlash">
						<xsl:with-param name="tag" select="$TagName"/>
					</xsl:call-template>
				</xsl:variable>
				<!--xsl:message><xsl:value-of select="$TagReverse"/></xsl:message-->
				<xsl:variable name="tagDesc" select="concat('descendant::', $TagReverse, '[last()]')"/>
				<xsl:choose>
					<xsl:when test="($invers and (dyn:evaluate($tagDesc)='false' or dyn:evaluate($tagDesc)='0')) or (not($invers) and (dyn:evaluate($tagDesc)='true' or dyn:evaluate($tagDesc)='1'))">
						<font id="Aktuell">
							<xsl:value-of select="'X'"/>
						</font>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="getFieldWithLanguage">
		<xsl:param name="TheValue"/>
		<xsl:choose>
			<xsl:when test="string-length(@languageID)>0">
				<xsl:value-of select="concat($TheValue,' (', @languageID, ')')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$TheValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="NameUndAdresseBtr">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>
		<xsl:param name="withPostfach" select="true()"/>
		
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Name</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Name/',$prefixLib,'Name1'))"/>&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Name/',$prefixLib,'Name2'))"/>
				</td>
			</tr>
			<xsl:if test="string-length(dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Name/',$prefixLib,'Name3')))>0">
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Name/',$prefixLib,'Name3'))"/>&#173;
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Name/',$prefixLib,'Name4'))"/>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="80%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Straße</td>
				<td id="Titel_klein">Hausnummer</td>
			</tr>

			<tr>
				<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Strasse_1'))"/>&#173;
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Strasse_2'))"/>
				</td>
				<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Hausnummer'))"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="10%"/>
				<col width="10%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Staat</td>
				<td id="Titel_klein">PLZ</td>
				<td id="Titel_klein">Ort</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Staat'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Postleitzahl'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Ort_1'))"/>&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Adresse/',$prefixLib,'Ort_2'))"/>
				</td>
			</tr>
		</table>			
		
		<xsl:if test="$withPostfach">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Postfach</td>
					<td id="Titel_klein">PLZ (Pf)</td>
					<td id="Titel_klein">Ort (Pf)</td>
				</tr>
	
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Postfachadresse/',$prefixLib,'Postfach'))"/>
					</td>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Postfachadresse/',$prefixLib,'Postleitzahl'))"/>
					</td>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Postfachadresse/',$prefixLib,'Ort_1'))"/>&#173;
						<xsl:value-of select="dyn:evaluate(concat($prefix,'NameUndAdresse/',$prefixLib,'Postfachadresse/',$prefixLib,'Ort_2'))"/>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="ZustBehoerdeBtr">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>

		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="30%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Behördennummer</td>
				<td id="Titel_klein">Rolle</td>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'LfdNr'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'BehoerdlicheNr'))"/>
					&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'Pruefziffer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Rolle'))"/>
				</td>

				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Aktenzeichen'))"/>
				</td>
			</tr>
			<!--tr>
				<td id="Titel_klein">Behördennummer</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'BehoerdlicheNr'))"/>
					&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'Pruefziffer'))"/>
				</td>
				<td>
				</td>
				<td id="Aktuell">
				</td>
			</tr-->
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="$prefix"/>
			<xsl:with-param name="prefixLib" select="$prefixLib"/>
			<xsl:with-param name="withPostfach" select="false()"/>
		</xsl:call-template>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Vorname zuständige Person</td>
				<td id="Titel_klein">Nachname zuständige Person</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Vorname'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Nachname'))"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="BrancheBtr">
		<xsl:param name="prefix" select="'makst:'"/>

		<xsl:call-template name="TableOneDashLine"/>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">NACE Code</td>
				<td id="Titel_klein">Hauptbranche</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Branche'))"/>
					&#173;
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Hauptbranche')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>
	</xsl:template>
		
	<xsl:template name="KontaktBtr">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Ansprechpartner')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="Titel_klein">Ansprechpartner</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'Ansprechpartner'))"/>
						&#173;
					</td>
				</tr>
			</table>
		</xsl:if>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="34%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Telefon</td>
				<td id="Titel_klein">Fax</td>
				<td id="Titel_klein">Mobiltelefon</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Telefon'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Telefax'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Mobiltelefon'))"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">E-Mail</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'EMail'))"/>
					&#173;
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="TableOneDashLine">
		<table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td height="1px">
					<table id="Tabelle_oben_dashed" width="100%">
						<tr>
							<td height="1px">
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="PersonBtr">
		<xsl:param name="prefix" select="'makst'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>
		<xsl:param name="betriebsinhaber" select="false()"/>
		<xsl:param name="verantwortPerson" select="false()"/>
		<xsl:param name="fachkunde" select="false()"/>
		<xsl:param name="ba" select="false()"/>
		
		<xsl:call-template name="TableOneDashLine"/>

		<!--table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Rolle</td>
				<td id="Titel_klein">Zuständig für</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Rolle'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Zustaendigkeit'))"/>
				</td>
			</tr>
		</table-->
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="30%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Anrede</td>
				<td id="Titel_klein">Titel</td>
				<td id="Titel_klein">Rolle</td>
				<td id="Titel_klein">Zuständig für</td>
			</tr>

			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Anrede'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Titel'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Rolle'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Zustaendigkeit'))"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Vorname</td>
				<td id="Titel_klein">Nachname</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Vorname'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefixLib,'Nachname'))"/>
				</td>
			</tr>
		</table>			

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="concat($prefixLib,'Kontaktdaten/',$prefixLib)"/>
		</xsl:call-template>
		
		<xsl:if test="$betriebsinhaber">
			<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="75%"/>
			</colgroup>
				<tr>
					<td id="Titel_klein">Betriebsinhaber</td>
					<td>
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:call-template name="getBooleanValue">
										<xsl:with-param name="TagName" select="concat($prefix,'Betriebsinhaber')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="$verantwortPerson">
			<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="75%"/>
			</colgroup>
				<tr>
					<td id="Titel_klein">Verantwortliche Person</td>
					<td>
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:call-template name="getBooleanValue">
										<xsl:with-param name="TagName" select="concat($prefix,'VerantwortlichePerson')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="$ba">
			<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="75%"/>
			</colgroup>
				<tr>
					<td id="Titel_klein">Betriebsbeauftragter für Abfall</td>
					<td>
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:call-template name="getBooleanValue">
										<xsl:with-param name="TagName" select="concat($prefix,'BetriebsbeauftragterAbfall')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="$fachkunde">
			<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="15%"/>
				<col width="10%"/>
				<col width="50%"/>
			</colgroup>
				<tr>
					<td id="Titel_klein">Fachkundelehrgang gültig von:</td>
					<td>
						<xsl:call-template name="getDateValue">
							<xsl:with-param name="TagName" select="concat($prefix,'FachkundeGueltigVon')"/>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">bis:</td>
					<td>
						<xsl:call-template name="getDateValue">
							<xsl:with-param name="TagName" select="concat($prefix,'FachkundeGueltigBis')"/>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Fkb">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Nummer">Zugehörige(r) Firma, Körperschaft, Betreiber</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Verwaltungsinformationen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Gestrichen</td>
				<td id="Titel_klein">Streichgrund</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gestrichen')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Streichgrund'))"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<font id="Titel_klein">Notizen</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'Bemerkungen'))"/>
						&#173;
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Hauptsitz</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="10%"/>
				<col width="25%"/>
				<col width="25%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Firmenschlüssel</td>
				<td id="Titel_klein">Privatperson</td>
				<td id="Titel_klein">Registriernummer im Heimatland</td>
				<td id="Titel_klein">Umsatzsteueridentifikationsnummer</td>
				<td id="Titel_klein">Betriebsstammnummer</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:choose>
						<xsl:when test="$prefix='entst:'">
							<xsl:value-of select="dyn:evaluate(concat($prefix, 'Firmenschluessel'))"/>
							&#173;
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'BehoerdlicheNr'))"/>
							&#173;
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Privatperson')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registriernummer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'UmsatzsteuerID'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Betriebsstammnummer/',$prefixLib,'BehoerdlicheNr'))"/>
					&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Betriebsstammnummer/',$prefixLib,'Pruefziffer'))"/>
				</td>
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="$prefix"/>
			<xsl:with-param name="prefixLib" select="$prefixLib"/>
		</xsl:call-template>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gemeindeschluessel'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gemeindename'))"/>
				</td>
			</tr>
		</table>

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="concat($prefix,'Kontaktdaten/',$prefixLib)"/>
		</xsl:call-template>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'InternetAdresse'))"/>
					&#173;
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Gewerbeanmeldung</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Befreit</td>
				<td id="Titel_klein">Anmeldung erfolgt</td>
				<td id="Titel_klein">Datum</td>
				<td id="Titel_klein">Behörde</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'Befreit')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'AnmeldungIstErfolgt')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'DatumAnmeldung')"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gewerbeanmeldung/',$prefix,'Behoerde'))"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gewerbeanmeldung/',$prefix,'Aktenzeichen'))"/>
					&#173;
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Handels-, Genossenschafts- oder Vereinsregister</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Eintrag vorhanden</td>
				<td id="Titel_klein">Datum</td>
				<td id="Titel_klein">Registernummer</td>
				<td id="Titel_klein">Registergericht</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Registereintrag/',$prefix,'RegistrierungsIstErfolgt')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Registereintrag/',$prefix,'DatumRegistrierung')"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registereintrag/',$prefix,'Registernummer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registereintrag/',$prefix,'Registergericht'))"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Fkb_short">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Hauptsitz</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
				<!--col width="25%"/>
				<col width="25%"/>
				<col width="20%"/-->
			</colgroup>
			<tr>
				<td id="Titel_klein">Firmenschlüssel</td>
				<td id="Titel_klein">Privatperson</td>
				<!--td id="Titel_klein">Registriernummer im Heimatland</td>
				<td id="Titel_klein">Umsatzsteueridentifikationsnummer</td>
				<td id="Titel_klein">Betriebsstammnummer</td-->
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:choose>
						<xsl:when test="$prefix='entst:'">
							<xsl:value-of select="dyn:evaluate(concat($prefix, 'Firmenschluessel'))"/>
							&#173;
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="dyn:evaluate(concat($prefix, 'BehoerdlicheNummer/',$prefixLib,'BehoerdlicheNr'))"/>
							&#173;
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Privatperson')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<!--td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registriernummer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'UmsatzsteuerID'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Betriebsstammnummer/',$prefixLib,'BehoerdlicheNr'))"/>
					&#173;
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Betriebsstammnummer/',$prefixLib,'Pruefziffer'))"/>
				</td-->
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="$prefix"/>
			<xsl:with-param name="prefixLib" select="$prefixLib"/>
			<xsl:with-param name="withPostfach" select="false()"/>
		</xsl:call-template>
		
		<!--table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gemeindeschluessel'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gemeindename'))"/>
				</td>
			</tr>
		</table-->

		<!--xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="concat($prefix,'Kontaktdaten/',$prefixLib)"/>
		</xsl:call-template-->

		<!--table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'InternetAdresse'))"/>
					&#173;
				</td>
			</tr>
		</table-->
		<!--table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Gewerbeanmeldung</font>
				</td>
			</tr>
		</table-->
		<!--table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Befreit</td>
				<td id="Titel_klein">Anmeldung erfolgt</td>
				<td id="Titel_klein">Datum</td>
				<td id="Titel_klein">Behörde</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'Befreit')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'AnmeldungIstErfolgt')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Gewerbeanmeldung/',$prefix,'DatumAnmeldung')"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gewerbeanmeldung/',$prefix,'Behoerde'))"/>
				</td>
			</tr>
		</table-->
		<!--table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Gewerbeanmeldung/',$prefix,'Aktenzeichen'))"/>
					&#173;
				</td>
			</tr>
		</table-->
		<!--table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Handels-, Genossenschafts- oder Vereinsregister</font>
				</td>
			</tr>
		</table-->
		<!--table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Eintrag vorhanden</td>
				<td id="Titel_klein">Datum</td>
				<td id="Titel_klein">Registernummer</td>
				<td id="Titel_klein">Registergericht</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Registereintrag/',$prefix,'RegistrierungsIstErfolgt')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="concat($prefix,'Registereintrag/',$prefix,'DatumRegistrierung')"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registereintrag/',$prefix,'Registernummer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Registereintrag/',$prefix,'Registergericht'))"/>
				</td>
			</tr>
		</table-->
	</xsl:template>

	<xsl:template name="WeitereAdresse">
		<xsl:param name="prefix" select="'makst:'"/>
		<xsl:param name="prefixLib" select="'btrlib:'"/>
		
		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Rolle</td>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Rolle'))"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Aktenzeichen'))"/>
				</td>
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="$prefix"/>
			<xsl:with-param name="prefixLib" select="$prefixLib"/>
		</xsl:call-template>

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="concat($prefix,'Kontakt/',$prefix)"/>
		</xsl:call-template>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'InternetAdresse'))"/>
					&#173;
				</td>
			</tr>
		</table>
		
	</xsl:template>

	<xsl:template name="Detailangabe">
		<xsl:param name="prefix" select="'makst:'"/>

		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Bereich</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'LfdNr'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Bereich'))"/>
				</td>
			</tr>
		</table>
		
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Angabe</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix,'Detailangabe'))"/>
					&#173;
				</td>
			</tr>
		</table>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Text')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="Titel_klein">Text</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'Text'))"/>
						&#173;
						<xsl:value-of select="dyn:evaluate(concat($prefix,'Text2'))"/>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Kennzeichen')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Kennzeichnung</td>
					<td>
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:call-template name="getBooleanValue">
										<xsl:with-param name="TagName" select="concat($prefix,'Kennzeichen')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Fliesskommazahl')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="70%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Wert 1:</td>
					<td id="Aktuell">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="dyn:evaluate(concat($prefix,'Fliesskommazahl'))"></xsl:with-param>
						</xsl:call-template>
						<!--xsl:value-of select="dyn:evaluate(concat($prefix,'Fliesskommazahl'))"/-->
					</td>
					<td id="Titel_klein">Wert 2:</td>
					<td id="Aktuell">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="dyn:evaluate(concat($prefix,'Fliesskommazahl2'))"></xsl:with-param>
						</xsl:call-template>
						<!--xsl:value-of select="dyn:evaluate(concat($prefix,'Fliesskommazahl2'))"/-->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Datum')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="70%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Datum 1:</td>
					<td id="Aktuell">
						<xsl:call-template name="getDateValue">
							<xsl:with-param name="TagName" select="concat($prefix,'Datum')"/>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">Datum 2:</td>
					<td id="Aktuell">
						<xsl:call-template name="getDateValue">
							<xsl:with-param name="TagName" select="concat($prefix,'Datum2')"/>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="string-length(dyn:evaluate(concat($prefix,'Notizen')))>0">
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="Titel_klein">Text</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="dyn:evaluate(concat($prefix,'Notizen'))"/>
					</td>
				</tr>
			</table>
		</xsl:if>
		
	</xsl:template>

	<xsl:template name="BImSchV">
		<xsl:param name="prefix" select="'makst:'"/>

		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Bestimmender Schlüssel</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'LfdNr'))"/>
				</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="concat($prefix,'IndicatorBestimmend')"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Ziffer</td>
				<td id="Titel_klein">Verfahrensart</td>
				<td id="Titel_klein">unterliegt der IED-Richtlinie</td>
				<td id="Titel_klein">Spalte</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Ziffer'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Verfahrensart'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'IED-RL'))"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="dyn:evaluate(concat($prefix, 'Spalte'))"/>
				</td>
			</tr>
		</table>		
	</xsl:template>

	<xsl:template name="DUMMY_ZEICHEN">
		<td>
			<font id="Aktuell_nu">&#173;</font>
		</td>
	</xsl:template>

	<xsl:template name="SUBSTRING_VAL">
		<xsl:param name="VAL"/>
		<xsl:param name="MAX_ZEICHEN"/>
		<xsl:choose>
			<xsl:when test="string-length($VAL)>$MAX_ZEICHEN">
				<xsl:value-of select="substring($VAL,1,$MAX_ZEICHEN)"/>...
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$VAL"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
			
	<xsl:template name="Style">
		<style type="text/css" media="screen">
					a:link { color:#000099; } 
					a:visited { color:000099; } 
					a:active { color:000099; } 
					
					body { text-align:left;
					font-family:Arial,sans-serif; font-size: 12px;
					font-weight: normal; text-decoration: none;
					background-color :#FFFFFF; color: #222222;}

					#Titel {
					font-family:Arial,sans-serif; font-size:17px;
					font-weight:bold; }

					#Titel_klein {
					font-family:Arial,sans-serif; font-size:15px;
					}

					#Titel_winzig {
					font-family:Arial,sans-serif; font-size:13px;
					}

					#Titel_gross {

					font-family:Arial,sans-serif; font-size:19px;
					font-weight:bold; color:black; }


					#Text_normal {

					font-family:Arial,sans-serif; font-size:16px;
					color:black; }

					#Text_kleiner {

					font-family:Arial,sans-serif; font-size:13px;
					color:#999989;}



					#Text {

					font-family:Calibri; font-size:16px;
					color:#0000FF;

					} #Text_klein {

					font-family: Calibri; font-size:14px;
					color:#0000FF;

					} #Ueberschrift { font-family:Arial,sans-serif;
					font-size:22px; font-weight:bold; color:black;}

					#Ueberschrift_Storno { font-family:Arial,sans-serif;
					font-size:22px; font-weight:bold; color:black; background-color :yellow;}
					
					#Nummer { font-family:Arial,sans-serif;
					font-size:24px; color:black; font-weight:bold; 

					} #Nummer2 { font-family:Arial,sans-serif;
					font-size:20px; color:black;

					}

					#Tabelle { text-align:left; border-width:1px;
					border-style:solid; border-color:black; }

					#Tabelle-Haupt { border-width:3px;
					border-style:solid; border-color:#CCCCCC; }

					#Ueberschrift2 { font-family:Arial,sans-serif;
					font-size:17px; font-weight:bold; color:black; }

					#Ueberschrift3{ font-family:Arial,sans-serif;
					font-size:22px; color:black; margin: 0.5cm 0cm
					0.5cm 0cm;}

					#FormPosition{ font-family:Arial,sans-serif;
					font-size:18px; color:#0000FF; margin: 0.5cm 0cm
					0.5cm 0cm;}

					#Aktuell { font-family: Calibri;
					font-size:18px; color:#0000FF;}

					#Aktuell_notu { font-family: Times New Roman;
					font-size:18px; color:#0000FF;}

					#Aktuell_gross { font-family: Calibri;
					font-size:22px; color:#0000FF;}

					#Aktuell_nu { font-family: Arial,sans-serif;
					font-size:15px; color:#0000FF;}

					#Aktuell_indikator { font-family: Arial,sans-serif;
					font-size:18px; color:#0000FF;}

					#Text_nu {
					font-family:Arial,sans-serif; font-size:13px;
					color:#8888FF;}

					#Aktuell_nu_gestrichen {font-family: Arial,sans-serif;
					font-size:13px; color:#0000FF;text-decoration: line-through;}

					#Aktuell_klein { font-family: Calibri;
					font-size:16px; color:#0000FF; }

					#Tabelle_links { border-left-width:1px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_rechts { border-left-width:0px;
					border-right-width:1px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_oben { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:1px; border-style:solid;
					border-color:black; }

					#Tabelle_unten { border-left-width:0px;
					border-right-width:0px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_unten_links { border-left-width:1px;
					border-right-width:0px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_unten_rechts { border-left-width:0px;
					border-right-width:1px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_nicht_unten { text-align:left;
					border-left-width:1px; border-right-width:1px;
					border-bottom-width:0px; border-top-width:1px;
					border-style:solid; border-color:black;}

					#Tabelle_nicht_oben { border-left-width:1px;
					border-right-width:1px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_ohne { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_ohne_1px { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:1px; border-style:solid;
					border-color:white; }

					#Tabelle_nicht_oben_unten { border-left-width:1px;
					border-right-width:1px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black;}

					#Tabelle_oben_dashed { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:1px; border-style:dashed;
					border-color:black; }

					#Tabelle_indikator { border-width:1px;
					border-style:solid; border-color:black; height:25;
					width:20; }

		</style>
		<style type="text/css" media="print">
			a:link { color:#000099; } 
			a:visited { color:000099; } 
			a:active { color:000099; } 
			
			body { font-family:Arial,sans-serif; font-size: 10pt;
			margin-top: 0.5em; margin-right:0.5em; margin-left: 0.5em;
			margin-bottom: 0.5em;

			}
			#Titel {

			font-family:Arial,sans-serif; font-size:8pt;
			font-weight:bold;
			color:black; }

			#Titel_klein {

			font-family:Arial,sans-serif; font-size:7pt;

			color:black; }

			#Titel_winzig {

			font-family:Arial,sans-serif; font-size:6pt;

			color:black; }

			#Titel_gross {

			font-family:Arial,sans-serif; font-size:11pt;
			font-weight:bold; color:black; }

			#Text {

			font-family: Times New Roman; font-size:9pt; color:black;
			font-style:italic; }


			#Text_normal {

			font-family:Arial,sans-serif; font-size:10pt; color:black; }

			#Text_kleiner {

			font-family:Arial,sans-serif; font-size:8pt; color:black; }

			#Text_klein {

			font-family: Times New Roman; font-size:10pt; color:black;
			font-style:italic; }

			#Ueberschrift { font-family:Arial,sans-serif;
			font-size:12pt; font-weight:bold; color:black; }

			#Ueberschrift_Storno { font-family:Arial,sans-serif;
			font-size:12pt; font-weight:bold; color:black; }

			#Nummer { font-family:Arial,sans-serif; font-size:12pt;
			font-weight:bold; }

			#Nummer2 { font-family:Arial,sans-serif; font-size:10pt;
			color:black;

			}

			#Tabelle { border-width:1px; border-style:solid;
			border-color:black; }

			#Ueberschrift2 { font-family:Arial,sans-serif;
			font-size:9pt; color:black; }

			#Aktuell { font-family: Times New Roman; font-size:9pt;
			color:#0000FF; }

			#Aktuell_gross { font-family: Times New Roman;
			font-size:12pt; color:#0000FF;}

			#Aktuell_notu { font-family: Times New Roman;
			font-size:9pt; color:#0000FF;}

			#Aktuell_nu { font-family: Times New Roman;
			font-size:8pt; color:#0000FF;}

			#Aktuell_nu_indikator { font-family: Arial,sans-serif;
			font-size:6pt; color:#0000FF;}

			#Aktuell_nu_gestrichen {font-family: Times New Roman;
			font-size:8pt; color:#0000FF; text-decoration: line-through;}

			#Aktuell_klein { font-family: Times New Roman;
			font-size:8pt; color:#0000FF; }

			#noprint{ display:none }

			#Ueberschrift3{ font-family:Arial,sans-serif; font-size:9pt;
			color:black; margin: 0.2cm 0cm 0cm 0cm; }

			#Tabelle-Haupt { border-width:0px; }


			#Tabelle_links { border-left-width:1px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_rechts { border-left-width:0px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_oben { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:black; }

			#Tabelle_unten { border-left-width:0px;
			border-right-width:0px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_unten_links { border-left-width:1px;
			border-right-width:0px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_nicht_unten { border-left-width:1px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:black; }

			#Tabelle_nicht_oben { border-left-width:1px;
			border-right-width:1px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_nicht_oben_unten { border-left-width:1px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_ohne { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_ohne_1px { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:white; }

			#Tabelle_oben_dashed { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:1px; border-style:dashed;
			border-color:black; }

			#Tabelle_indikator { border-width:1px; border-style:solid;
			border-color:black; height:22; width:17; }


		</style>
	</xsl:template>
</xsl:stylesheet>
