<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib en ds b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="AE"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="AE">
		<!--xsl:for-each select="//*[@lib:LayerID=$layerID]"-->
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<div id="Nummer" align="right">Annahmeerkl&#228;rung</div>
							<table id="tabelle_nicht_unten" width="100%">
								<xsl:call-template name="ESNKopfNummern"/>
								<tr>
									<td>
										<font id="Nummer">
									Annahmeerkl&#228;rung
								</font>
										<font id="Ueberschrift2">
									(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
								</font>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="Ueberschrift2">Nur bei Verwendung als Registerblatt </td>
														</tr>
														<tr>
															<td id="titel">Nach Abfallverzeichnis-Verordnung (AVV)   </td>
														</tr>
														<tr>
															<td id="titel">Abfallschl&#252;ssel </td>
														</tr>
														<tr>
															<td height="8">
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfall/en:Abfallschluessel'"/>
																</xsl:call-template>
															</td>
														</tr>
														<tr>
															<td id="titel">Abfallbezeichnung </td>
														</tr>
														<tr>
															<td height="8">
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfall/en:Abfallbezeichnung'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">1</td>
												<td id="Ueberschrift2" width="98%">
	                                                     Angaben zum Abfallentsorger                                                    
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Firma</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.1</td>
												<td width="98%">
													<!-- Firma 1-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
													<!-- Firma 2-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													<!-- Firma 3-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													<!-- Firma 4-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!--  Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																&#173;
																<!--  Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
															</td>
															<td valign="top" width="10%">
																<!-- Hausnummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.3</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!--  Postleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!--  Ort1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>
																&#173;
																<!--  Ort2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2">   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">2</td>
												<td id="Ueberschrift2" width="98%">
                                                      Entsorgungsanlage                                              
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.1</td>
												<td width="98%">
													<table>
														<tr>
															<td width="2"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorCPB'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Chemisch-/ physikalische Behandlung</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorTherm'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Thermische Behandlung</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorODep'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">oberirdische Deponie</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorUDep'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Untertagedeponie</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorSonst'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">sonstige Entsorgungsverfahren</td>
															<td width="25"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.2</td>
												<td width="98%">
													<table>
														<tr>
															<td>
																<font id="titel">Entsorgungsverfahren (Verfahrensangabe nach Anlage 1 oder Anlage 2 des KrWG)</font>
															</td>
															<td width="3"/>
															<td>
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:RDVerfahren'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="60%">Bezeichnung der Entsorgungsanlage bzw. Betriebsstätte</td>
																	<td id="titel" width="20%">Arbeitsstättennummer</td>
																	<td id="titel" width="20%">Entsorgernummer</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.3</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="60%">
																		<!-- Bezeichnung 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Bezeichnung/en:Bezeichnung1'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Bezeichnung 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Bezeichnung/en:Bezeichnung2'"/>
																		</xsl:call-template>
																		<br></br>
																		<!-- Name 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name1'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Name 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name2'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Name 3-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name3'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Name 4-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name4'"/>
																		</xsl:call-template>
																	</td>
																	<td width="20%">
																		<!-- Arbeitsstättennummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Arbeitsstaettennummer'"/>
																		</xsl:call-template>
																	</td>
																	<td width="20%">
																		<!-- Entsorgernummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Entsorgernummer/lib:BehoerdlicheNr'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Prüfziffer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Entsorgernummer/lib:Pruefziffer'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="80%">Straße oder Koordinaten</td>
																	<td id="titel" width="20%">Hausnummer</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.4</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="80%">
																		<!-- Entsorger- Strasse 1-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Postfach'"/>
																		</xsl:call-template>
																		&#173;
																		<!--  Strasse 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																		</xsl:call-template>
																		&#160;
																		<xsl:if test="count(en:AE/en:Entsorgungsanlage/en:Koordinaten) > 0 or count(descendant::en:AE/en:Entsorgungsanlage/en:Koordinaten) > 0">
																			<font id="titel">Koordinaten: </font>
																		</xsl:if>
																		&#160;
																		<!-- Koordinaten Hochwert-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Koordinaten/lib:Hochwert'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Koordinaten Rechtswert-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Koordinaten/lib:Rechtswert'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Koordinaten NummerTopoKarte-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Koordinaten/lib:NummerTopoKarte'"/>
																		</xsl:call-template>
																	</td>
																	<td width="20%">
																		<!-- Entsorger - Hausnummer -->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="30%">Postleitzahl</td>
																	<td id="titel" width="70%">Ort</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.5</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="30%">
																		<!-- Entsorger Postleitzahl -->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Postleitzahl'"/>
																		</xsl:call-template>
																	</td>
																	<td width="70%">
																		<!-- Entsorger Ort1-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Ort_1'"/>
																		</xsl:call-template>
																&#173;
																<!-- Entsorger Ort2-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Ort_2'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td id="titel" width="98%">Ansprechpartner</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.6</td>
														<td width="98%">
															<!-- Entsorger Ansprechpartner - Name-->
															<xsl:call-template name="getTextValue">
																<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Ansprechpartner/lib:Name'"/>
															</xsl:call-template>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="30%">Telefon</td>
																	<td id="titel" width="70%">Telefax</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.7</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="30%">
																		<!-- Entsorger Ansprechpartner - Telefon-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Ansprechpartner/lib:Telefon'"/>
																		</xsl:call-template>
																	</td>
																	<td width="70%">
																		<!-- Entsorger Ansprechpartner - Telefax-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Ansprechpartner/lib:Telefax'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td id="titel" width="98%">E-Mail-Adresse</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.8</td>
														<td width="98%">
															<!-- Entsorger Ansprechpartner - E-Mail-->
															<xsl:call-template name="getTextValue">
																<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Ansprechpartner/lib:EMail'"/>
															</xsl:call-template>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.9</td>
														<td width="98%">
															<table>
																<tr>
																	<td  id="titel">Die Anlage ist gem&#228;ß § 7 NachwV freigestellt:</td>
																	<td width="15"/>
																	<td>
																		<table id="Tabelle_indikator">
																			<tr>
																				<td>
																					<xsl:call-template name="getBooleanValue">
																						<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Freistellung/en:IndicatorFreistellung'"/>
																					</xsl:call-template>
																				</td>
																			</tr>
																		</table>
																	</td>
																	<td id="titel">Ja</td>
																	<td width="15"/>
																	<td>
																		<table id="Tabelle_indikator">
																			<tr>
																				<td>
																					<xsl:call-template name="getBooleanValue">
																						<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Freistellung/en:IndicatorFreistellung'"/>
																						<xsl:with-param name="invers" select="true()"/>
																					</xsl:call-template>
																				</td>
																			</tr>
																		</table>
																	</td>
																	<td id="titel">Nein</td>
																	<td width="15"/>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5"/>
														<td width="98%">
															<table>
																<tr>
																	<!--td width="5"/-->
																	<td id="titel">Freistellungsnummer:</td>
																	<td width="5"/>
																	<td>
																		<!-- Freistellungsnummer -->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Freistellung/en:Freistellungsnummer/lib:FreistellungsNr'"/>
																		</xsl:call-template>
																		&#173;
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Freistellung/en:Freistellungsnummer/lib:Pruefziffer'"/>
																		</xsl:call-template>
																	</td>
																	<td width="15"/>
																</tr>
															</table>
														</td>
													</tr>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2">    </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">3</td>
												<td id="Ueberschrift2" width="98%">Laufzeit der Annahmeerklärung</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="4%"/>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="4%"/>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="62%"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">3.1</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="4%">von</td>
															<td width="15%">
																<!--  Datum von -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:LaufzeitAE/en:DatumVon'"/>
																</xsl:call-template>
															</td>
															<td id="titel" width="4%">bis</td>
															<td width="15%">
																<!--  Datum bis -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:LaufzeitAE/en:DatumBis'"/>
																</xsl:call-template>
															</td>
															<td width="62%"/>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" valign="top" width="5">4</td>
												<td id="Text_normal" width="98%">
													<!-- Versicherung -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Erklaerung/en:Versicherung'"/>
													</xsl:call-template>
													<br/>
													<font id="titel">Zusatz: </font>
													<!-- Zusatz -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:AE/en:Erklaerung/en:Zusatz'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr height="3">
												<th/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="25%">Ort</td>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="25%">Name</td>
															<td id="titel" width="35%">Rechtsverbindliche Unterschrift (Signatur)</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="25%">
																<!-- Ort Unterschrift  -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Erklaerung/lib:Ort'"/>
																</xsl:call-template>
															</td>
															<td width="15%">
																<!--  Datum -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Erklaerung/lib:Datum'"/>
																</xsl:call-template>
															</td>
															<td width="25%">
																<!--  Name -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Erklaerung/lib:Name'"/>
																</xsl:call-template>
															</td>
															<!--  Unterschrift auf der AE -->
															<td width="35%">
																<xsl:variable name="AE_LAYER_ID">
																	<xsl:choose>
																		<xsl:when test="(local-name()='ENSNENTLayer' or (local-name()='ENSNErgaenzungsLayer' and @lib:ATBRolle='ENT')) and (count(ds:Signature)>0)">
																			<xsl:value-of select="@lib:LayerID"/>
																		</xsl:when>
																		<xsl:when test="count(descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle='ENT']/ds:Signature) > 0">
																			<xsl:value-of select="descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle='ENT']/ds:Signature/../@lib:LayerID"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="descendant::en:ENSNENTLayer/@lib:LayerID"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>AE_LAYER_ID: <xsl:value-of select="$AE_LAYER_ID"/></xsl:message-->
																<xsl:variable name="SIG_AKTUELL">
																	<xsl:choose>
																		<xsl:when test="(local-name()='ENSNENTLayer' or (local-name()='ENSNErgaenzungsLayer' and @lib:ATBRolle='ENT')) and (count(ds:Signature)>0)">
																				<xsl:value-of select="true()"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="false()"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>SIG_AKTUELL: <xsl:value-of select="$SIG_AKTUELL"/></xsl:message-->
																<xsl:choose>
																	<xsl:when test="$SIG_AKTUELL='true'">
																		<xsl:choose>
																			<xsl:when test="count(ds:Signature) > 0">
																				<font id="Aktuell">
																					<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																					<xsl:variable name="SIG_DATE">
																						<xsl:call-template name="formatDate">
																							<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																						</xsl:call-template>
																					</xsl:variable>
														 							<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
																					<!--xsl:message>Font: <xsl:value-of select="Aktuell"/></xsl:message-->
																				</font>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:if test="count(descendant::*[@lib:LayerID=$AE_LAYER_ID]/ds:Signature) > 0">
																			<font id="Text">
																				<xsl:value-of select="x509:extractCommonName(b64:decode(descendant::*[@lib:LayerID=$AE_LAYER_ID]/ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																				<xsl:variable name="SIG_DATE2">
																					<xsl:call-template name="formatDate">
																						<xsl:with-param name="date" select="descendant::*[@lib:LayerID=$AE_LAYER_ID]/ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																					</xsl:call-template>
																				</xsl:variable>
													 							<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
																				<!--xsl:message>Font: <xsl:value-of select="'Text'"/></xsl:message-->
																			</font>
																		</xsl:if>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
