<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:html="http://www.w3c.org/TR/xhtml1/" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
xmlns:msg="uri:BMU_Waste_Interface/Message" 
xmlns:ntz="uri:BMU_Waste_Interface/Ntz" 
xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
xmlns:b64="xalan://de.itu.util.Base64" 
xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
xmlns:x509="xalan://de.itu.util.X509CertHelper" 
xmlns:util="xalan://de.condat.mbs.tools.TransformUtils"
xmlns:itu="xalan://de.itu.util.ISO_3166"
xmlns:tfs="http://xsd.infotech.de/schema/tfs" 
xmlns:wmsg="Waste-WG-2018-Message" 
xmlns:wx="Guidlines11xtra" 
extension-element-prefixes="b64 crc32 x509 tfs util" 
exclude-result-prefixes="xsl lib msg ds b64 crc32 x509 tfs wmsg util">
	<xsl:import href="ZKS-Library_11.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:variable name="LEERZEICHEN" select="' '"> </xsl:variable>
	<xsl:template match="/">
		<xsl:for-each select="//wmsg:WasteMovementDocument">
			<xsl:if test="position()=$positionsnummer">
				<xsl:call-template name="WasteMovementDocument"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="WasteMovementDocument">
		<html>
			<head>
				<title>Begleitformular</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile1_2"/>
							<xsl:call-template name="Zeile3_4"/>
							<xsl:call-template name="Zeile5_6"/>
							<xsl:call-template name="Zeile7"/>
							<xsl:call-template name="Zeile8"/>
							<xsl:call-template name="Zeile9_14"/>
							<xsl:call-template name="Zeile15"/>
							<xsl:call-template name="Zeile16"/>
							<xsl:call-template name="Zeile17"/>
							<xsl:call-template name="Zeile17a"/>
							<xsl:call-template name="Zeile18_19"/>
						</th>
					</tr>
				</table>
				<p style="page-break-after:always">
					<br style="height:0; line-height:0"/>
				</p>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile19a"/>
							<xsl:call-template name="Zeile20_21"/>
							<xsl:call-template name="Zeile22"/>
							<xsl:call-template name="Zeile22a"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="Zeile1_2">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Ueberschrift2">Begleitformular für grenzüberschreitende Verbringungen von Abfällen</td>
			</tr>
			<xsl:if test="//wx:NTZxtra/wx:Canceled='true'">
				<tr>
					<td>
						<font id="Ueberschrift_Storno">
							<xsl:value-of select="'Der Transport wurde storniert.'"/>
						</font>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" id="Tabelle_rechts">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td id="Titel">1. Entspricht der Notifizierung Nr.</td>
							<td id="Aktuell_gross">
								<xsl:value-of select="wmsg:NotificationID"/>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="80%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel">2. Fortlaufende Nummer / Gesamtzahl der Verbringungen:</td>
							<td>
								<font id="Aktuell_gross">
									<xsl:value-of select="wmsg:SequenceNumber"/>
								</font>
								<xsl:value-of select="$LEERZEICHEN"/>
								<font id="Titel">/</font>
								<xsl:value-of select="$LEERZEICHEN"/>
								<font id="Aktuell_gross">
									<xsl:value-of select="wmsg:ShipmentQuantity"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3_4">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%" valign="top"/>
				<col width="50%" valign="top"/>
			</colgroup>
			<tr>
				<td>
					<xsl:call-template name="Zeile3"/>
				</td>
				<td>
					<xsl:call-template name="Zeile4"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3">
		<table width="100%" id="Tabelle_rechts">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:Notifier)>0">
							<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Notifier">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile4">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:Consignee)>0">
							<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Consignee">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5_6">
		<xsl:for-each select="wmsg:TransportAnnouncement">
			<table width="100%" id="Tabelle_nicht_unten">
				<colgroup>
					<col width="50%" valign="top"/>
					<col width="50%" valign="top"/>
				</colgroup>
				<tr>
					<td>
						<table width="100%" id="Tabelle_rechts">
							<colgroup>
								<col width="40%"/>
								<col width="15%"/>
								<col width="15%"/>
								<col width="15%"/>
								<col width="15%"/>
							</colgroup>
							<tr>
								<td id="Titel">5. Tatsächliche Menge:</td>
								<td id="Titel_klein">Tonnen (Mg):</td>
								<td id="Aktuell_nu">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:ActualQuantity/wmsg:MassMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:ActualQuantity/wmsg:MassMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
								<td id="Titel_klein">m³</td>
								<td id="Aktuell_nu">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:ActualQuantity/wmsg:VolumeMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:ActualQuantity/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="70%"/>
								<col width="30%"/>
							</colgroup>
							<tr>
								<td id="Titel">6. Tatsächliches Datum der Verbringung:</td>
								<td id="Aktuell_nu">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:StartDate"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile7">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="10%"/>
							<col width="45%"/>
							<col width="20%"/>
							<col width="5%"/>
						</colgroup>
						<tr>
							<td id="Titel">7. Verpackung</td>
							<td id="Titel_klein">Art(en):</td>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Packaging">
									<xsl:variable name="lTypeCode">
										<xsl:value-of select="wmsg:PackageTypeCode"/>
									</xsl:variable>
									<xsl:variable name="TypeCode">
										<xsl:choose>
											<xsl:when test="$lTypeCode = '1'">1. Trommel/Fass</xsl:when>
											<!-- DR = Drum -> 1 = Fässer -->
											<xsl:when test="$lTypeCode = '2'">2. Holzfass</xsl:when>
											<!-- W1 = Jerrican -> 3 = Kanister -->
											<xsl:when test="$lTypeCode = '3'">3. Kanister</xsl:when>
											<!-- 2C = Barrel, wooden -> 2 = Holzfässer -->
											<xsl:when test="$lTypeCode = '4'">4. Kiste/Kasten</xsl:when>
											<!-- BX = Box -> 4 = Kisten -->
											<xsl:when test="$lTypeCode = '5'">5. Sack/Beutel</xsl:when>
											<!-- BG = Bag -> 5 = Säcke -->
											<xsl:when test="$lTypeCode = '6'">6. Verbundverpackung</xsl:when>
											<!-- W2 = Composite Package -> 6 = Zusammengesetzte Verp.-->
											<xsl:when test="$lTypeCode = '7'">7. Druckbehälter</xsl:when>
											<!-- W3 = Pressure Receptacle -> 7 = Druckbehälter -->
											<xsl:when test="$lTypeCode = '8'">8. Schüttgut</xsl:when>
											<!-- W4 = Other -> 9 = Sonstige Verpackungen -->
											<!--xsl:when test="$lTypeCode = 'W5'">
												<xsl:value-of select="'9. Andere: '"/>
												<xsl:value-of select="Type"/>
											</xsl:when-->
											<!-- W5 = Bulk -> 8 = Unverpackt, Schüttgut -->
											<xsl:otherwise>9. Andere</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$TypeCode"/>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Anzahl der Frachstücke:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:PackageQuantity"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="40%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel">Besondere Handhabungsvorschriften:</td>
							<td id="Titel_klein">Ja</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='true'">
												<font id="Aktuell_nu_indikator">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Nein</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='false'">
												<font id="Aktuell_nu_indikator">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile8">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="33%" valign="top"/>
				<col width="33%" valign="top"/>
				<col width="33%" valign="top"/>
			</colgroup>
			<tr>
			<xsl:variable name="CNT_CARRIER" select="count(wmsg:Transport)"/>
				<xsl:for-each select="wmsg:Transport">
					<xsl:choose>
						<xsl:when test="position() = 1 or position() = 2">
							<td width="33%">
								<table width="100%" id="Tabelle_rechts">
									<tr>
										<td>
											<xsl:call-template name="NAME_ADRESSE">
												<xsl:with-param name="ROLLE_VBF" select="concat('8.  ', position(), '. Transportunternehmen')"/>
												<xsl:with-param name="TRANS" select="true()"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:call-template name="CARRIER_MORE">
										<xsl:with-param name="POS" select="position()"/>
									</xsl:call-template>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position() = $CNT_CARRIER">
							<td width="33%">
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td>
											<xsl:call-template name="NAME_ADRESSE">
												<xsl:with-param name="ROLLE_VBF" select="'8. Letztes Transportunternehmen'"/>
												<xsl:with-param name="TRANS" select="true()"/>
												<xsl:with-param name="LASTTRANS" select="true()"/>
												<xsl:with-param name="COUNTTRANS" select="$CNT_CARRIER"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:call-template name="CARRIER_MORE">
										<xsl:with-param name="POS" select="position()"/>
									</xsl:call-template>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:if test="$CNT_CARRIER=2">
					<td width="33%">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td width="33%">
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
										<xsl:with-param name="LASTTRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
				</xsl:if>
				<xsl:if test="$CNT_CARRIER=1">
					<td width="33%">
						<table width="100%" id="Tabelle_rechts">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  2. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
										<xsl:with-param name="LASTTRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
				</xsl:if>
				<xsl:if test="$CNT_CARRIER=0">
					<td width="33%">
						<table width="100%" id="Tabelle_rechts">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  1. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_rechts">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  2. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
										<xsl:with-param name="LASTTRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
				</xsl:if>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="CARRIER_MORE">
		<xsl:param name="POS" select="0"/>
			<xsl:choose>
				<xsl:when test="$POS = 0">
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Transportart:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Übergabedatum:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Unterschrift:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Transportart:</td>
									<td id="Aktuell_nu">
										<xsl:value-of select="wmsg:MeansOfTransportCode"/>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">Übergabedatum:</td>
									<td id="Aktuell_nu">
										<xsl:call-template name="formatDate">
											<!-- zu klären-->
											<xsl:with-param name="date" select="wmsg:TransferDate"/>
										</xsl:call-template>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">Unterschrift:</td>
									<td id="Aktuell_nu">
										<!-- zu klären-->
										<!--xsl:value-of select="../userram:Confirmation/userram:PersonName"/-->
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Zeile9_14">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%" valign="top"/>
				<col width="50%" valign="top"/>
			</colgroup>
			<tr>
				<td width="50%">
					<xsl:call-template name="Zeile9"/>
					<xsl:call-template name="Zeile10"/>
					<xsl:call-template name="Zeile11"/>
				</td>
				<td width="50%">
					<xsl:call-template name="Zeile12"/>
					<xsl:call-template name="Zeile13"/>
					<xsl:call-template name="Zeile14"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile9">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:WasteProducer)=1">
					<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:WasteProducer">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
										<xsl:with-param name="ERZ" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="25%"/>
											<col width="75%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Ort der Abfallerzeugung:</td>
											<td id="Aktuell_nu">
												<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
													<xsl:if test="position()=1">
														<xsl:call-template name="SUBSTRING_VAL">
															<xsl:with-param name="VAL" select="."/>
															<xsl:with-param name="MAX_ZEICHEN" select="60"/>
														</xsl:call-template>
													</xsl:if>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
								<xsl:with-param name="ERZ" select="true()"/>
								<xsl:with-param name="MEHRERE" select="count(wmsg:TransportAnnouncement/wmsg:WasteProducer)>1"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="25%"/>
									<col width="75%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Ort der Abfallerzeugung:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile10">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:InitialInterimRecoveryDisposalFacility)>0">
					<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:InitialInterimRecoveryDisposalFacility">
						<tr>
							<td>
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
									<xsl:with-param name="BES_VERW" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="45%"/>
										<col width="55%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
										<td id="Aktuell_nu">
											<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
												<xsl:if test="position()=1">
													<xsl:call-template name="SUBSTRING_VAL">
														<xsl:with-param name="VAL" select="."/>
														<xsl:with-param name="MAX_ZEICHEN" select="45"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:NonInterimRecoveryDisposalFacility)>0">
					<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:NonInterimRecoveryDisposalFacility">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
										<xsl:with-param name="BES_VERW" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="45%"/>
											<col width="55%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
											<td id="Aktuell_nu">
												<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
													<xsl:if test="position()=1">
														<xsl:call-template name="SUBSTRING_VAL">
															<xsl:with-param name="VAL" select="."/>
															<xsl:with-param name="MAX_ZEICHEN" select="45"/>
														</xsl:call-template>
													</xsl:if>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
								<xsl:with-param name="BES_VERW" select="true()"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="45%"/>
									<col width="55%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile11">
		<table width="100%" id="Tabelle_rechts">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">11. Beseitigungs-/Verwertungsverfahren</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">D-Code / R-Code:</td>
							<td id="Aktuell_nu">
								<xsl:choose>
									<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:InitialInterimRecoveryDisposalFacility)>0">
										<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:InitialInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
											<xsl:if test="position()>1">
												<xsl:value-of select="', '"/>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
											<xsl:if test="position()>1">
												<xsl:value-of select="', '"/>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile12">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">12. Bezeichnung und Zusammensetzung des Abfalls:</td>
						</tr>
						<tr>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:WasteDesignationDescription/wmsg:Description">
									<xsl:if test="position()=1">
										<xsl:call-template name="SUBSTRING_VAL">
											<xsl:with-param name="VAL" select="."/>
											<xsl:with-param name="MAX_ZEICHEN" select="400"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile13">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td id="Titel">13. Physikalische Eigenschaften:</td>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:PhysicalCharacteristicTypeCode">
									<xsl:variable name="lPhys">
										<xsl:value-of select="."/>
									</xsl:variable>
									<xsl:variable name="PhysEig">
										<xsl:choose>
											<xsl:when test="$lPhys = 1">1. Staub- oder pulverförmig</xsl:when>
											<!-- SOLDUS = Solid - Dusty -> 1 = pulverförmig oder staubförmig -->
											<xsl:when test="$lPhys = 2">2. Fest</xsl:when>
											<!-- SOLCHU = Solid - in chunks -> 2 = fest -->
											<xsl:when test="$lPhys = 3">3. Pastös/breiig</xsl:when>
											<!-- SLUVISC =  Viscous or paste -> 3 = pastös oder breiig -->
											<xsl:when test="$lPhys = 4">4. Schlammig</xsl:when>
											<!-- SLU = Sludgy -> 4 = schlammig -->
											<xsl:when test="$lPhys = 5">5. Flüssig</xsl:when>
											<!-- LIQ = Liquid -> 5 = flüssig -->
											<xsl:when test="$lPhys = 6">6. Gasförmig</xsl:when>
											<!-- GAS = Gaseous -> 6 = gasförmig -->
											<xsl:otherwise>0. unbekannt</xsl:otherwise>
											<!-- ??? -> 0 = unbekannt -->
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$PhysEig"/>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile14">
		<xsl:for-each select="wmsg:TransportAnnouncement">
			<table width="100%" id="Tabelle_ohne">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel">14. Abfallidentifizierung</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="3%" align="right"/>
								<col width="47%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">i)</td>
								<td id="Titel_klein">Basel Anlage VIII (oder IX falls anwendbar):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='BASEL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">ii)</td>
								<td id="Titel_klein">OECD-Code (falls abweichend von i):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OECD']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iii)</td>
								<td id="Titel_klein">EU-Abfallverzeichnis:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='EWL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iv)</td>
								<td id="Titel_klein">Nationaler Code im Ausfuhrland:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATEXP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">v)</td>
								<td id="Titel_klein">Nationaler Code im Einfuhrland:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATIMP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vi)</td>
								<td id="Titel_klein">Sonstige:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OTHER']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vii)</td>
								<td id="Titel_klein">Y-Code:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='YCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">viii)</td>
								<td id="Titel_klein">H-Code:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='HCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iX) </td>
								<td id="Titel_klein">UN-Klasse:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNCLASS']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">X)</td>
								<td id="Titel_klein">UN-Kennnummer:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNNUM']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xi)</td>
								<td id="Titel_klein">UN-Versandname:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNSHIP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xii)</td>
								<td id="Titel_klein">Zollnummer(n) (HS):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='CUST']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile15">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">15. Erklärung des Exporteurs – Notifizierenden/Erzeugers</td>
						</tr>
						<tr>
							<td id="Titel_klein">Ich erkläre hiermit, dass die obigen Informationen nach meinem besten Wissen vollständig sind und der Wahrheit entsprechen.<br/>Ich erkläre ferner, dass rechtlich durchsetzbare vertragliche Verpflichtungen schriftlich eingegangen wurden, alle für die grenzüberschreitende Verbringung erforderlichen Versicherungen<br/>oder sonstigen Sicherheitsleistungen abgeschlossen bzw. hinterlegt wurden und alle erforderlichen Zustimmungen der zuständigen Behörden der betreffenden Staaten vorliegen.</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Name:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Name"/>
							</td>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wmsg:DeclarationExporter/wmsg:Date"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Signature"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile16">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">16. Von sonstigen an der grenzüberschreitenden Verbringung beteiligte Personen auszufüllen, falls zusätzliche Informationen verlangt werden:</td>
						</tr>
						<tr>
							<td id="Aktuell_nu">
								<!--xsl:value-of select="wmsg:AdditionalInformation/wmsg:Description"/-->
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">17. Eingang beim Importeur – Empfänger (falls keine Anlage)</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="formatDate">
									<!--xsl:with-param name="date" select="../ntz:FreieXMLStruktur/tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:Date"/-->
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Name:</td>
							<td id="Aktuell_nu">
									<!--xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:PersonName"/-->
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td>
								<!--xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
									<xsl:choose>
										<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
											<xsl:for-each select="..">
												<font id="Aktuell_nu">
													<xsl:call-template name="getSigBegleitformular">
														<xsl:with-param name="ROLLE1" select="'IMP'"/>
													</xsl:call-template>
												</font>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//ntz:PreDokument">
												<xsl:if test="count(ntz:VersandBegleitformular/usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
													<font id="Aktuell_nu">
														<xsl:call-template name="getSigBegleitformular">
															<xsl:with-param name="ROLLE1" select="'IMP'"/>
														</xsl:call-template>
													</font>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if-->
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER BESEITIGUNGS/VERWERTUNGSANLAGE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile18_19">
		<table width="100%" id="Tabelle">
			<colgroup>
				<col width="72%" valign="top"/>
				<col width="28%" valign="top"/>
			</colgroup>
			<tr>
				<td>
					<xsl:call-template name="Zeile18"/>
				</td>
				<td>
					<xsl:call-template name="Zeile19"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile18">
		<xsl:choose>
			<xsl:when test="count(wmsg:CertificateOfWasteReceipt)>0">
				<xsl:for-each select="wmsg:CertificateOfWasteReceipt">
					<xsl:if test="position()=1">
						<xsl:variable name="DVERF">
							<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
								<xsl:if test="starts-with(.,'D')">
									<xsl:value-of select="'X'"/>
								</xsl:if>
							</xsl:for-each>
						</xsl:variable>
						<xsl:variable name="RVERF">
							<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
								<xsl:if test="starts-with(.,'R')">
									<xsl:value-of select="'X'"/>
								</xsl:if>
							</xsl:for-each>
						</xsl:variable>
						<xsl:variable name="DX">
							<xsl:if test="string-length($DVERF)>0">
								<xsl:value-of select="'X'"/>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="RX">
							<xsl:if test="string-length($RVERF)>0">
								<xsl:value-of select="'X'"/>
							</xsl:if>
						</xsl:variable>
						<table width="100%" id="Tabelle_rechts">
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="35%"/>
											<col width="10%"/>
											<col width="17%"/>
											<col width="10%"/>
											<col width="23%"/>
											<col width="5%"/>
										</colgroup>
										<tr>
											<td id="Titel">18. Eingang bei der Beseitigungsanlage</td>
											<td/>
											<td>
												<table id="Tabelle_indikator">
													<tr>
														<td>
															<font id="Aktuell_nu_indikator">
																<xsl:value-of select="$DX"/>
															</font>
														</td>
													</tr>
												</table>
											</td>
											<td/>
											<td id="Titel">oder Verwertungsanlage</td>
											<td>
												<table id="Tabelle_indikator">
													<tr>
														<td>
															<font id="Aktuell_nu_indikator">
																<xsl:value-of select="$RX"/>
															</font>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Eingangsdatum:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:ReceiptDate"/>
												</xsl:call-template>
											</td>
											<td id="Titel_klein">in Empfang genommen:</td>
											<td>
												<table id="Tabelle_indikator">
													<tr>
														<td>
															<xsl:if test="wmsg:RejectionIndicator = 'false'">
																<font id="Aktuell_nu_indikator">
																	<xsl:value-of select="'X'"/>
																</font>
															</xsl:if>
														</td>
													</tr>
												</table>
											</td>
											<td id="Titel_klein">Empfang verweigert:</td>
											<td>
												<table id="Tabelle_indikator">
													<tr>
														<td>
															<xsl:if test="wmsg:RejectionIndicator = 'true'">
																<font id="Aktuell_nu_indikator">
																	<xsl:value-of select="'X'"/>
																</font>
															</xsl:if>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">In Empfang genommene Menge: Tonnen (Mg):</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDouble">
													<xsl:with-param name="wert" select="wmsg:Quantity/wmsg:MassMeasure"></xsl:with-param>
													<xsl:with-param name="unit" select="wmsg:Quantity/wmsg:MassMeasure/@unitCode"></xsl:with-param>
												</xsl:call-template>
											</td>
											<td id="Titel_klein">m³:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDouble">
													<xsl:with-param name="wert" select="wmsg:Quantity/wmsg:VolumeMeasure"></xsl:with-param>
													<xsl:with-param name="unit" select="wmsg:Quantity/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
												</xsl:call-template>
											</td>
											<td/>
											<td/>
										</tr>
										<tr>
											<td id="Titel_klein">Ungefähres Datum der Beseitigung/Verwertung:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:RecoveryDisposalStartDate"/>
												</xsl:call-template>
											</td>
											<td/>
											<td/>
											<td/>
											<td/>
										</tr>
									</table>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="35%"/>
											<col width="65%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Beseitigungs- Verwertungsverfahren:</td>
											<td id="Aktuell_nu">
												<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
													<xsl:if test="position()>1">
														<xsl:value-of select="', '"/>
													</xsl:if>
													<xsl:value-of select="."/>
												</xsl:for-each>
											</td>
										</tr>
									</table>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="20%"/>
											<col width="80%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Name:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="SUBSTRING_VAL">
													<xsl:with-param name="VAL" select="wmsg:Name"/>
													<xsl:with-param name="MAX_ZEICHEN" select="100"/>
												</xsl:call-template>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Datum:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:Date"/>
												</xsl:call-template>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Unterschrift:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="SUBSTRING_VAL">
													<xsl:with-param name="VAL" select="wmsg:Signatur"/>
													<xsl:with-param name="MAX_ZEICHEN" select="100"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_rechts">
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="35%"/>
									<col width="10%"/>
									<col width="17%"/>
									<col width="10%"/>
									<col width="23%"/>
									<col width="5%"/>
								</colgroup>
								<tr>
									<td id="Titel">18. Eingang bei der Beseitigungsanlage</td>
									<td/>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
												</td>
											</tr>
										</table>
									</td>
									<td/>
									<td id="Titel">oder Verwertungsanlage</td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>

												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">Eingangsdatum:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
									<td id="Titel_klein">in Empfang genommen:</td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel_klein">Empfang verweigert:</td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">In Empfang genommene Menge: Tonnen (Mg):</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
									<td id="Titel_klein">m³:</td>
									<td/>
									<td/>
									<td/>
								</tr>
							</table>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="35%"/>
									<col width="65%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Ungefähres Datum der Beseitigung/Verwertung:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Beseitigungs- Verwertungsverfahren:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Name:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Datum:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Unterschrift:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Zeile19">
		<xsl:choose>
			<xsl:when test="count(wmsg:CertificateOfCompletion)>0">
				<xsl:for-each select="wmsg:CertificateOfCompletion">
					<xsl:if test="position()=1">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<tr>
											<td id="Titel">19. Ich bescheinige hiermit, dass die oben<br/>beschriebenen Abfälle beseitigt/<br/>verwertet worden sind.</td>
										</tr>
									</table>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="20%"/>
											<col width="80%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Name:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="SUBSTRING_VAL">
													<xsl:with-param name="VAL" select="wmsg:Name"/>
													<xsl:with-param name="MAX_ZEICHEN" select="25"/>
												</xsl:call-template>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Datum:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:Date"/>
												</xsl:call-template>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Unterschrift:</td>
										</tr>
										<tr>
											<td id="Aktuell_nu">
												<xsl:call-template name="SUBSTRING_VAL">
													<xsl:with-param name="VAL" select="wmsg:Signatur"/>
													<xsl:with-param name="MAX_ZEICHEN" select="30"/>
												</xsl:call-template>
											</td>
										</tr>
										<!--tr>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr>
										<tr>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr>
										<tr>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr-->
									</table>
								</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<tr>
									<td id="Titel">19. Ich bescheinige hiermit, dass die oben beschriebenen Abfälle beseitigt/verwertet worden sind.</td>
								</tr>
							</table>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Name:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Datum:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Unterschrift:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<!--tr>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr-->
							</table>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Zeile19a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER ZOLLSTELLE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile20_21">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" id="Tabelle_rechts">
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td id="Titel">20. Ausfuhrstaat/Versandstaat oder Ausgangszollstelle</td>
									</tr>
									<tr>
										<td id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden aus dem Land</td>
									</tr>
								</table>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="15%"/>
										<col width="85%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">ausgeführt am:</td>
										<td id="Aktuell_nu">
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date" select="wmsg:ExitCustomsDeclaration/wmsg:Date"/>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Unterschrift:</td>
										<td id="Aktuell_nu">
											<xsl:value-of select="wmsg:ExitCustomsDeclaration/wmsg:DeclarationSignatureText"/>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Stempel:</td>
									</tr>
									<tr>
										<xsl:call-template name="DUMMY_ZEICHEN"/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td id="Titel">21. Einfuhrstaat/Empfängerstaat oder Eingangszollstelle</td>
									</tr>
									<tr>
										<td id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden in das Land</td>
									</tr>
								</table>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="15%"/>
										<col width="85%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">eingeführt am:</td>
										<td id="Aktuell_nu">
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date" select="wmsg:EntryCustomsDeclaration/wmsg:Date"/>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Unterschrift:</td>
										<td id="Aktuell_nu">
											<xsl:value-of select="wmsg:EntryCustomsDeclaration/wmsg:DeclarationSignatureText"/>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Stempel:</td>
									</tr>
									<tr>
										<xsl:call-template name="DUMMY_ZEICHEN"/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile22">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">22. Stempel der Zollstellen der Durchfuhrstaaten</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile22a">
		<xsl:variable name="COUNT_TRANSIT" select="count(wmsg:TransitCustomsDeclaration)"/>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<xsl:for-each select="wmsg:TransitCustomsDeclaration">
					<xsl:choose>
						<xsl:when test="position()=1">
							<td width="50%">
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position()=2">
							<td width="50%">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="$COUNT_TRANSIT=0">
						<td width="50%">
							<table width="100%" id="Tabelle_rechts">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
					<xsl:when test="$COUNT_TRANSIT=1">
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
				</xsl:choose>
			</tr>
		</table>
		<table width="100%" id="Tabelle">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<xsl:for-each select="wmsg:TransitCustomsDeclaration">
					<xsl:choose>
						<xsl:when test="position()=3">
							<td width="50%">
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position()=4">
							<td width="50%">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="$COUNT_TRANSIT=0 or $COUNT_TRANSIT=1 or $COUNT_TRANSIT=2">
						<td width="50%">
							<table width="100%" id="Tabelle_rechts">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
					<xsl:when test="$COUNT_TRANSIT=0 or $COUNT_TRANSIT=1 or $COUNT_TRANSIT=2 or $COUNT_TRANSIT=3">
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
				</xsl:choose>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="ZOLL_MORE">
		<tr>
			<td id="Titel_klein">Name des Staates:</td>
			<td id="Aktuell_nu">
				<!--  xsl:value-of select="util:getLandKuerzel(wmsg:CountryID)"/-->
				<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
			</td>
		</tr>
		<tr>
			<td>
				<table width="100%" id="Tabelle_rechts">
					<colgroup>
						<col width="25%"/>
						<col width="75%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Eingang:</td>
						<td id="Aktuell_nu">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="wmsg:Entry/wmsg:Date"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
			<td>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="25%"/>
						<col width="75%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Ausgang:</td>
						<td id="Aktuell_nu">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="wmsg:Exit/wmsg:Date"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="NAME_ADRESSE">
		<xsl:param name="ROLLE_VBF"/>
		<xsl:param name="BES_VERW" select="false()"/>
		<xsl:param name="TRANS" select="false()"/>
		<xsl:param name="ERZ" select="false()"/>
		<xsl:param name="LASTTRANS" select="false()"/>
		<xsl:param name="COUNTTRANS" select="0"/>
		<xsl:param name="MEHRERE" select="false()"/>
		
		<xsl:variable name="MAXZEICHEN">
				<xsl:choose>
					<xsl:when test="not($TRANS)">
						<xsl:value-of select="70"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="40"/>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$BES_VERW">
				<xsl:variable name="DVERF">
					<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
						<xsl:if test="starts-with(.,'D')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="RVERF">
					<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
						<xsl:if test="starts-with(.,'R')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="DX">
					<xsl:if test="string-length($DVERF)>0">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="RX">
					<xsl:if test="string-length($RVERF)>0">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:variable>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="40%"/>
						<col width="10%"/>
						<col width="40%"/>
						<col width="10%"/>
					</colgroup>
					<tr>
						<td id="Titel">
							<xsl:value-of select="$ROLLE_VBF"/>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<font id="Aktuell_nu_indikator">
											<xsl:value-of select="$DX"/>
										</font>
									</td>
								</tr>
							</table>
						</td>
						<td id="Titel">oder Verwertungsanlage</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<font id="Aktuell_nu_indikator">
											<xsl:value-of select="$RX"/>
										</font>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="50%"/>
						<col width="15%"/>
						<col width="35%"/>
					</colgroup>
					<tr>
						<td id="Titel">
							<xsl:value-of select="$ROLLE_VBF"/>
						</td>
						<xsl:if test="not($TRANS)">
							<td id="Titel_klein">Registriernummer:</td>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:PartyID[@identificationSchemeID='276']">
									<xsl:value-of select="."/>
								</xsl:for-each>
							</td>
						</xsl:if>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="string-length(wmsg:OrganizationName)>0 or string-length(wmsg:Person)>0">
					<xsl:if test="$TRANS or $BES_VERW">
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Registriernummer:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:PartyID[@identificationSchemeID='276']">
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</xsl:if>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
							<tr>
								<td id="Titel_klein">Name:</td>
								<td id="Aktuell_nu">
									<xsl:variable name="NAME_1">
										<xsl:choose>
											<xsl:when test="string-length(wmsg:OrganizationName)>0">
												<xsl:value-of select="wmsg:OrganizationName"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="wmsg:Person/wmsg:GivenName"/>
												&#173;
												<xsl:value-of select="wmsg:Person/wmsg:FamilyName"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="$NAME_1"/>
										<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:choose>
								<xsl:when test="$ERZ">
									<tr>
										<td id="Titel_klein">Anschrift:</td>
										<td id="Aktuell_nu">
											<xsl:variable name="ORT">
												<!-- ohne Country ID wmsg:Address/wmsg:CountryID,' ', -->
												<xsl:value-of select="normalize-space(concat(wmsg:Address/wmsg:Postcode,' ',wmsg:Address/wmsg:CityName))"/>
											</xsl:variable>
											<xsl:variable name="STRASSE">
												<xsl:choose>
													<xsl:when test="string-length(wmsg:Address/wmsg:StreetName) > 0">
														<xsl:value-of select="wmsg:Address/wmsg:StreetName"/>
													</xsl:when>
													<xsl:when test="string-length(wmsg:Address/wmsg:PostOfficeBox)">
														<xsl:value-of select="wmsg:Address/wmsg:PostOfficeBox"/>
													</xsl:when>
												</xsl:choose>
											</xsl:variable>
											<xsl:variable name="HAUSNR">
												<xsl:value-of select="wmsg:Address/wmsg:BuildingNumber"/>
											</xsl:variable>
											<xsl:variable name="STRASSE_GES">
												<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR,', ',$ORT))"/>
											</xsl:variable>
											<xsl:call-template name="SUBSTRING_VAL">
												<xsl:with-param name="VAL" select="$STRASSE_GES"/>
												<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td id="Titel_klein">Anschrift:</td>
										<td id="Aktuell_nu">
											<xsl:variable name="STRASSE">
												<xsl:choose>
													<xsl:when test="string-length(wmsg:Address/wmsg:StreetName) > 0">
														<xsl:value-of select="wmsg:Address/wmsg:StreetName"/>
													</xsl:when>
													<xsl:when test="string-length(wmsg:Address/wmsg:PostOfficeBox)">
														<xsl:value-of select="wmsg:Address/wmsg:PostOfficeBox"/>
													</xsl:when>
												</xsl:choose>
											</xsl:variable>
											<xsl:variable name="HAUSNR">
												<xsl:value-of select="wmsg:Address/wmsg:BuildingNumber"/>
											</xsl:variable>
											<xsl:variable name="STRASSE_GES">
												<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR))"/>
											</xsl:variable>
											<xsl:call-template name="SUBSTRING_VAL">
												<xsl:with-param name="VAL" select="$STRASSE_GES"/>
												<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td/>
										<td id="Aktuell_nu">
											<xsl:variable name="ORT">
												<!-- ohne Country ID wmsg:Address/wmsg:CountryID,' ', -->
												<xsl:value-of select="normalize-space(concat(wmsg:Address/wmsg:Postcode,' ',wmsg:Address/wmsg:CityName))"/>
											</xsl:variable>
											<xsl:call-template name="SUBSTRING_VAL">
												<xsl:with-param name="VAL" select="$ORT"/>
												<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:if test="$TRANS=false()">
								<tr>
									<td id="Titel_klein">Kontaktperson:</td>
									<td id="Aktuell_nu">
										<xsl:variable name="GENDER">
											<xsl:choose>
												<xsl:when test="wmsg:Contact/wmsg:GenderCode=1">Herr</xsl:when>
												<xsl:when test="wmsg:Contact/wmsg:GenderCode=2">Frau</xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="KONTAKT">
											<xsl:value-of select="normalize-space(concat($GENDER,' ',wmsg:Contact/wmsg:GivenName, ' ',wmsg:Contact/wmsg:FamilyName))"/>
										</xsl:variable>
										<xsl:call-template name="SUBSTRING_VAL">
											<xsl:with-param name="VAL" select="$KONTAKT"/>
											<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:if>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Tel.:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:TelephoneCompleteNumber"/>
							</td>
							<td id="Titel_klein">Fax:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:FaxCompleteNumber"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">E-Mail:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:EmailURI"/>
							</td>
						</tr>
					</table>
					<xsl:if test="$TRANS">
						<xsl:choose>
							<xsl:when test="$LASTTRANS">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="80%"/>
										<col width="20%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">Mehr als drei Transportunternehmen</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="$COUNTTRANS>3">
															<font id="Aktuell_nu_indikator">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</xsl:when>
							<xsl:otherwise>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="80%"/>
										<col width="20%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein"></td>
										<xsl:call-template name="DUMMY_ZEICHEN"/>
									</tr>
								</table>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$TRANS or $BES_VERW">
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="20%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Registriernummer:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</table>
				</xsl:if>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Name:</td>
						<xsl:choose>
							<xsl:when test="$MEHRERE">
								<td id="Aktuell_nu">mehrere Abfallerzeuger, s. vollständige Ansicht</td>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="DUMMY_ZEICHEN"/>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					<tr>
						<td id="Titel_klein">Anschrift:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<xsl:if test="not($ERZ)">
						<tr>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
					<xsl:if test="$TRANS=false()">
						<tr>
							<td id="Titel_klein">Kontaktperson:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="10%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Tel.:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
						<td id="Titel_klein">Fax:</td>
						<td/>
					</tr>
					<tr>
						<td id="Titel_klein">E-Mail:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
					<xsl:if test="$TRANS">
						<xsl:choose>
							<xsl:when test="$LASTTRANS">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="80%"/>
										<col width="20%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">Mehr als drei Transportunternehmen</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</xsl:when>
							<xsl:otherwise>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="80%"/>
										<col width="20%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein"></td>
										<xsl:call-template name="DUMMY_ZEICHEN"/>
									</tr>
								</table>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="DUMMY_ZEICHEN">
		<td>
			<font id="Aktuell_nu">&#173;</font>
		</td>
	</xsl:template>
</xsl:stylesheet>
