<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib en ds b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="EBDa"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="EBDa">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<!-- EB ja / nein -->
				<xsl:choose>
					<xsl:when test="not (boolean(en:EB))">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td>
									<font id="Nummer">
							  			In dieser Sicht ist keine Eingangsbest&#228;tigung vorhanden.
						  			</font>
									<br/>
									<font id="Nummer2">
							  			Eine Eingangsbestätigung befindet sich in der Sicht:
							  		</font>
									<font id="FormPosition">
										<!--xsl:call-template name="EB_Position">
					            			</xsl:call-template-->
										<xsl:call-template name="CHILD_POSITION">
											<xsl:with-param name="DocTyp" select="'ENSN'"/>
											<xsl:with-param name="ChildTyp" select="'en:EB'"/>
				            			</xsl:call-template>
									</font>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="EB">
	            			</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="EB">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<table id="tabelle" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="39%"/>
										<col width="22%"/>
										<col width="39%"/>
									</colgroup>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td id="Ueberschrift2" width="98%">Best&#228;tigende Beh&#246;rde</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Name</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde - Name 1 -->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name1"/>
													</font>
															&#173;
															<!-- Behörde- Name 2 -->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name2"/>
													</font>
															&#173;
															<!-- Behörde - Name 3 -->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name3"/>
													</font>
															&#173;
															<!-- Behörde - Name 4 -->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name4"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Behörde - Strasse 1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde - Strasse 2-->
																<font id="Aktuell">
																	<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_2"/>
																</font>
															</td>
															<td width="10%">
																<!-- Behörde - Hausnummer -->
																<font id="Aktuell">
																	<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Hausnummer"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Postleitzahl -->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Behörde Ort1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde Ort2-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:EB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - Name-->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Name"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Ansprechpartner - Telefon-->
																<font id="Aktuell">
																	<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefon"/>
																</font>
															</td>
															<td width="70%">
																<!-- Behörde Ansprechpartner - Telefax-->
																<font id="Aktuell">
																	<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefax"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - E-Mail-->
													<font id="Aktuell">
														<xsl:value-of select="en:EB/en:AbsenderBehoerde/en:Ansprechpartner/lib:EMail"/>
													</font>
												</td>
											</tr>
										</table>
									</td>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div align="right"><font id="Nummer">Eingangsbest&#228;tigung</font><font id="Ueberschrift2"> (<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)</font></div>
					<table id="tabelle_nicht_unten" width="100%">
						<xsl:call-template name="ESNKopfNummern"/>
					</table>
					<table id="Tabelle_nicht_oben_unten" width="100%">
						<tr>
							<td id="Nummer">
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="6%"/>
										<col width="3%"/>
										<col width="30%"/>
										<col width="5%"/>
										<col width="3%"/>
										<col width="40%"/>
										<col width="13%"/>
									</colgroup>
									<tr>
										<td id="titel_gross"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="en:EB/en:IndicatorMaengel = 'true'">
															<font id="Aktuell">			
																X														
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
										<td align="left" id="Nummer">Es wurden M&#228;ngel festgestellt </td>
										<td id="titel_gross"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="en:EB/en:IndicatorFristhemmung = 'true'">
															<font id="Aktuell">			
															X														
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
										<td align="left" id="Nummer">Die Unvollständigkeit ist fristunterbrechend </td>
										<td id="titel_gross"/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="tabelle_nicht_unten">
						<colgroup>
							<col width="92%"/>
							<col width="8%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%">
									<tr>
										<td id="Ueberschrift2" width="5">1</td>
										<td id="Ueberschrift2" width="98%">Eingangsbest&#228;tigung</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.1</td>
										<td id="titel" width="98%">
      		                                               Eingangsdatum
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date">
														<xsl:value-of select="en:EB/en:Eingangsdatum"/>
													</xsl:with-param>
												</xsl:call-template>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.2</td>
										<td id="titel" width="98%">
      		                                               Nachforderungen bis
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date">
														<xsl:value-of select="en:EB/en:NachforderungenBis"/>
													</xsl:with-param>
												</xsl:call-template>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.3</td>
										<td id="titel" width="98%">
      		                                               Eingang Nachforderung
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date">
														<xsl:value-of select="en:EB/en:EingangNachforderung"/>
													</xsl:with-param>
												</xsl:call-template>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.4</td>
										<td id="titel" width="98%">
                                                        Aktenzeichen
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:if test="en:EB/en:Aktenzeichen">
													<xsl:value-of select="en:EB/en:Aktenzeichen"/>
												</xsl:if>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.5</td>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="33%">Ort</td>
													<td id="titel" width="33%">Datum</td>
													<td id="titel" width="33%">Unterschrift</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td width="33%">
														<!-- Ort Unterschrift  -->
														<font id="Aktuell">
															<xsl:value-of select="en:EB/en:Bestaetigung/lib:Ort"/>
														</font>
													</td>
													<td width="33%">
														<!--  Datum -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:EB/en:Bestaetigung/lib:Datum"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="33%">
														<font id="Aktuell">
															<xsl:if test="ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
																<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																<xsl:variable name="SIG_DATE">
																	<xsl:call-template name="formatDate">
																		<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
															</xsl:if>
														</font>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td height="100%" id="tabelle_links">
								<table height="100%" width="100%">
									<tr height="3%">
										<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
									</tr>
									<tr height="97%">
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="tabelle">
						<colgroup>
							<col width="92%"/>
							<col width="8%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%">
									<tr>
										<td id="Ueberschrift2" width="5">2</td>
										<td id="Ueberschrift2" width="98%">Sachbearbeiter</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">2.1</td>
										<td id="titel" width="98%">
                                                    Name
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<!-- Sachbearbeiter - Name  -->
											<font id="Aktuell">
												<xsl:value-of select="en:EB/en:Ansprechpartner/lib:Name"/>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">2.2</td>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="30%">Telefon</td>
													<td id="titel" width="70%">Telefax</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td width="30%">
														<!-- Sachbearbeiter  - Telefon-->
														<font id="Aktuell">
															<xsl:value-of select="en:EB/en:Ansprechpartner/lib:Telefon"/>
														</font>
													</td>
													<td width="70%">
														<!-- Sachbearbeiter - Telefax-->
														<font id="Aktuell">
															<xsl:value-of select="en:EB/en:Ansprechpartner/lib:Telefax"/>
														</font>
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">2.3</td>
										<td id="titel" width="98%">
      	                                                  E-Mail-Adresse
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<!-- Sachbearbeiter - Email -->
											<font id="Aktuell">
												<xsl:value-of select="en:EB/en:Ansprechpartner/lib:EMail"/>
											</font>
										</td>
									</tr>
								</table>
							</td>
							<td height="100%" id="tabelle_links">
								<table height="100%" width="100%">
									<tr height="3%">
										<td id="Ueberschrift2">    </td>
									</tr>
									<tr height="97%">
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<!--Fehler-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Fehlerprotokoll:</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="5%"> Adressat</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="5%"> Fehlerklasse</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Fehler-Code</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="38%"> Fehler-Text</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="34%"> Abhilfe</td>
									</tr>
								</table>
								<xsl:for-each select="en:EB/en:Fehlerprotokoll/en:Fehler">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="5%">
												<xsl:value-of select="@lib:ATBRolle"/>
												<xsl:value-of select="@lib:ATBBefLfdNummer"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="5%">
												<xsl:value-of select="@lib:Fehlerklasse"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:value-of select="lib:FehlerCode"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="38%">
												<xsl:value-of select="lib:FehlerText"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="34%">
												<xsl:value-of select="lib:FehlerAbhilfe"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
					</table>
					<!--Ende Fehlerprotokoll-->
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf </font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:EB/en:Rechtsbehelf"/>
					</font>
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<th>
					<xsl:call-template name="Dateianhang">
	            			</xsl:call-template>
				</th>
			</tr>
		</table>
	</xsl:template>
	<!--gebühren und anhänge-->
	<xsl:template name="Dateianhang">
		<table width="100%" border="0">
			<tr align="left">
				<td id="Text_normal "> Anhang: </td>
			</tr>
			<xsl:if test="count(en:Gebuehr/en:Dateianhang)>0">
				<xsl:call-template name="Anhang">
            		</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template name="Anhang">
		<table width="100%" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<font id="Nummer2">Im signierten Gebührenbereich angehängt wurden:</font>
					<br/>
					<br/>
					<ul>
						<xsl:for-each select="en:Gebuehr/en:Dateianhang">
							<font id="Aktuell">
								<li>
									<xsl:value-of select="@lib:dateiname"/>
								</li>
							</font>
						</xsl:for-each>
					</ul>
					<!--font id="noprint">
						<a href="javascript:save_file();">Um die Geb&#252;hrenanhänge aus dem Dokument anzusehen, bitte hier klicken</a>
					</font-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="EB_Position">
		<xsl:variable name="CNTLAYER">
			<xsl:value-of select="count(//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))])"></xsl:value-of>
		</xsl:variable>
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="en:EB">
				<xsl:choose>
					<xsl:when test="$CNTLAYER - position() + 1 > 9">
						<xsl:value-of select="concat($CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0', $CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
