<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>

	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//abf:Anzeige">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Formblatt Anzeige nach § 53 KrWG</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileAnzeige"/>
						<!--xsl:call-template name="showSigLayer"/-->
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileAnzeige">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 1</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="AnzeigeKopf"/>
					<xsl:call-template name="Zeile1"/>
					<xsl:call-template name="Zeile2"/>
					<xsl:call-template name="Zeile3"/>
					<xsl:call-template name="Zeile4"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 2</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Zeile4a"/>
					<xsl:call-template name="Zeile5"/>
					<xsl:call-template name="Zeile6"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 3</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Zeile7"/>
					<xsl:call-template name="Zeile8"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 4</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Zeile9"/>
					<xsl:call-template name="Zeile10"/>
				</td>
			</tr>
		</table>

		<xsl:if test="count(abf:Eingangsbestaetigung/abf:Hinweis)>0">
			<xsl:variable name="ZEICHEN_HW">
					<xsl:for-each select="abf:Eingangsbestaetigung/abf:Hinweis">
						<xsl:value-of select="abf:Textbaustein"/>
					</xsl:for-each>
			</xsl:variable>
			<xsl:if test="string-length($ZEICHEN_HW)>$MAX_ZEICHEN_MEMO">
				<p style="page-break-after:always">
					<br style="height:0; line-height:0"/>
				</p>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr valign="bottom">
						<td>
							<div id="Titel" align="center"></div>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:call-template name="ZeileHinweise"/>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:if>

		<xsl:if test="count(abf:Nachforderung)>0">
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<xsl:call-template name="ZeileNF"/>
					</td>
				</tr>
			</table>
		</xsl:if>

		<xsl:if test="count(abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true'])>2 or count(abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')])>2">
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<xsl:call-template name="ZeilePerson"/>
					</td>
				</tr>
			</table>
		</xsl:if>

		<xsl:if test="count(abf:BedingungenAuflagen)>0">
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr valign="bottom">
					<td>
						<div id="Titel" align="center"></div>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:call-template name="ZeileMore"/>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="count(abf:BedingungenAuflagen/abf:Nebenbestimmungen)>0">
			<xsl:variable name="ZEICHEN_NB">
					<xsl:for-each select="abf:BedingungenAuflagen/abf:Nebenbestimmungen">
						<xsl:value-of select="abf:Textbaustein"/>
					</xsl:for-each>
					<xsl:for-each select="abf:BedingungenAuflagen/abf:Begruendungen">
						<xsl:value-of select="abf:Textbaustein"/>
					</xsl:for-each>
			</xsl:variable>
			<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
				<p style="page-break-after:always">
					<br style="height:0; line-height:0"/>
				</p>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr valign="bottom">
						<td>
							<div id="Titel" align="center"></div>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:call-template name="ZeileBeiblatt"/>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:if>

		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center"></div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="ZeileGemeinde"/>
				</td>
			</tr>
		</table-->
	</xsl:template>

	<xsl:template name="AnzeigeKopf">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Nummer">
						Anzeige von Sammlern, Beförderern, Händlern und Maklern von Abfällen
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorErstmaligeAnzeige'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Erstmalige Anzeige</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="34%"/>
							<col width="40%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorAenderungsanzeige'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Änderungsanzeige</td>
							<td id="Titel_klein">Vorgangsnummer (sofern von der Behörde erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
								&#173;
								<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile1">
		<table width="100%" id="tabelle_nicht_unten">
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="85%"/>
							<col width="15%"/>
						</colgroup>
						<tr>
							<td id="Titel">1</td>
							<td id="Titel">Anzeigender (Hauptsitz des Betriebes)</td>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">1.1</td>
							<td id="Titel_klein">Firma / Körperschaft</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name1"/>
								&#173;
								<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name2"/>
							</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name3"/>
								&#173;
								<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name4"/>
							</td>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">1.2</td>
							<td id="Titel_klein">Straße</td>
							<td id="Titel_klein">Hausnr.</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_1"/>
								&#173;
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_2"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Hausnummer"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="20%"/>
							<col width="57%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.3</td>
							<td id="Titel_klein">Bundesland (2-stellig)</td>
							<td id="Titel_klein">PLZ</td>
							<td id="Titel_klein">Ort</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:BundeslandAnzeigender"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Postleitzahl"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_1"/>
								&#173;
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_2"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">1.4</td>
							<td id="Titel_klein">Staat (2-stellig)</td>
							<td id="Titel_klein">Gemeindeschlüssel</td>
							<td id="Titel_klein">Gemeindebezeichnung</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Staat"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Gemeindeschluessel"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Gemeindename"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<tr>
							<td width="3%" id="Titel_klein">1.5</td>
							<td width="97%" id="Titel_klein">Für Anzeigende, die keinen Hauptsitz im Inland haben: Ort der erstmaligen Sammler-, Beförderer-, Händler- oder Maklertätigkeit.</td>
							<td/>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="20%"/>
							<col width="57%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Bundesland (2-stellig)</td>
							<td id="Titel_klein">PLZ</td>
							<td id="Titel_klein">Ort</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Bundesland"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Postleitzahl"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Ort_1"/>
								&#173;
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Ort_2"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="77%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Gemeindeschlüssel</td>
							<td id="Titel_klein">Gemeindebezeichnung</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Gemeindeschluessel"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Gemeindename"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="40%"/>
							<col width="28%"/>
							<col width="29%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.6</td>
							<td id="Titel_klein">Telefon</td>
							<td id="Titel_klein">Telefax</td>
							<td id="Titel_klein">USt-Identnr.</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:AnzeigenderWeiteres/kop:Telefon"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AnzeigenderWeiteres/kop:Telefax"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AnzeigenderWeiteres/abf:UStIdentnummer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">1.7</td>
							<td id="Titel_klein">Mobiltelefon</td>
							<td id="Titel_klein">E-Mail</td>
							<td id="Titel_klein"></td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:AnzeigenderWeiteres/abf:Mobiltelefon"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AnzeigenderWeiteres/kop:EMail"/>
							</td>
						</tr>					
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="20%"/>
							<col width="28%"/>
							<col width="29%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.8</td>
							<td id="Titel_klein">Gewerbeanmeldung</td>
							<td id="Titel_klein">Datum der Anmeldung</td>
							<td id="Titel_klein">zuständige Behörde</td>
							<td id="Titel_klein">Aktenzeichen (soweit bekannt)</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td/>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="abf:Anzeigender/abf:Gewerbeanmeldung/abf:Anmeldedatum"/>
								</xsl:call-template>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Gewerbeanmeldung/abf:ZustBehoerde"/>&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Gewerbeanmeldung/abf:Aktenzeichen"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%" valign="top"/>
							<col width="40%" valign="top"/>
							<col width="28%" valign="top"/>
							<col width="29%" valign="top"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.9</td>
							<td id="Titel_klein">Eintrag in das Handels-, Vereins oder Genossen-<br/>schaftsregister (sofern ein Eintrag erfolgt ist)</td>
							<td id="Titel_klein">Registernummer (HRA, HRB, etc.)</td>
							<td id="Titel_klein">Registergericht</td>
						</tr>
						<tr>
							<td/>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Registereintragung/abf:Registernummer"/>&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Anzeigender/abf:Registereintragung/abf:Registergericht"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile2">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">2</td>
				<td id="Titel">Folgende abfallwirtschaftliche Tätigkeiten werden angezeigt:</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="10%"/>
							<col width="60%"/>
							<col width="24%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">2.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorSammeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Sammeln.</td>
							<td id="Titel_klein">Sammler- oder Beförderenummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.2</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorBefoerdern'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Befördern.</td>
							<td id="Titel_klein">Beförderenummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.3</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorHandeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Handeln.</td>
							<td id="Titel_klein">Händlernummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.4</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorMakeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Makeln.</td>
							<td id="Titel_klein">Maklernummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:Pruefziffer"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">3</td>
				<td id="Titel">Art der Tätigkeit</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">3.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:ArtDerTaetigkeit/abf:IndicatorGewerbsmaessig'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Gewerbsmäßig.<br/>Unternehmenszweck ist ganz oder teilweise das entgeltliche Sammeln, Befördern, Handeln oder Makeln von Abfällen für Dritte.</td>
						</tr>
						<tr>
							<td id="Titel_klein">3.2</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:ArtDerTaetigkeit/abf:IndicatorWirtschaftlich'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Im Rahmen wirtschaftlicher Unternehmen.<br/>Unternehmenszweck ist eine anderweitige gewerbliche oder wirtschaftliche Tätigkeit, die nicht auf das Sammeln, Befördern,<br/>Handeln oder Makeln von Abfällen gerichtet ist.</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile4">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">4</td>
				<td id="Titel">Befreiung von der Erlaubnispflicht</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:IndicatorNichtGefaehrlicheAbfaelle'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Nur nicht gefährliche Abfälle (dann weiter unter 5)</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:IndicatorGefaehrlicheAbfaelle'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Auch gefährliche Abfälle (dann weiter unter 4.2)</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile4a">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel">4</td>
				<td id="Titel">Fortsetzung von Seite 1: Befreiung von der Erlaubnispflicht</td>
				<td/>
			</tr>
			<tr>
				<td id="Titel_klein">4.2</td>
				<td id="Titel_klein">Das Sammeln, Befördern, Handeln und Makeln von gefährlichen Abfällen ist nach § 54 Absatz 1 Satz 1 KrWG grundsätzlich erlaubnispflichtig.<br/>Der Betrieb ist auf Grund einer oder mehrerer der genannten Tatbestände aber von der Erlaubnispflicht befreit und daher nach § 53 Absatz 1<br/>Satz 1 KrWG nur anzeigepflichtig:</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="91%"/>
						</colgroup>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorOeReEnt'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als öffentlich-rechtlicher Entsorgungsträger (§ 54 Absatz 3 Nummer 1 KrWG),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.2</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:GrundEFB/abf:IndicatorEFB'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als für die angezeigte Tätigkeit zertifizierter Entsorgungsfachbetrieb (§ 54 Absatz 3 Nummer 2 KrWG),</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="88%"/>
						</colgroup>
						<tr>
							<td/>
							<td/>
							<td id="Titel_klein">4.2.2.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:GrundEFB/abf:IndicatorEFBZertifikatBeigefuegt'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Zertifikat ist beigefügt</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="91%"/>
						</colgroup>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.3</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorElektroG'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler, Beförderer, Händler und Makler von Elektro- und Elektronikaltgeräten im Rahmen<br/>der Durchführung des Elektro- und Elektronikgerätegesetzes (§ 2 Absatz 3 Satz 1 ElektroG),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.4</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorBattG'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler, Beförderer, Händler und Makler von Altbatterien im Rahmen der Durchführung des<br/>Batteriegesetzes (§ 1 Absatz 3 Satz 1 BattG),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.5</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorWirtschTaetigkeit'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler, Beförderer, Händler und Makler von gefährlichen Abfällen, der im Rahmen<br/>wirtschaftlicher Unternehmen tätig ist (§ 12 Absatz 1 Nummer 1 AbfAEV),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.6</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorRuecknahme'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler, Beförderer, Händler und Makler von gefährlichen Abfällen, der solche Abfälle<br/>sammelt, befördert, mit diesen handelt oder diese makelt, die von einem Hersteller oder Vertreiber freiwillig oder auf Grund<br/>einer Rechtsverordnung zurückgenommen werden (§ 12 Absatz 1 Nummer 2 AbfAEV),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.7</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorAltfahrzeugV'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler, Beförderer, Händler und Makler von Altfahrzeugen im Rahmen ihrer Überlassung<br/>nach § 4 Absatz 1 bis 3 der Altfahrzeug-Verordnung (§ 12 Absatz 1 Nummer 3 AbfAEV),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.8</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:GrundEMAS/abf:IndicatorEMAS'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als für die angezeigte Tätigkeit zertifizierter EMAS-Betrieb (§ 12 Absatz 1 Nummer 4 AbfAEV),</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="88%"/>
						</colgroup>
						<tr>
							<td/>
							<td/>
							<td id="Titel_klein">4.2.8.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:GrundEMAS/abf:IndicatorEMASZertifikatBeigefuegt'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Registrierungsurkunde ist beigefügt</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="3%"/>
							<col width="91%"/>
						</colgroup>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.9</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorSeeschifffahrt'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als Sammler und Beförderer von gefährlichen Abfällen, der die Abfälle mittels Seeschiffen<br/>sammelt oder befördert (§ 12 Absatz 1 Nummer 5 AbfAEV),</td>
						</tr>
						<tr>
							<td/>
							<td id="Titel_klein">4.2.10</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:BefreiungErlaubnispflicht/abf:GrundBefreiungErlaubnis/abf:IndicatorKurier'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">auf Grund der Eigenschaft als  Sammler und Beförderer von gefährlichen Abfällen, der im Rahmen von Paket-, Express- und<br/>Kurierdiensten Abfälle sammelt oder befördert (§ 12 Absatz 1 Nummer 6 AbfAEV).</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">5</td>
				<td id="Titel">Betriebsinhaber</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.1</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.2</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Weiterer Betriebsinhaber (sofern vorhanden)</td>
							<td id="Titel_klein"></td>
						</tr>
						<tr>
							<td id="Titel_klein">5.3</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.4</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	
	</xsl:template>

	<xsl:template name="Zeile6">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">6</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person'"/>
					</font>
					&#173;
					<font id="Titel_winzig">
						<xsl:value-of select="'(sofern nicht mit dem Betriebsinhaber identisch)'"/>
					</font>
				</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">6.1</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">6.2</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<table id="Tabelle" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="97%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Weitere für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person (sofern vorhanden)</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">6.3</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">6.4</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile7">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel">7</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Frei für Vermerke des Anzeigenden'"/>
					</font>
					&#173;
					<font id="Titel_klein">
						<xsl:value-of select="'(Angaben freiwillig)'"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">7.1</td>
				<td height="200">
					<font id="Aktuell">
						<xsl:value-of select="abf:Vermerke"/>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile8">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel">8</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Versicherung und Unterschift'"/>
					</font>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">8.1</td>
				<td>
					<font id="Titel_klein">Es wird versichert, dass</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="1%" valign="top"/>
				<col width="96%" valign="top"/>
			</colgroup>
			<tr>
				<td/>
				<td id="Titel_klein">-</td>
				<td>
					<font id="Titel_klein">die Anzeige nach bestem Wissen ausgefüllt und unter dem unten genannten Datum an die zuständige Behörde übersandt wurde,</font>
				</td>
			</tr>
			<tr>
				<td/>
				<td id="Titel_klein">-</td>
				<td>
					<font id="Titel_klein">bei der Tätigkeit des Sammelns, Beförderns, Handelns oder Makelns von Abfällen alle einschlägigen Vorschriften, insbesondere die<br/>Vorgaben des Kreislaufwirtschaftsgesetzes und der auf Grund dieses Gesetzes ergangenen Rechtsverordnungen, eingehalten werden,</font>
				</td>
			</tr>
			<tr>
				<td/>
				<td id="Titel_klein">-</td>
				<td>
					<font id="Titel_klein">die Anforderungen an Sammler, Beförderer, Händler und Makler von Abfällen nach Abschnitt 2 der Anzeige- und Erlaubnisverordnung<br/>eingehalten werden.</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="47%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">8.2</td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Versicherung/abf:Ort"/>
				</td>
				<td/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Versicherung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td/>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile9">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel">9</td>
				<td>
					<font id="Titel">Bestätigung des Eingangs der vollständigen Anzeige</font>
					&#173;
					<font id="Titel_klein">(von der Behörde auszufüllen)</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Anzeigender</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Bestätigende Behörde</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_2"/>
				</td>
				<td id="Titel"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_2"/>
					<xsl:if test="string-length(abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Name)>0">
						<br/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Name"/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Telefon"/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:EMail"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">Vorgangsnummer:</font>
					&#173;&#173;
					<font id="Aktuell">
						<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
						&#173;
						<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein">9.1</td>
				<td id="Titel_klein">Hiermit wird der Eingang der vollständigen Anzeige bestätigt.</td>
				<td id="Aktuell">&#173;</td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Titel_klein">9.2</td>
				<td id="Titel_klein">Es wird folgende Sammlernummer nach § 28 NachwV erteilt:</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">9.3</td>
				<td id="Titel_klein">Es wird folgende Beförderernummer nach § 28 NachwV erteilt:</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">9.4</td>
				<td id="Titel_klein">Es wird folgende Händlernummer nach § 28 NachwV erteilt:</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">9.5</td>
				<td id="Titel_klein">Es wird folgende Maklernummer nach § 28 NachwV erteilt:</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">9.6</td>
				<td id="Titel_klein">Frei für Vermerke der Behörde</td>
				<td id="Aktuell">&#173;</td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:choose>
				<xsl:when test="count(abf:Eingangsbestaetigung/abf:Hinweis)>0">
					<xsl:variable name="ZEICHEN_HW">
							<xsl:for-each select="abf:Eingangsbestaetigung/abf:Hinweis">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($ZEICHEN_HW)>$MAX_ZEICHEN_MEMO">
							<tr>
								<td id="Titel"></td>
								<td height="450" id="Aktuell">siehe Beiblatt
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td id="Titel"></td>
								<td height="450">
									<font id="Aktuell_klein">
										<xsl:for-each select="abf:Eingangsbestaetigung/abf:Hinweis">
											<xsl:value-of select="abf:Textbaustein"/>
											<br/>
										</xsl:for-each>
									</font>
								</td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="450"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">9.7</td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Ort"/>
				</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Name"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile10">
		<table id="Tabelle" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel">10</td>
				<td id="Titel">Hinweise</td>
				<td/>
			</tr>
			<tr>
				<td id="Titel_klein">10.1</td>
				<td id="Titel_klein">Je nach Landesrecht ist die behördliche Bestätigung des Eingangs der vollständigen Anzeige gebührenpflichtig. Ist dies der Fall, ergeht ein<br/>gesonderter Gebührenbescheid.</td>
			</tr>
			<tr>
				<td id="Titel_klein">10.2</td>
				<td id="Titel_klein">Sammler und Beförderer von Abfällen haben bei Ausübung ihrer Tätigkeit eine Kopie oder einen Ausdruck dieser von der Behörde bestätigten<br/>Anzeige mitzuführen, soweit sie nicht von der Mitführungspflicht befreit sind. Sofern die Behörde die Anzeige noch nicht bestätigt hat, ist dies<br/>von dem Anzeigenden auf der Kopie oder dem Ausdruck der Anzeige zu vermerken. In diesem Fall ist die mit dem Vermerk versehene Kopie<br/>oder der mit dem Vermerk versehene Ausdruck der Anzeige mitzuführen. Entsorgungsfachbetriebe haben zusätzlich eine Kopie des jeweils<br/>gültigen Zertifikats mitzuführen. EMAS-Betriebe haben zusätzlich eine Kopie der jeweils gültigen Registrierungsurkunde mitzuführen.</td>
			</tr>
			<tr>
				<td id="Titel_klein">10.3</td>
				<td id="Titel_klein">Ändern sich wesentliche Angaben, so ist die Anzeige erneut zu erstatten. Wesentliche Angaben sind die Felder 1.1 bis 1.4 und 2 bis 6.</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="ZeileNF">
		<table id="Tabelle" width="100%">
			<tr>
				<td>
					<font id="Nummer">Aufforderung zur Ergänzung der Angaben der Anzeige<br/>bzw. der beizufügenden Unterlagen</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Anzeigender</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Zuständige Behörde</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_2"/>
				</td>
				<td id="Titel"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_2"/>
					<xsl:if test="string-length(abf:Nachforderung/abf:Behoerde/abf:Ansprechpartner/kop:Name)>0">
						<br/>
						<br/>
						<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Ansprechpartner/kop:Name"/>
						<br/>
						<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Ansprechpartner/kop:Telefon"/>
						<br/>
						<xsl:value-of select="abf:Nachforderung/abf:Behoerde/abf:Ansprechpartner/kop:EMail"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">Vorgangsnummer:</font>
					&#173;&#173;
					<font id="Aktuell">
						<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
						&#173;
						<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="40%"/>
				<col width="10%"/>
				<col width="20%"/>
				<col width="10%"/>
				<col width="17%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ihre Anzeige Ihrer abfallwirtschaftlichen Tätigkeit vom</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Versicherung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">ist hier am</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Verwaltungsinformationen/abf:Eingangsdatum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">eingegangen.</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Allerdings sind die Anzeige bzw. die beizufügenden Unterlagen nicht vollständig / enthalten in sich widersprüchliche Angaben.</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Folgende Angaben bzw. beizufügenden Unterlagen fehlen / sind widersprüchlich:</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="15%" valign="top"/>
				<col width="82%" valign="top"/>
			</colgroup>
			<xsl:choose>
				<xsl:when test="count(abf:Nachforderung/abf:Mangel)>0">
					<xsl:for-each select="abf:Nachforderung/abf:Mangel">
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Code / Bezeichnung:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="concat(position(),'. ',abf:Kurz)"/>.
							</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Mangel, Hinweis / Begründung:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="abf:Begruendung"/>.
							</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Abhilfe / Erläuterung:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="abf:Erlaeuterung"/>.
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="500"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Senden Sie mir die ergänzte bzw. korrigierte Anzeige und ggf. die ergänzten bzw. korrigierten beizufügenden Unterlagen unter Angabe der oben</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="10%"/>
				<col width="57%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">genannten Vorgangsnummer bis zum</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Nachforderung/abf:Frist"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">zu.</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ich weise darauf hin, dass die Ausübung der angezeigten Tätigkeit nach § 69 Absatz 2 Nummer 1 KrWG eine Ordnungswidrigkeit darstellt,<br/>solange die Anzeige noch nicht vollständig erstattet ist.</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="47%"/>
				<col width="3%"/>
				<col width="47%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Nachforderung/abf:Bestaetigung/abf:Ort"/>
				</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Nachforderung/abf:Bestaetigung/abf:Name"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Nachforderung/abf:Bestaetigung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<tbody>
				<tr>
					<th></th>
				</tr>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="ZeileBeiblatt">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Beiblatt Nebenbestimmungen und Begründungen</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:if test="count(abf:BedingungenAuflagen/abf:Nebenbestimmungen)>0">
				<xsl:variable name="ZEICHEN_NB">
						<xsl:for-each select="abf:BedingungenAuflagen/abf:Nebenbestimmungen">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
						<xsl:for-each select="abf:BedingungenAuflagen/abf:Begruendungen">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
				</xsl:variable>
				<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
					<tr>
						<td id="Titel_klein"></td>
						<td id="Titel_klein">Nebenbestimmungen:</td>
					</tr>
					<tr>
						<td id="Titel"></td>
						<td id="Aktuell_klein">
							<xsl:for-each select="abf:BedingungenAuflagen/abf:Nebenbestimmungen">
								<xsl:value-of select="@kop:Index"/>.
								&#173;
								<xsl:value-of select="abf:Textbaustein"/>
								<br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:if test="count(abf:BedingungenAuflagen/abf:Begruendungen)>0">
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Begründungen:</td>
						</tr>
						<tr>
							<td id="Titel"></td>
							<td id="Aktuell_klein">
								<xsl:for-each select="abf:BedingungenAuflagen/abf:Begruendungen">
									<font id="Aktuell_klein">
										<xsl:value-of select="@kop:Index"/>.
									</font>
									&#173;
									<font id="Titel_klein">
										<xsl:if test="abf:ZuNB"> zu Nebenbestimmung </xsl:if>
									</font>
									<font id="Aktuell_klein">
										<xsl:value-of select="abf:ZuNB"/>: <xsl:value-of select="abf:Textbaustein"/>
									</font>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="ZeileHinweise">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Beiblatt Vermerke der Behörde</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:if test="count(abf:Eingangsbestaetigung/abf:Hinweis)>0">
				<tr>
					<td id="Titel"></td>
					<td id="Aktuell_klein">
						<xsl:for-each select="abf:Eingangsbestaetigung/abf:Hinweis">
							<xsl:value-of select="abf:Textbaustein"/>
							<br/>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!--xsl:template name="ZeileGemeinde">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Informationen zur Gemeinde</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="67%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Gemeindeschlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/abf:Gemeindeschluessel"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/abf:Gemeindename"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td height="15"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">1.5 Für Anzeigende, die keinen Hauptsitz im Inland haben: Ort der erstmaligen Sammler-, Beförderer-, Händler- oder Maklertätigkeit</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="67%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Gemeindeschlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Gemeindeschluessel"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/abf:ErsteTaetigkeit/abf:Gemeindename"/>
				</td>
			</tr>
		</table>
	</xsl:template-->
	
	<xsl:template name="ZeileMore">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Bedingungen, Auflagen</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Anzeigender</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ausstellende Behörde</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Anzeigender/kop:Adresse/kop:Ort_2"/>
				</td>
				<td id="Titel"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_2"/>
					<xsl:if test="string-length(abf:BedingungenAuflagen/abf:Behoerde/abf:Ansprechpartner/kop:Name)>0">
						<br/>
						<br/>
						<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Ansprechpartner/kop:Name"/>
						<br/>
						<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Ansprechpartner/kop:Telefon"/>
						<br/>
						<xsl:value-of select="abf:BedingungenAuflagen/abf:Behoerde/abf:Ansprechpartner/kop:EMail"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">Vorgangsnummer:</font>
					&#173;&#173;
					<font id="Aktuell">
						<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
						&#173;
						<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="15%"/>
				<col width="26%"/>
				<col width="26%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Zulässigkeit der Tätigkeit befristet von</td>
				<td id="Titel_klein">bis</td>
				<td id="Titel_klein">Tätigkeit untersagt ab</td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:BedingungenAuflagen/abf:Befristung/abf:GueltigVon"/>
					</xsl:call-template>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:BedingungenAuflagen/abf:Befristung/abf:GueltigBis"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:BedingungenAuflagen/abf:Befristung/abf:Widerruf"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Rechtsbehelfsbelehrung</td>
			</tr>
			<tr>
				<td id="Titel"></td>
				<td height="150">
					<font id="Aktuell_klein">
						<xsl:value-of select="abf:BedingungenAuflagen/abf:Rechtsbehelf"/>
					</font>
				</td>
			</tr>
<!-- 			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Nebenbestimmungen und Begründungen</td>
			</tr>
 -->			<xsl:choose>
				<xsl:when test="count(abf:BedingungenAuflagen/abf:Nebenbestimmungen)>0">
					<xsl:variable name="ZEICHEN_NB">
							<xsl:for-each select="abf:BedingungenAuflagen/abf:Nebenbestimmungen">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
							<xsl:for-each select="abf:BedingungenAuflagen/abf:Begruendungen">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
					</xsl:variable>
					<xsl:message>Zeichen NB: 
						<xsl:value-of select="string-length($ZEICHEN_NB)"/>
					</xsl:message>
					<xsl:choose>
						<xsl:when test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
							<tr>
								<td id="Titel"></td>
								<td height="450" id="Aktuell">siehe Beiblatt
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td id="Titel"></td>
								<td height="450">
									<font id="Titel_klein"> Nebenbestimmungen:</font><br/>
									<font id="Aktuell_klein">
										<xsl:for-each select="abf:BedingungenAuflagen/abf:Nebenbestimmungen">
											<xsl:value-of select="@kop:Index"/>.
											&#173;
											<xsl:value-of select="abf:Textbaustein"/>
											<br/>
										</xsl:for-each>
									</font>
									<font id="Titel_klein"> Begründungen:</font><br/>
									<xsl:for-each select="abf:BedingungenAuflagen/abf:Begruendungen">
										<font id="Aktuell_klein">
											<xsl:value-of select="@kop:Index"/>.
										</font>
										&#173;
										<font id="Titel_klein">
											<xsl:if test="abf:ZuNB"> zu Nebenbestimmung </xsl:if>
										</font>
										<font id="Aktuell_klein">
											<xsl:value-of select="abf:ZuNB"/>: <xsl:value-of select="abf:Textbaustein"/>
										</font>
										<br/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="450"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>		
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="47%"/>
				<col width="3%"/>
				<col width="47%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Bestaetigung/abf:Ort"/>
				</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BedingungenAuflagen/abf:Bestaetigung/abf:Name"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:BedingungenAuflagen/abf:Bestaetigung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<tbody>
				<tr>
					<th></th>
				</tr>
			</tbody>
		</table>
	</xsl:template>

	<xsl:template name="ZeilePerson">
		<xsl:if test="count(abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true'])>2">
			<table id="Tabelle_nicht_unten" width="100%">
				<colgroup>
					<col width="3%"/>
					<col width="90%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<td id="Titel"></td>
					<td id="Titel">Weiterer Betriebsinhaber</td>
					<td/>
				</tr>
			</table>
			<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
				<xsl:if test="position()>2">
					<xsl:call-template name="ONE_PERSON"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="count(abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')])>2">
				<table id="Tabelle_nicht_unten" width="100%">
					<colgroup>
						<col width="3%"/>
						<col width="90%"/>
						<col width="10%"/>
					</colgroup>
					<tr>
						<td id="Titel"></td>
						<td id="Titel">Weitere für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person</td>
						<td/>
					</tr>
				</table>
				<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
					<xsl:if test="position()>2">
						<xsl:call-template name="ONE_PERSON"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table id="Tabelle_nicht_oben" width="100%">
					<tbody>
						<tr>
							<th></th>
						</tr>
					</tbody>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template name="ONE_PERSON">
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Name"/>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Vorname"/>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="abf:Geburtsdatum"/>
								</xsl:call-template>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Geburtsort1"/>
								&#173;
								<xsl:value-of select="abf:Geburtsort2"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
