<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:entst="uri:EntsorgerStammdaten/EntStamm"
	xmlns:eslib="uri:EntsorgerStammdaten/EntStammTypBibliothek"
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//entst:Entsorger">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Entsorger</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileMain"/>
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileMain">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Verwaltung"/>
					<xsl:call-template name="Betrieb"/>
					<xsl:call-template name="ZustBehoerde"/>
					<xsl:call-template name="WeiteresBetrieb"/>
					<xsl:call-template name="PersonenBetrieb"/>
					<xsl:call-template name="Details"/>
					<xsl:call-template name="Teilanlage"/>
					<xsl:call-template name="EndeBetrieb"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<xsl:call-template name="FkbZuBetrieb"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Verwaltung">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Nummer">Entsorger</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Verwaltungsinformationen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="30%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Gestrichen</td>
				<td id="Titel_klein">Streichgrund</td>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:Gestrichen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Streichgrund"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Aktenzeichen"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<font id="Titel_klein">Notizen</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="entst:EntsorgerBetrieb/entst:Bemerkungen"/>
						&#173;
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Betrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Betriebsstätte</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="40%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Entsorgernummer</td>
				<td id="Titel_klein">Arbeitsstättennummer</td>
				<td id="Titel_klein">Registriernummer im Heimatland</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:BehoerdlicheNummer/eslib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:BehoerdlicheNummer/eslib:Pruefziffer"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:ArbeitsstaettenNummer"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:RegistriernummerHeimatland"/>
				</td>
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="'entst:EntsorgerBetrieb/entst:'"/>
			<xsl:with-param name="prefixLib" select="'eslib:'"/>
		</xsl:call-template>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Gemeindeschluessel"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Gemeindename"/>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">East-Wert</td>
				<td id="Titel_klein">North-Wert</td>
				<td id="Titel_klein">Rechtswert</td>
				<td id="Titel_klein">Hochwert</td>
				<td id="Titel_klein">TK 25</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Koordinaten/entst:East"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Koordinaten/entst:North"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Koordinaten/entst:Rechts"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Koordinaten/entst:Hoch"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:Koordinaten/entst:TK25"/>
				</td>
			</tr>
		</table>

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="'entst:EntsorgerBetrieb/entst:Kontaktdaten/eslib:'"/>
		</xsl:call-template>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:InternetAdresse"/>
					&#173;
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="ZustBehoerde">
		<xsl:if test="count(entst:EntsorgerBetrieb/entst:ZustBehoerden)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Zuständige Behörden</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:EntsorgerBetrieb/entst:ZustBehoerden">
				<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="ZustBehoerdeBtr">
					<xsl:with-param name="prefix" select="'entst:'"/>
					<xsl:with-param name="prefixLib" select="'eslib:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="WeiteresBetrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Eigenschaften</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Sekundärerzeuger</td>
				<td id="Titel_klein">Sekundärerzeugernr.</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:Sekundaererzeuger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:SekErzNummer/eslib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:SekErzNummer/eslib:Pruefziffer"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Nummernkreis für Nachweisnummer</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:NummernkreisNWNr"/>
					&#173;
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="75%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">unterliegt IED-RL</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:IED-RL'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="10%"/>
				<col width="20%"/>
				<col width="45%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">nach PRTR-V berichtspflichtig</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:PRTRVBerichtspflichtig'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">Entsorgungsfachbetrieb</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:Entsorgungsfachbetrieb'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="75%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">betreibt BImSchV-Anlagen</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:BImSchVAnlagen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>	
			</tr>
			<tr>
				<td id="Titel_klein">Gebührenbefreit</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:Gebuehrenbefreit'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>	
			</tr>
			<tr>
				<td id="Titel_klein">Kommunikation per E-Mail</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:EntsorgerBetrieb/entst:EntsorgerEigenschaften/entst:BGSFehlerSchrPerEMail'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>
		<xsl:if test="count(entst:EntsorgerBetrieb/entst:Branchen)>0 or string-length(entst:EntsorgerBetrieb/entst:BrancheText)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Branchen</font>
					</td>
				</tr>
				<xsl:if test="string-length(entst:EntsorgerBetrieb/entst:BrancheText)>0">
					<tr>
						<td>
							<font id="Titel_klein">Beschreibung der Branche</font>
						</td>
					</tr>
					<td id="Aktuell">
						<xsl:value-of select="entst:EntsorgerBetrieb/entst:BrancheText"/>
					</td>
				</xsl:if>
			</table>
			<xsl:for-each select="entst:EntsorgerBetrieb/entst:Branchen">
				<xsl:call-template name="BrancheBtr">
					<xsl:with-param name="prefix" select="'entst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="PersonenBetrieb">
		<xsl:if test="count(entst:EntsorgerBetrieb/entst:Ansprechpartner)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Personen zu Entsorger</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:EntsorgerBetrieb/entst:Ansprechpartner">
				<xsl:call-template name="PersonBtr">
					<xsl:with-param name="prefix" select="'entst:'"/>
					<xsl:with-param name="prefixLib" select="'eslib:'"/>
					<xsl:with-param name="verantwortPerson" select="true()"/>
					<xsl:with-param name="ba" select="true()"/>
					<xsl:with-param name="fachkunde" select="true()"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Teilanlage">
		<xsl:variable name="CNT_TA" select="count(entst:EntsorgerBetrieb/entst:Teilanlagen)"/>
		<xsl:if test="$CNT_TA>0">
			<xsl:for-each select="entst:EntsorgerBetrieb/entst:Teilanlagen">
				<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Teilanlage</font>
							&#173;
							<font id="Titel_klein">(</font>
							<font id="Aktuell">
								<xsl:value-of select="position()"/>
							</font>
							&#173;
							<font id="Titel_klein">von</font>
							&#173;
							<font id="Aktuell">
								<xsl:value-of select="$CNT_TA"/>
							</font>
							<font id="Titel_klein">)</font>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="20%"/>
						<col width="20%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">lfd. Nr.</td>
						<td id="Titel_klein">genehmigt von</td>
						<td id="Titel_klein">bis</td>
						<td id="Titel_klein">Aktenzeichen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:LfdNr"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:GenehmigtVon'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:GenehmigtBis'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Aktenzeichen"/>
						</td>
					</tr>
				</table>
				<!--table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">lfd. Nr.</td>
						<td id="Titel_klein">Aktenzeichen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:LfdNr"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Aktenzeichen"/>
						</td>
					</tr>
				</table-->
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="40%"/>
						<col width="20%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Immissionsschutzrechtliche Arbeitsstättennummer</td>
						<td id="Titel_klein">Anlagennummer</td>
						<td id="Titel_klein">Wasserwirtschaftliche Kennnummer</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:ArbeitsstaettenNummer"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Anlagennummer"/>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:WasserwirtschaftNummer"/>
						</td>
					</tr>
				</table>
				<xsl:variable name="TA_KEY">
					<xsl:value-of select="normalize-space(concat(entst:LfdNr, ' - ', entst:Bezeichnung1, ' ', entst:Bezeichnung2))"/>
				</xsl:variable>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bezeichnung</td>
						<td id="Titel_klein"></td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bezeichnung1"/>
							&#173;
							<xsl:value-of select="entst:Bezeichnung2"/>
						</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bezeichnung3"/>
								&#173;
							<xsl:value-of select="entst:Bezeichnung4"/>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Sekundäranfallstelle</td>
						<td id="Titel_klein">Sekundärerzeugernummer</td>
					</tr>
					<tr>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:Sekundaeranfallstelle'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
						<td id="Aktuell">
							<xsl:value-of select="entst:TeilanlageEigenschaften/entst:SekErzNummer/eslib:BehoerdlicheNr"/>
							&#173;
							<xsl:value-of select="entst:TeilanlageEigenschaften/entst:SekErzNummer/eslib:Pruefziffer"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Freistellungsnummer</td>
						<td id="Titel_klein"></td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:TeilanlageEigenschaften/entst:Freistellungsnummer/eslib:FreistellungsNr"/>
							&#173;
							<xsl:value-of select="entst:TeilanlageEigenschaften/entst:Freistellungsnummer/eslib:Pruefziffer"/>
						</td>
						<td/>
					</tr>
					<tr>
						<td id="Titel_klein">nach PRTR-V berichtspflichtig</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:PRTRVBerichtspflichtig'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bemerkungen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bemerkung"/>
							&#173;
						</td>
					</tr>
					<tr>
						<td id="Titel">Genehmigung</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="20%"/>
						<col width="60%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">in Planung seit</td>
						<td id="Titel_klein">Genehmigungsdatum</td>
						<td id="Titel_klein">letzte Genehmigungsänderung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:InPlanungSeit'"/>
							</xsl:call-template>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:DatumGenehmigung'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:DatumGenLetzAend'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>				
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Rechtsgrundlage</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:ZulGenRechtsgrund/entst:Rechtsgrund"/>
							&#173;
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Bemerkungen Rechtsgrundlage</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:ZulGenRechtsgrund/entst:Rechtsgrundlage"/>
							&#173;
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="13%"/>
						<col width="20%"/>
						<col width="13%"/>
						<col width="20%"/>
						<col width="13%"/>
						<col width="21%"/>
					</colgroup>
					<tr>
						<td id="Titel">Betrieb</td>
						<td id="Titel"></td>
						<td id="Titel">Stilllegung</td>
						<td id="Titel"></td>
						<td id="Titel">Nachsorge</td>
						<td id="Titel"></td>
					</tr>
					<tr>
						<td id="Titel_klein">von</td>
						<td id="Titel_klein">bis</td>
						<td id="Titel_klein">begonnen</td>
						<td id="Titel_klein">abgeschlossen</td>
						<td id="Titel_klein">begonnen</td>
						<td id="Titel_klein">abgeschlossen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:Betriebsbeginn'"/>
							</xsl:call-template>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:Betriebsende'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:StilllegungBeginn'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:StilllegungEnde'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:NachsorgeBeginn'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:ZulGenRechtsgrund/entst:NachsorgeEnde'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>				
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel">Anlagenkategorie</td>
					</tr>
				</table>
				<table id="tabelle_nicht_oben_unten" width="100%">
					<colgroup>
						<col width="30%"/>
						<col width="18%"/>
						<col width="15%"/>
						<col width="15%"/>
						<col width="22%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Chemisch-/ physikalische Behandlung</td>
						<td id="Titel_klein">Thermische Behandlung</td>
						<td id="Titel_klein">oberirdische Deponie</td>
						<td id="Titel_klein">Untertagedeponie</td>
						<td id="Titel_klein">sonstige Entsorgungsverfahren</td>
					</tr>
					<tr>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:IndicatorCPB'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>							
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:IndicatorTherm'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:IndicatorODep'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:IndicatorUDep'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:TeilanlageEigenschaften/entst:IndicatorSonst'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
					</tr>
				</table>
				
				<xsl:call-template name="Anlagentypen">
					<xsl:with-param name="TA_KEY" select="$TA_KEY"/>
				</xsl:call-template>
				
				<xsl:call-template name="RD">
					<xsl:with-param name="TA_KEY" select="$TA_KEY"/>
				</xsl:call-template>

				<xsl:if test="count(entst:BImSchVNummern)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Nummer 4. BImSchV zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:BImSchVNummern">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="BImSchV">
							<xsl:with-param name="prefix" select="'entst:'"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
				
				<xsl:call-template name="Flur">
					<xsl:with-param name="TA_KEY" select="$TA_KEY"/>
				</xsl:call-template>

				<xsl:if test="count(entst:Grenzwerte)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Grenzwerte zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Grenzwerte">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Grenzwert"/>
					</xsl:for-each>
				</xsl:if>

				<xsl:if test="count(entst:Beschraenkungen)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Beschränkungen zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Beschraenkungen">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Beschraenkung"/>
					</xsl:for-each>
				</xsl:if>
				
				<xsl:if test="count(entst:Annahmekriterium)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Annahmekriterien zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Annahmekriterium">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Annahmekrit"/>
					</xsl:for-each>				
				</xsl:if>
				
				<xsl:call-template name="Annahmeunters">
					<xsl:with-param name="TA_KEY" select="$TA_KEY"/>
				</xsl:call-template>

				<xsl:if test="count(entst:Detailangaben)>0">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Detailangaben zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Detailangaben">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Detailangabe">
							<xsl:with-param name="prefix" select="'entst:'"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
				
				<xsl:call-template name="Abfallgruppe">
					<xsl:with-param name="TA_KEY" select="$TA_KEY"/>
				</xsl:call-template>

			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Anlagentypen">
		<xsl:param name="TA_KEY"/>
		<xsl:if test="count(entst:Anlagentypen)">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Anlagentypen zu Teilanlage:</font>
						&#173;
						<font id="Aktuell">
							<xsl:value-of select="$TA_KEY"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:Anlagentypen">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="60%"/>
						<col width="20%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Code</td>
						<td id="Titel_klein">Bezeichnung</td>
						<td id="Titel_klein">Bestimmender Anlagentyp</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:AnlaTypCode"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:AnlaTypBezeichung"/>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:IndicatorBestimmend'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
					</tr>
				</table>				
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="RD">
		<xsl:param name="TA_KEY"/>
		<xsl:if test="count(entst:RDVerfahren)">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">RD-Verfahren zu Teilanlage:</font>
						&#173;
						<font id="Aktuell">
							<xsl:value-of select="$TA_KEY"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:RDVerfahren">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Code</td>
						<td id="Titel_klein">Bestimmendes Verfahren</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:RDCode"/>
							&#173;
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:IndicatorBestimmend'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Kapazität</td>
						<td id="Titel_klein">Einheit</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="formatDouble">
								<xsl:with-param name="wert" select="entst:Kapazitaet"></xsl:with-param>
							</xsl:call-template>
							<!--xsl:value-of select="entst:Kapazitaet"/-->
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Einheit"/>
						</td>
					</tr>
				</table>				
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Notizen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Notizen"/>
							&#173;
						</td>
					</tr>
				</table>				
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Flur">
		<xsl:param name="TA_KEY"/>
		<xsl:if test="count(entst:Flurstueck)">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Flurstücke zu Teilanlage:</font>
						&#173;
						<font id="Aktuell">
							<xsl:value-of select="$TA_KEY"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:Flurstueck">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Bundesland</td>
						<td id="Titel_klein">Nr Topo Karte</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bundesland"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:NrTopoKarte"/>
						</td>
					</tr>
				</table>

				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Gemarkung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Gemarkung"/>
							&#173;
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Flur</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Flur"/>
							&#173;
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Flurstück</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Flurstueck"/>
							&#173;
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Bezeichnung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bezeichnung"/>
							&#173;
						</td>
					</tr>
				</table>				
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Grenzwert">
		<xsl:call-template name="TableOneDashLine"/>

		<!--table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:LfdNr"/>
					&#173;
				</td>
			</tr>
		</table-->				
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Gültig von</td>
				<td id="Titel_klein">bis</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:LfdNr"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:call-template name="getDateValue">
						<xsl:with-param name="TagName" select="'entst:GWGueltigVon'"/>
					</xsl:call-template>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:call-template name="getDateValue">
						<xsl:with-param name="TagName" select="'entst:GWGueltigBis'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>												
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="60%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Code</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Eluat</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:GWCode"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:GWName"/>
				</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Eluat'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>				
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Vorzeichen</td>
				<td id="Titel_klein">Zugelassener Wert</td>
				<td id="Titel_klein">Einheit</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:GWVorzeichen"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDouble">
						<xsl:with-param name="wert" select="entst:Wert"></xsl:with-param>
					</xsl:call-template>
					<!--xsl:value-of select="entst:Wert"/-->
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Einheit"/>
				</td>
			</tr>
		</table>			
		<table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td id="Titel_klein">Bemerkung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Bemerkung"/>
					&#173;
				</td>
			</tr>
		</table>				
	</xsl:template>

	<xsl:template name="Beschraenkung">
		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Technik</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:LfdNr"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Technik"/>
				</td>
			</tr>
		</table>				
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Leistungsgröße</td>
				<td id="Titel_klein">Vorzeichen</td>
				<td id="Titel_klein">Zugelassener Wert</td>
				<td id="Titel_klein">Einheit</td>
				<td id="Titel_klein">Bezugsgröße</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Leistungsgroesse"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Vorzeichen"/>
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDouble">
						<xsl:with-param name="wert" select="entst:Wert"></xsl:with-param>
					</xsl:call-template>
					<!--xsl:value-of select="entst:Wert"/-->
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Einheit"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Bezugsgroesse"/>
				</td>
			</tr>
		</table>			
		<table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td id="Titel_klein">Bemerkung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Bemerkung"/>
					&#173;
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Annahmekrit">
		<xsl:call-template name="TableOneDashLine"/>

		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">lfd. Nr.</td>
				<td id="Titel_klein">Kriterium</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:LfdNr"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Kriterium"/>
				</td>
			</tr>
		</table>				
		<table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td id="Titel_klein">Festlegung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Festlegung"/>
					&#173;
				</td>
			</tr>
		</table>				
	</xsl:template>

	<xsl:template name="Annahmeunters">
		<xsl:param name="TA_KEY"/>
		<xsl:if test="count(entst:Annahmeuntersagung)">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Annahmeuntersagungen zu Teilanlage:</font>
						&#173;
						<font id="Aktuell">
							<xsl:value-of select="$TA_KEY"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:Annahmeuntersagung">
				<xsl:call-template name="TableOneDashLine"/>

				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Annahmestop von</td>
						<td id="Titel_klein">bis</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:AnnahmestopVon'"/>
							</xsl:call-template>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:AnnahmestopBis'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>												

				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="60%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Aktenzeichen</td>
						<td id="Titel_klein">ausgesprochen am</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Aktenzeichen"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:AusgesprochenAm'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>												
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">alle Abfälle</td>
						<td id="Titel_klein">Schlüssel</td>
					</tr>
					<tr>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'entst:AlleAbfaelle'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
						<td id="Aktuell">
							<xsl:value-of select="entst:Abfallschluessel"/>
						</td>
					</tr>
				</table>				
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bemerkung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bemerkungen"/>
							&#173;
						</td>
					</tr>
				</table>				
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Details">
		<xsl:if test="count(entst:EntsorgerBetrieb/entst:Detailangaben)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Detailangaben zu Entsorger</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="entst:EntsorgerBetrieb/entst:Detailangaben">
				<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="Detailangabe">
					<xsl:with-param name="prefix" select="'entst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Abfallgruppe">
		<xsl:param name="TA_KEY" select="1"/>
		<xsl:variable name="CNT_GR" select="count(entst:Abfallgruppen)"/>
		<xsl:if test="$CNT_GR>0">
			<xsl:for-each select="entst:Abfallgruppen">
				<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
				<table width="100%" id="tabelle_nicht_unten">
					<tr>
						<td>
							<font id="Titel">Abfallgruppe</font>
							&#173;
							<font id="Titel_klein">(</font>
							<font id="Aktuell">
								<xsl:value-of select="position()"/>
							</font>
							&#173;
							<font id="Titel_klein">von</font>
							&#173;
							<font id="Aktuell">
								<xsl:value-of select="$CNT_GR"/>
							</font>
							<font id="Titel">) zu Teilanlage:</font>
							&#173;
							<font id="Aktuell">
								<xsl:value-of select="$TA_KEY"/>
							</font>
						</td>
					</tr>					
				</table>	
				<xsl:variable name="ABFGR_KEY">
					<xsl:value-of select="concat(entst:LfdNr,' - ',entst:Bezeichung)"/>
				</xsl:variable>			
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="40%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">lfd. Nr.</td>
						<td id="Titel_klein">Bezeichnung</td>
						<td id="Titel_klein">Aktenzeichen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:LfdNr"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bezeichung"/>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="entst:Aktenzeichen"/>
						</td>
					</tr>
				</table>				
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Genehmigungsdatum</td>
						<td id="Titel_klein">letzte Änderung am</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:DatumGenehmigung'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:DatumGenLetztAend'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Zugelassen ab</td>
						<td id="Titel_klein">bis</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:DatumZulassungAb'"/>
							</xsl:call-template>
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'entst:DatumZulassungBis'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>												
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bemerkung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="entst:Bemerkung"/>
							&#173;
						</td>
					</tr>
				</table>
				<xsl:if test="count(entst:Abfall)>0">
					<table width="100%" id="tabelle_nicht_unten">
						<tr>
							<td>
								<font id="Titel">Abfälle zu Abfallgruppe:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ABFGR_KEY"/>
								</font>
								&#173;
								<font id="Titel">zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>					
					</table>				
					<xsl:for-each select="entst:Abfall">
						<xsl:call-template name="Abfall"/>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(entst:Grenzwerte)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Grenzwerte zu Abfallgruppe:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ABFGR_KEY"/>
								</font>
								&#173;
								<font id="Titel">zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>					
					</table>
					<xsl:for-each select="entst:Grenzwerte">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Grenzwert"/>
					</xsl:for-each>
				</xsl:if>
				
				<xsl:if test="count(entst:Beschraenkungen)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Beschränkungen zu Abfallgruppe:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ABFGR_KEY"/>
								</font>
								&#173;
								<font id="Titel">zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Beschraenkungen">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Beschraenkung"/>
					</xsl:for-each>
				</xsl:if>
				
				<xsl:if test="count(entst:Annahmekriterium)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Annahmekriterien zu Abfallgruppe:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ABFGR_KEY"/>
								</font>
								&#173;
								<font id="Titel">zu Teilanlage:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$TA_KEY"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="entst:Annahmekriterium">
						<xsl:sort select="entst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="Annahmekrit"/>
					</xsl:for-each>				
				</xsl:if>

			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Abfall">
		<xsl:call-template name="TableOneDashLine"/>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="40%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">gestrichen</td>
				<td id="Titel_klein">Streichgrund</td>
				<td id="Titel_klein">Datum gestrichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Abfallschluessel"/>
				</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Gestrichen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:Streichgrund"/>
				</td>
				<td id="Aktuell">
					<xsl:call-template name="getDateValue">
						<xsl:with-param name="TagName" select="'entst:DatumGestrichen'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>				
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="10%"/>
				<col width="15%"/>
				<col width="10%"/>
				<col width="15%"/>
				<col width="10%"/>
				<col width="15%"/>
				<col width="10%"/>
				<col width="15%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Input</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Input'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Behandeln</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Behandeln'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Lagern</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Lagern'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Umschlagen</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Umschlagen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">Ablagern</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Ablagern'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Verwerten</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Verwerten'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Beseitigen</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Beseitigen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Output</td>
				<td id="Aktuell">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'entst:Output'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<tr>
				<td id="Titel_klein">Notizen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:Notizen"/>
					&#173;
				</td>
			</tr>
		</table>				
	</xsl:template>

	<xsl:template name="EndeBetrieb">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="FkbZuBetrieb">
		<xsl:for-each select="entst:FKB">
			<xsl:call-template name="Fkb">
				<xsl:with-param name="prefix" select="'entst:'"/>
				<xsl:with-param name="prefixLib" select="'eslib:'"/>
			</xsl:call-template>
			<xsl:if test="count(entst:Branchen)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Branchen</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="entst:Branchen">
					<xsl:call-template name="BrancheBtr">
						<xsl:with-param name="prefix" select="'entst:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(entst:Ansprechpartner)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Personen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="entst:Ansprechpartner">
					<xsl:call-template name="PersonBtr">
						<xsl:with-param name="prefix" select="'entst:'"/>
						<xsl:with-param name="prefixLib" select="'eslib:'"/>
						<xsl:with-param name="betriebsinhaber" select="true()"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(entst:WeitereAdresseFirma)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Weitere Adressen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="entst:WeitereAdresseFirma">
					<xsl:call-template name="WeitereAdresse">
						<xsl:with-param name="prefix" select="'entst:'"/>
						<xsl:with-param name="prefixLib" select="'eslib:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
