<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:erzst="uri:ErzeugerStammdaten/ErzStamm"
	xmlns:ezlib="uri:ErzeugerStammdaten/ErzStammTypBibliothek"
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//erzst:Erzeuger">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Erzeuger</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileMain"/>
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileMain">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Verwaltung"/>
					<xsl:call-template name="Betrieb"/>
					<xsl:call-template name="ZustBehoerde"/>
					<xsl:call-template name="WeiteresBetrieb"/>
					<xsl:call-template name="PersonenBetrieb"/>
					<xsl:call-template name="Details"/>
					<xsl:call-template name="Anfallstelle"/>
					<xsl:call-template name="Abfall"/>
					<xsl:call-template name="EndeBetrieb"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<xsl:call-template name="FkbZuBetrieb"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Verwaltung">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Nummer">
						Erzeuger
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Verwaltungsinformationen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="30%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Gestrichen</td>
				<td id="Titel_klein">Streichgrund</td>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:Gestrichen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Streichgrund"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Aktenzeichen"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<font id="Titel_klein">Notizen</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Bemerkungen"/>
						&#173;
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Betrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Betriebsstätte</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Erzeugernummer</td>
				<td id="Titel_klein">Registriernummer im Heimatland</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:BehoerdlicheNummer/ezlib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:BehoerdlicheNummer/ezlib:Pruefziffer"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:RegistriernummerHeimatland"/>
				</td>
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="'erzst:ErzeugerBetrieb/erzst:'"/>
			<xsl:with-param name="prefixLib" select="'ezlib:'"/>
		</xsl:call-template>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Gemeindeschluessel"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Gemeindename"/>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">East-Wert</td>
				<td id="Titel_klein">North-Wert</td>
				<td id="Titel_klein">Rechtswert</td>
				<td id="Titel_klein">Hochwert</td>
				<td id="Titel_klein">TK 25</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:East"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:North"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:Rechts"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:Hoch"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:TK25"/>
				</td>
			</tr>
		</table>

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="'erzst:ErzeugerBetrieb/erzst:Kontaktdaten/ezlib:'"/>
		</xsl:call-template>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:InternetAdresse"/>
					&#173;
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="ZustBehoerde">
		<xsl:if test="count(erzst:ErzeugerBetrieb/erzst:ZustBehoerden)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Zuständige Behörden</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:ZustBehoerden">
				<xsl:sort select="erzst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="ZustBehoerdeBtr">
					<xsl:with-param name="prefix" select="'erzst:'"/>
					<xsl:with-param name="prefixLib" select="'ezlib:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="WeiteresBetrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Eigenschaften</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="10%"/>
				<col width="20%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Einmaliger Abfallanfall</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:EinmaligerAnfall'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">unterliegt AbfBeauftrV</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:IndicatorAbfBeauftrV'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
			<tr>
				<td id="Titel_klein">Abfallanfall aus Bauvorhaben</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Bauvorhaben'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">unterliegt IED-RL</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:IED-RL'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
			<tr>
				<td id="Titel_klein">Sekundärerzeuger</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:Sekundaererzeuger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">nach PRTR-V berichtspflichtig</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:PRTRVBerichtspflichtig'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
			<tr>
				<td id="Titel_klein">Kleinmengenerzeuger</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Kleinmengenerzeuger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">betreibt BImSchV-Anlagen</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:BImSchVAnlagen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
			<tr>
				<td id="Titel_klein">Flächenerzeuger</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:Flaechenerzeuger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>	
				<td/>				
				<td/>				
			</tr>
			<tr>
				<td id="Titel_klein">Eigenentsorger</td>
				<td id="Titel_klein">Eigenentsorgerummer</td>
				<td/>				
				<td/>				
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Eigenentsorger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Eigenentsorgernummer/ezlib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Eigenentsorgernummer/ezlib:Pruefziffer"/>
				</td>
				<td/>				
				<td/>				
			</tr>
			<tr>
				<td id="Titel_klein">Gebührenbefreit</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:Gebuehrenbefreit'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>	
				<td/>				
				<td/>				
			</tr>
			<tr>
				<td id="Titel_klein">Kommunikation per E-Mail</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'erzst:ErzeugerBetrieb/erzst:ErzeugerEigenschaften/erzst:BGSFehlerSchrPerEMail'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td/>				
				<td/>				
			</tr>
		</table>
		<xsl:if test="count(erzst:ErzeugerBetrieb/erzst:Branchen)>0 or string-length(erzst:ErzeugerBetrieb/erzst:BrancheText)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Branchen</font>
					</td>
				</tr>
				<xsl:if test="string-length(erzst:ErzeugerBetrieb/erzst:BrancheText)>0">
					<tr>
						<td>
							<font id="Titel_klein">Beschreibung der Branche</font>
						</td>
					</tr>
					<td id="Aktuell">
						<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:BrancheText"/>
					</td>
				</xsl:if>
			</table>
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Branchen">
				<xsl:call-template name="BrancheBtr">
					<xsl:with-param name="prefix" select="'erzst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="PersonenBetrieb">
		<xsl:if test="count(erzst:ErzeugerBetrieb/erzst:Ansprechpartner)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Personen zu Erzeuger</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Ansprechpartner">
				<xsl:call-template name="PersonBtr">
					<xsl:with-param name="prefix" select="'erzst:'"/>
					<xsl:with-param name="prefixLib" select="'ezlib:'"/>
					<xsl:with-param name="verantwortPerson" select="true()"/>
					<xsl:with-param name="fachkunde" select="true()"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Anfallstelle">
		<xsl:variable name="CNT_ANF" select="count(erzst:ErzeugerBetrieb/erzst:Anfallstellen)"/>
		<xsl:if test="$CNT_ANF>0">
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Anfallstellen">
				<xsl:sort select="erzst:LfdNr" data-type="number" order="ascending"/>
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Anfallstelle</font>
							&#173;
							<font id="Titel_klein">(</font>
							<font id="Aktuell">
								<xsl:value-of select="position()"/>
							</font>
							&#173;
							<font id="Titel_klein">von</font>
							&#173;
							<font id="Aktuell">
								<xsl:value-of select="$CNT_ANF"/>
							</font>
							<font id="Titel_klein">)</font>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">in Betrieb von</td>
						<td id="Titel_klein">bis</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'erzst:InBetriebVon'"/>
							</xsl:call-template>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'erzst:InBetriebBis'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="25%"/>
						<col width="25%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">lfd. Nr.</td>
						<td id="Titel_klein">Aktenzeichen</td>
						<td id="Titel_klein">Arbeitsstättennummer</td>
						<td id="Titel_klein">Anlagennummer</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:LfdNr"/>
							&#173;
						</td>
						<td id="Aktuell">
							<!--xsl:value-of select="erzst:ArbeitsstaettenNummer"/-->
						</td>
						<td id="Aktuell">
							<xsl:value-of select="erzst:ArbeitsstaettenNummer"/>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Anlagennummer"/>
						</td>
					</tr>
				</table>
				<xsl:variable name="ANFALL_PARENT">
					<xsl:value-of select="normalize-space(concat(erzst:LfdNr, ' - ', erzst:Bezeichnung1, ' ', erzst:Bezeichnung2))"/>
				</xsl:variable>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bezeichnung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Bezeichnung1"/>
							&#173;
							<xsl:value-of select="erzst:Bezeichnung2"/>
						</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Bezeichnung3"/>
							&#173;
							<xsl:value-of select="erzst:Bezeichnung4"/>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Sekundärerzeuger</td>
						<td id="Titel_klein">Entsorgernummer im Eingang</td>
					</tr>
					<tr>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'erzst:Sekundaererzeuger'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
						<td id="Aktuell">
							<xsl:value-of select="erzst:Entsorgernummer/ezlib:BehoerdlicheNr"/>
							&#173;
							<xsl:value-of select="erzst:Entsorgernummer/ezlib:Pruefziffer"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">nach PRTR-V berichtspflichtig</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'erzst:PRTRVBerichtspflichtig'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>					
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bemerkungen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Bemerkung"/>
							&#173;
						</td>
					</tr>
				</table>
				<xsl:if test="count(erzst:BImSchVNummern)">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Nummer 4. BImSchV zu Anfallstelle:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ANFALL_PARENT"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="erzst:BImSchVNummern">
						<xsl:sort select="erzst:LfdNr" data-type="number" order="ascending"/>
						<xsl:call-template name="BImSchV">
							<xsl:with-param name="prefix" select="'erzst:'"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(erzst:Detailangaben)>0">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Detailangaben zu Anfallstelle:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="$ANFALL_PARENT"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="erzst:Detailangaben">
						<xsl:call-template name="Detailangabe">
							<xsl:with-param name="prefix" select="'erzst:'"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Abfall">
		<xsl:variable name="CNT_ABF" select="count(erzst:ErzeugerBetrieb/erzst:Abfaelle)"/>
		<xsl:if test="$CNT_ABF>0">
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Abfaelle">
				<table width="100%" id="tabelle_nicht_unten">
					<tr>
						<td>
							<font id="Titel">Abfall</font>
							&#173;
							<font id="Titel_klein">(</font>
							<font id="Aktuell">
								<xsl:value-of select="position()"/>
							</font>
							&#173;
							<font id="Titel_klein">von</font>
							&#173;
							<font id="Aktuell">
								<xsl:value-of select="$CNT_ABF"/>
							</font>
							<font id="Titel_klein">)</font>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">angefallen von</td>
						<td id="Titel_klein">bis</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'erzst:AbfallanfallVon'"/>
							</xsl:call-template>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'erzst:AbfallanfallBis'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Schlüssel</td>
						<td id="Titel_klein">Betriebsinterne Bezeichnung</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Abfallschluessel"/>
							&#173;
						</td>
						<td id="Aktuell">
							<xsl:value-of select="erzst:BezeichnungIntern"/>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="50%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Sekundärabfall</td>
						<td id="Titel_klein">Abfall ist besonders zu überwachen</td>
						<td id="Titel_klein">Menge pro Jahr</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'erzst:Sekundaerabfall'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
						<td id="Aktuell">
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:call-template name="getBooleanValue">
											<xsl:with-param name="TagName" select="'erzst:BesondereUeberwachung'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
						<td>
							<font id="Aktuell">
								<xsl:call-template name="formatDouble">
									<xsl:with-param name="wert" select="erzst:Menge"></xsl:with-param>
								</xsl:call-template>
								<!--xsl:value-of select="erzst:Menge"/-->
							</font>
							&#173;
							<font id="Titel_klein">t/a</font>
						</td>
					</tr>
				</table>
				<table width="100%" id="tabelle_nicht_oben_unten">
					<tr>
						<td id="Titel_klein">Bemerkungen</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="erzst:Bemerkung"/>
							&#173;
						</td>
					</tr>
				</table>
				<xsl:if test="count(erzst:Detailangaben)>0">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Detailangaben zu Abfall:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="erzst:Abfallschluessel"/>
								</font>
							</td>
						</tr>
					</table>
					<xsl:for-each select="erzst:Detailangaben">
						<xsl:call-template name="Detailangabe">
							<xsl:with-param name="prefix" select="'erzst:'"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(erzst:AnfallstelleZuAbfall)>0">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td>
								<font id="Titel">Anfallstellen des Abfalls:</font>
								&#173;
								<font id="Aktuell">
									<xsl:value-of select="erzst:Abfallschluessel"/>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Anfallstelle(n):</font>
								&#173;
								<font  id="Aktuell">
									<xsl:for-each select="erzst:AnfallstelleZuAbfall/erzst:LKEY">
										<xsl:variable name="LKEY">
											<xsl:value-of select="."/>
										</xsl:variable>
										<xsl:if test="position()>1">, </xsl:if>
										<xsl:variable name="ANFALL_KEY">
											<xsl:value-of select="normalize-space(concat(//erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:LfdNr, ' - ',//erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:Bezeichnung1,' ', //erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:Bezeichnung2))"/>
										</xsl:variable>
										<xsl:value-of select="$ANFALL_KEY"/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Details">
		<xsl:if test="count(erzst:ErzeugerBetrieb/erzst:Detailangaben)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Detailangaben zu Erzeuger</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Detailangaben">
				<xsl:sort select="erzst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="Detailangabe">
					<xsl:with-param name="prefix" select="'erzst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="EndeBetrieb">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="FkbZuBetrieb">
		<xsl:for-each select="erzst:FKB">
			<xsl:call-template name="Fkb">
				<xsl:with-param name="prefix" select="'erzst:'"/>
				<xsl:with-param name="prefixLib" select="'ezlib:'"/>
			</xsl:call-template>
			<xsl:if test="count(erzst:Branchen)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Branchen</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:Branchen">
					<xsl:call-template name="BrancheBtr">
						<xsl:with-param name="prefix" select="'erzst:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(erzst:Ansprechpartner)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Personen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:Ansprechpartner">
					<xsl:call-template name="PersonBtr">
						<xsl:with-param name="prefix" select="'erzst:'"/>
						<xsl:with-param name="prefixLib" select="'ezlib:'"/>
						<xsl:with-param name="betriebsinhaber" select="true()"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(erzst:WeitereAdresseFirma)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Weitere Adressen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:WeitereAdresseFirma">
					<xsl:call-template name="WeitereAdresse">
						<xsl:with-param name="prefix" select="'erzst:'"/>
						<xsl:with-param name="prefixLib" select="'ezlib:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
