<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib en ds b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="NFDa"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="NFDa">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<!-- EB ja / nein -->
				<xsl:choose>
					<xsl:when test="not (boolean(en:Nachforderung))">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td>
									<font id="Nummer">
							  			In dieser Sicht ist keine Nachforderung vorhanden.
						  			</font>
									<br/>
									<font id="Nummer2">
							  			Eine Nachforderung befindet sich in der Sicht:
							  		</font>
									<font id="FormPosition">
										<!--xsl:call-template name="BB_Position">
					            			</xsl:call-template-->
										<xsl:call-template name="CHILD_POSITION">
											<xsl:with-param name="DocTyp" select="'ENSN'"/>
											<xsl:with-param name="ChildTyp" select="'en:Nachforderung'"/>
				            			</xsl:call-template>
										<!--xsl:call-template name="NF_Position">
					            			</xsl:call-template-->
									</font>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NF">
	            			</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="NF">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<table id="tabelle" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="39%"/>
										<col width="22%"/>
										<col width="39%"/>
									</colgroup>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td id="Ueberschrift2" width="98%">Beh&#246;rde</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Name</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde - Name 1 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name1"/>
													</font>
															&#173;
															<!-- Behörde- Name 2 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name2"/>
													</font>
															&#173;
															<!-- Behörde - Name 3 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name3"/>
													</font>
															&#173;
															<!-- Behörde - Name 4 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name4"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Behörde - Strasse 1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde - Strasse 2-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_2"/>
																</font>
															</td>
															<td width="10%">
																<!-- Behörde - Hausnummer -->
																<font id="Aktuell">
																	<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Hausnummer"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Postleitzahl -->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Behörde Ort1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde Ort2-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Nachforderung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - Name-->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Name"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Ansprechpartner - Telefon-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefon"/>
																</font>
															</td>
															<td width="70%">
																<!-- Behörde Ansprechpartner - Telefax-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefax"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - E-Mail-->
													<font id="Aktuell">
														<xsl:value-of select="en:Nachforderung/en:AbsenderBehoerde/en:Ansprechpartner/lib:EMail"/>
													</font>
												</td>
											</tr>
										</table>
									</td>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div align="right"><font id="Nummer">Nachforderung</font><font id="Ueberschrift2"> (<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)</font></div>
					<table id="tabelle_nicht_unten" width="100%">
						<xsl:call-template name="ESNKopfNummern"/>
					</table>
					<table width="100%" id="tabelle">
						<colgroup>
							<col width="92%"/>
							<col width="8%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%">
									<tr>
										<td id="Ueberschrift2" width="5"></td>
										<td id="titel" width="98%">
                                                        Aktenzeichen
                                                         </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:if test="en:Nachforderung/en:Aktenzeichen">
													<xsl:value-of select="en:Nachforderung/en:Aktenzeichen"/>
												</xsl:if>
											</font>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"></td>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="33%">Ort</td>
													<td id="titel" width="33%">Datum</td>
													<td id="titel" width="33%">Unterschrift</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td width="33%">
														<!-- Ort Unterschrift  -->
														<font id="Aktuell">
															<xsl:value-of select="en:Nachforderung/en:Erklaerung/lib:Ort"/>
														</font>
													</td>
													<td width="33%">
														<!--  Datum -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:Nachforderung/en:Erklaerung/lib:Datum"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="33%">
														<font id="Aktuell">
															<xsl:if test="ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
																<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																<xsl:variable name="SIG_DATE">
																	<xsl:call-template name="formatDate">
																		<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
															</xsl:if>
														</font>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<!--Fehler-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Nachforderungen:</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="10%"> Nummer</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Code / Bezeichnung</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="35%"> Mangel, Hinweis / Begründung</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Abhilfe / Erläuterung</td>
									</tr>
								</table>
								<xsl:for-each select="en:Nachforderung/en:Information">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:value-of select="en:Nummer"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Bezeichnung"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="35%">
												<xsl:value-of select="en:Begruendung"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Erlaeuterung"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
					</table>
					<!--Ende Fehlerprotokoll-->
				</td>
			</tr>
		</table>
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p-->
	</xsl:template>
	<xsl:template name="NF_Position">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="en:Nachforderung">
				<xsl:choose>
					<xsl:when test="position() > 9">
						<xsl:value-of select="concat(position(),'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0',position(),'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
