<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:html="http://www.w3c.org/TR/xhtml1/" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
xmlns:msg="uri:BMU_Waste_Interface/Message" 
xmlns:ntz="uri:BMU_Waste_Interface/Ntz" 
xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
xmlns:b64="xalan://de.itu.util.Base64" 
xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
xmlns:x509="xalan://de.itu.util.X509CertHelper" 
xmlns:util="xalan://de.condat.mbs.tools.TransformUtils"
xmlns:itu="xalan://de.itu.util.ISO_3166" 
xmlns:tfs="http://xsd.infotech.de/schema/tfs" 
xmlns:wmsg="Waste-WG-2018-Message" 
xmlns:wx="Guidlines11xtra" 
extension-element-prefixes="b64 crc32 x509 tfs util" 
exclude-result-prefixes="xsl lib msg ds b64 crc32 x509 tfs ntz wmsg wx util">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:variable name="LEERZEICHEN" select="' '"> </xsl:variable>

	<xsl:variable name="EXP_COUNTRY_ID">
		<xsl:value-of select="//wmsg:Submission/wmsg:ExportState/wmsg:CountryID"/>
	</xsl:variable>
	<xsl:variable name="IMP_COUNTRY_ID">
		<xsl:value-of select="//wmsg:Submission/wmsg:ImportState/wmsg:CountryID"/>
	</xsl:variable>
	<xsl:variable name="DVERF">
		<xsl:choose>
			<xsl:when test="count(//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="starts-with(.,'D')">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="position()=1">
						<xsl:if test="starts-with(.,'D')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RVERF">
		<xsl:choose>
			<xsl:when test="count(//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="starts-with(.,'R')">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="position()=1">
						<xsl:if test="starts-with(.,'R')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="DX">
		<xsl:if test="string-length($DVERF)>0">
			<xsl:value-of select="'X'"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name="RX">
		<xsl:if test="string-length($RVERF)>0">
			<xsl:value-of select="'X'"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:template match="/">
		<xsl:for-each select="//wmsg:NotificationDocument">
			<xsl:if test="position()=$positionsnummer">
				<xsl:call-template name="Notification"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Notification">
		<html>
			<head>
				<title>Notifizierungsformular</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile1_14"/>
							<xsl:call-template name="Zeile15"/>
							<xsl:call-template name="Zeile16"/>
							<xsl:call-template name="Zeile17_18"/>
							<xsl:call-template name="Zeile18a"/>
							<xsl:call-template name="Zeile19"/>
							<xsl:call-template name="Zeile20"/>
							<xsl:call-template name="EndeForm"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="Zeile1_14">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<font id="Ueberschrift2">Notifizierungsformular für grenzüberschreitende Verbringungen von Abfällen</font>
				</td>
			</tr>
		</table>
		<xsl:call-template name="Zeile1"/>
		<xsl:call-template name="Zeile2"/>
		<xsl:call-template name="Zeile3"/>
		<xsl:call-template name="Zeile4"/>
		<xsl:call-template name="Zeile5"/>
		<xsl:call-template name="Zeile6"/>
		<xsl:call-template name="Zeile7"/>
		<xsl:call-template name="Zeile8"/>
		<xsl:call-template name="Zeile9"/>
		<xsl:call-template name="Zeile10"/>
		<xsl:call-template name="Zeile10a"/>
		<xsl:call-template name="Zeile10b"/>
		<xsl:call-template name="Zeile12"/>
		<xsl:call-template name="Zeile13"/>
		<xsl:call-template name="Zeile14"/>
	</xsl:template>
	
	<xsl:template name="Zeile1">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:Submission/wmsg:Notifier)>0">
							<xsl:for-each select="wmsg:Submission/wmsg:Notifier">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'1. Exporteur - Notifizierender'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'1. Exporteur - Notifizierender'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile2">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:Submission/wmsg:Consignee)>0">
							<xsl:for-each select="wmsg:Submission/wmsg:Consignee">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'2. Importeur - Empfänger'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'2. Importeur - Empfänger'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile3">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="40%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel">3. Notifizierung Nr.:</td>
				<td id="Aktuell_gross">
						<xsl:value-of select="wmsg:NotificationID"/>
				</td>
			</tr>
			<tr>
				<td id="Titel">Notifizierung betreffend:</td>
				<td/>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="5%"/>
				<col width="35%"/>
				<col width="20%"/>
				<col width="30%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">A.</td>
				<td id="Titel_klein">Einmalige Verbringung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:ShipmentQuantity=1">
									<font id="Aktuell">
										<xsl:value-of select="'X'"/>
									</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Mehrmalige Verbringungen:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:ShipmentQuantity>1">
									<font id="Aktuell">
										<xsl:value-of select="'X'"/>
									</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">B.</td>
				<td id="Titel_klein">Beseitigung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<font id="Aktuell">
									<xsl:value-of select="$DX"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Verwertung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<font id="Aktuell">
									<xsl:value-of select="$RX"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="5%"/>
				<col width="65%"/>
				<col width="5%"/>
				<col width="10%"/>
				<col width="5%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">C.</td>
				<td id="Titel_klein">Verwertungsanlage für Vorabzustimmung</td>
				<td id="Titel_klein">Ja</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'wmsg:Submission/wmsg:PreConsentIndicator'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Nein</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'wmsg:Submission/wmsg:PreConsentIndicator'"/>
									<xsl:with-param name="invers" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile4">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="40%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel">4. Vorgesehene Gesamtzahl der Verbringungen:</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:ShipmentQuantity"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">5. Vorgesehene Gesamtmenge:</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="20%"/>
					<col width="13%"/>
					<col width="20%"/>
					<col width="13%"/>
					<col width="20%"/>
					<col width="14%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Tonnen (Mg):</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:MassMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:MassMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">Minimalmenge (Mg):</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:MinimumMassMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:MinimumMassMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">Maximalmenge (Mg):</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:MaximumMassMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:MaximumMassMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td id="Titel_klein">m³:</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:VolumeMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
					<td/>
					<td/>
					<td/>
					<td/>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile6">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">6. Vorgesehener Zeitraum für die Verbringungen:</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="20%"/>
					<col width="30%"/>
					<col width="20%"/>
					<col width="30%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Erster Beginn:</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:ShipmentPeriod/wmsg:FirstStartDate"/>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">Letzter Beginn:</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:ShipmentPeriod/wmsg:LastStartDate"/>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile7">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="40%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel">7. Verpackungsart(en):</td>
				<td id="Aktuell_klein">
					<xsl:for-each select="wmsg:Submission/wmsg:Packaging">
						<xsl:variable name="lTypeCode">
							<xsl:value-of select="wmsg:PackageTypeCode"/>
						</xsl:variable>
						<xsl:variable name="TypeCode">
							<xsl:choose>
								<xsl:when test="$lTypeCode = '1'">1. Trommel/Fass</xsl:when>
								<!-- DR = Drum -> 1 = Fässer -->
								<xsl:when test="$lTypeCode = '2'">2. Holzfass</xsl:when>
								<!-- W1 = Jerrican -> 3 = Kanister -->
								<xsl:when test="$lTypeCode = '3'">3. Kanister</xsl:when>
								<!-- 2C = Barrel, wooden -> 2 = Holzfässer -->
								<xsl:when test="$lTypeCode = '4'">4. Kiste/Kasten</xsl:when>
								<!-- BX = Box -> 4 = Kisten -->
								<xsl:when test="$lTypeCode = '5'">5. Sack/Beutel</xsl:when>
								<!-- BG = Bag -> 5 = Säcke -->
								<xsl:when test="$lTypeCode = '6'">6. Verbundverpackung</xsl:when>
								<!-- W2 = Composite Package -> 6 = Zusammengesetzte Verp.-->
								<xsl:when test="$lTypeCode = '7'">7. Druckbehälter</xsl:when>
								<!-- W3 = Pressure Receptacle -> 7 = Druckbehälter -->
								<xsl:when test="$lTypeCode = '8'">8. Schüttgut</xsl:when>
								<!-- W4 = Other -> 9 = Sonstige Verpackungen -->
								<!--xsl:when test="$lTypeCode = 'W5'">
									<xsl:value-of select="'9. Andere: '"/>
									<xsl:value-of select="Type"/>
								</xsl:when-->
								<!-- W5 = Bulk -> 8 = Unverpackt, Schüttgut -->
								<xsl:otherwise>9. Andere</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="position()>1">
							<xsl:value-of select="', '"/>
						</xsl:if>
						<xsl:value-of select="$TypeCode"/>
					</xsl:for-each>
				</td>
			</tr>
		</table>
		<xsl:if test="string-length(wmsg:Submission/wmsg:Packaging/wmsg:PackageDescription/wmsg:Description)>0">
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td id="Titel_klein">Beschreibung:</td>
				</tr>
				<tr>
					<td id="Aktuell_klein">
						<xsl:for-each select="wmsg:Submission/wmsg:Packaging/wmsg:PackageDescription/wmsg:Description">
							<xsl:if test="position()>1">
								<br/>
							</xsl:if>
							<xsl:call-template name="getFieldWithLanguage">
								<xsl:with-param name="TheValue" select="."/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:if>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="40%"/>
				<col width="5%"/>
				<col width="10%"/>
				<col width="5%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel">Besondere Handhabungsvorschriften:</td>
				<td id="Titel_klein">Ja</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'wmsg:Submission/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Nein</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'wmsg:Submission/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator'"/>
									<xsl:with-param name="invers" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile8">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">8. Vorgesehene(s) Transporttunternehmen</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission/wmsg:Carrier">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '8.',position(), ' Transporttunternehmen')"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td>
									<font id="Titel_klein">Transportart:</font>
								</td>
								<td>
									<font id="Aktuell_klein">
										<xsl:value-of select="wmsg:MeansOfTransportCode"/>
									</font>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile9">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">9. Abfallerzeuger</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission/wmsg:WasteProducer">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '9.',position(), ' Abfallerzeuger')"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%" valign="top"/>
								<col width="80%" valign="top"/>
							</colgroup>
							<tr>
								<td>
									<font id="Titel_klein">Ort der Abfallerzeugung:</font>
								</td>
								<td>
									<font id="Aktuell_klein">
										<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
											<xsl:if test="position()>1">
												<br/>
											</xsl:if>
											<xsl:call-template name="getFieldWithLanguage">
												<xsl:with-param name="TheValue" select="."/>
											</xsl:call-template>
										</xsl:for-each>
									</font>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile10">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">10. Beseitigungs- Verwertunganlage(n) / 11. Beseitigungs-/Verwertungsverfahren</td>
			</tr>
		</table>
		<xsl:if test="count(wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
			<xsl:for-each select="wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="Tabelle_nicht_oben_unten">
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="concat( '10.',position(), ' Nicht vorläufige Beseitigungs- Verwertunganlage')"/>
							</xsl:call-template>
						</td>
					</tr>
					<xsl:call-template name="Zeile11"/>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Zeile11">
		<tr>
			<td>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%" valign="top"/>
						<col width="80%" valign="top"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Ort der tatsächlichen<br/>Beseitigung/Verwertung:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Kennnummer(n):</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:SiteID">
								<xsl:if test="position()>1">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="concat(., ' (', itu:getLandKuerzel(@identificationSchemeID), ')')"/>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">D-Code / R-Code:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
								<xsl:if test="position()>1">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Verfahrensbeschreibung:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:RecoveryDisposalDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Angewandte Technologie:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:TechnologyDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Grund für die Ausfuhr:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:ReasonForExportDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="Zeile10a">
		<xsl:if test="count(wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
			<xsl:for-each select="wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="Tabelle_nicht_oben_unten">
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'10. Erste vorläufige Beseitigungs- Verwertunganlage'"/>
							</xsl:call-template>
						</td>
					</tr>
					<xsl:call-template name="Zeile11"/>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Zeile10b">
		<xsl:if test="count(wmsg:Submission/wmsg:SubsequentInterimRecoveryDisposalFacility)>0">
			<xsl:for-each select="wmsg:Submission/wmsg:SubsequentInterimRecoveryDisposalFacility">
				<xsl:call-template name="TableOneDashLine"/>
				<table width="100%" id="Tabelle_nicht_oben_unten">
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="concat( '10.',position(), ' Vorläufige Beseitigungs- Verwertunganlage')"/>
							</xsl:call-template>
						</td>
					</tr>
					<xsl:call-template name="Zeile11"/>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Zeile12">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">12. Bezeichnung und Zusammensetzung des Abfalls:</td>
			</tr>
			<tr>
				<td id="Aktuell_klein">
					<xsl:for-each select="wmsg:Submission/wmsg:WasteDesignationDescription/wmsg:Description">
						<xsl:if test="position()>1">
							<br/>
						</xsl:if>
						<xsl:call-template name="getFieldWithLanguage">
							<xsl:with-param name="TheValue" select="."/>
						</xsl:call-template>
					</xsl:for-each>
					<xsl:value-of select="$LEERZEICHEN"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile13">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="30%"/>
							<col width="70%"/>
						</colgroup>
						<tr>
							<td id="Titel">13. Physikalische Eigenschaften:</td>
							<td id="Aktuell_klein">
								<xsl:for-each select="wmsg:Submission/wmsg:PhysicalCharacteristicTypeCode">
									<xsl:variable name="lPhys">
										<xsl:value-of select="."/>
									</xsl:variable>
									<xsl:variable name="PhysEig">
										<xsl:choose>
											<xsl:when test="$lPhys = 1">1. Staub- oder pulverförmig</xsl:when>
											<!-- SOLDUS = Solid - Dusty -> 1 = pulverförmig oder staubförmig -->
											<xsl:when test="$lPhys = 2">2. Fest</xsl:when>
											<!-- SOLCHU = Solid - in chunks -> 2 = fest -->
											<xsl:when test="$lPhys = 3">3. Pastös/breiig</xsl:when>
											<!-- SLUVISC =  Viscous or paste -> 3 = pastös oder breiig -->
											<xsl:when test="$lPhys = 4">4. Schlammig</xsl:when>
											<!-- SLU = Sludgy -> 4 = schlammig -->
											<xsl:when test="$lPhys = 5">5. Flüssig</xsl:when>
											<!-- LIQ = Liquid -> 5 = flüssig -->
											<xsl:when test="$lPhys = 6">6. Gasförmig</xsl:when>
											<!-- GAS = Gaseous -> 6 = gasförmig -->
											<xsl:otherwise>0. unbekannt</xsl:otherwise>
											<!-- ??? -> 0 = unbekannt -->
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$PhysEig"/>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<xsl:if test="string-length(wmsg:Submission/wmsg:hysicalCharacteristicDescription/wmsg:Description)>0">
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td id="Titel_klein">Beschreibung:</td>
				</tr>
				<tr>
					<td id="Aktuell_klein">
						<xsl:for-each select="wmsg:Submission/wmsg:hysicalCharacteristicDescription/wmsg:Description">
							<xsl:if test="position()>1">
								<br/>
							</xsl:if>
							<xsl:call-template name="getFieldWithLanguage">
								<xsl:with-param name="TheValue" select="."/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Zeile14">
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_nicht_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel">14. Abfallidentifizierung</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="3%" align="right"/>
								<col width="37%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">i)</td>
								<td id="Titel_klein">Basel Anlage VIII (oder IX falls anwendbar):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='BASEL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">ii)</td>
								<td id="Titel_klein">OECD-Code (falls abweichend von i):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OECD']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iii)</td>
								<td id="Titel_klein">EU-Abfallverzeichnis:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='EWL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iv)</td>
								<td id="Titel_klein">Nationaler Code im Ausfuhrland:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATEXP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">v)</td>
								<td id="Titel_klein">Nationaler Code im Einfuhrland:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATIMP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vi)</td>
								<td id="Titel_klein">Sonstige:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OTHER']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vii)</td>
								<td id="Titel_klein">Y-Code:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='YCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">viii)</td>
								<td id="Titel_klein">H-Code:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='HCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iX) </td>
								<td id="Titel_klein">UN-Klasse:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNCLASS']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">X)</td>
								<td id="Titel_klein">UN-Kennnummer:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNNUM']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xi)</td>
								<td id="Titel_klein">UN-Versandname:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNSHIP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xii)</td>
								<td id="Titel_klein">Zollnummer(n) (HS):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='CUST']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile15">
		<table width="100%" id="Tabelle_nicht_unten">
				<tr>
					<td id="Titel">15. Betroffene Staaten</td>
				</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="25%"/>
				<col width="25%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Ausfuhrstaat/Versandstaat</td>
				<td id="Titel_klein">Codenummer der zuständigen Behörde</td>
				<td id="Titel_klein">Ausfuhrort (Grenzübergang oder Hafen)</td>
			</tr>
			<tr>
				<td id="Aktuell_klein">
					<xsl:value-of select="itu:getLandKuerzel(wmsg:Submission/wmsg:ExportState/wmsg:CountryID)"/>
				</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:ExportState/wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
				</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:ExportState/wmsg:ExitPointName"/>
				</td>
			</tr>
		</table>
		<xsl:if test="count(wmsg:Submission/wmsg:TransitState)>0">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Durchfuhrstaat</td>
					<td id="Titel_klein">Codenummer der zuständigen Behörde</td>
					<td id="Titel_klein">Eingang</td>
					<td id="Titel_klein">Ausgang</td>
				</tr>
				<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
					<tr>
						<td id="Aktuell_klein">
							<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
						</td>
						<td id="Aktuell_klein">
							<xsl:value-of select="wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
						</td>
						<td id="Aktuell_klein">
							<xsl:value-of select="wmsg:EntryPointName"/>
						</td>
						<td id="Aktuell_klein">
							<xsl:value-of select="wmsg:ExitPointName"/>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
		<xsl:call-template name="TableOneDashLine"/>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="25%"/>
				<col width="25%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Einfuhrstaat/Empfängerstaat</td>
				<td id="Titel_klein">Codenummer der zuständigen Behörde</td>
				<td id="Titel_klein">Einfuhrort (Grenzübergang oder Hafen)</td>
			</tr>
			<tr>
				<td id="Aktuell_klein">
					<xsl:value-of select="itu:getLandKuerzel(wmsg:Submission/wmsg:ImportState/wmsg:CountryID)"/>
				</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:ImportState/wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
				</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:ImportState/wmsg:EntryPointName"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile16">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">16. Eingangs- und/oder Ausfuhrzollstellen (Europäische Gemeinschaft)</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="33%"/>
							<col width="33%"/>
							<col width="34%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Eingang:</td>
							<td id="Titel_klein">Ausgang:</td>
							<td id="Titel_klein">Ausfuhr:</td>
						</tr>
						<tr>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Submission/wmsg:CustomsOfficeEntryName"/>
							</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Submission/wmsg:CustomsOfficeExitName"/>
							</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Submission/wmsg:CustomsOfficeExportName"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
		
	<xsl:template name="Zeile17_18">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">17. Erklärung des Exporteurs – Notifizierenden/Erzeugers</td>
						</tr>
						<tr>
							<td id="Titel_klein">Ich erkläre hiermit, dass die obigen Informationen nach meinem besten Wissen vollständig sind und der Wahrheit entsprechen.<br/>Ich erkläre ferner, dass rechtlich durchsetzbare vertragliche Verpflichtungen schriftlich eingegangen wurden und alle für die grenzüberschreitende<br/>Verbringung erforderlichen Versicherungen oder sonstigen Sicherheitsleistungen abgeschlossen bzw. hinterlegt wurden oder werden.</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="30%"/>
							<col width="20%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Name des Exporteurs/Notifizierenden:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Name"/>
							</td>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wmsg:DeclarationExporter/wmsg:Date"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Signature"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Name des Erzeugers:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Name"/>
							</td>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wmsg:DeclarationProducer/wmsg:Date"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Signature"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="33%"/>
				<col width="67%"/>
			</colgroup>
			<tr>
				<td id="Titel">18. Anzahl der beigefügten Anhänge</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:Submission/wmsg:AnnexQuantity"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile18a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DEN ZUSTÄNDIGEN BEHÖRDEN AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile19">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">19. Bestätigung der zuständigen Behörden</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Acknowledgement">
			<xsl:call-template name="TableOneDashLine"/>
			<xsl:variable name="ACK_COUNTRY">
				<xsl:value-of select="wmsg:CountryID"/>
			</xsl:variable>
			<xsl:variable name="BH_TYP">
				<xsl:choose>
					<xsl:when test="$IMP_COUNTRY_ID=$ACK_COUNTRY">Importbehörde</xsl:when>
					<xsl:when test="$EXP_COUNTRY_ID=$ACK_COUNTRY">Exportbehörde</xsl:when>
					<xsl:otherwise>
						<xsl:if test="string-length($ACK_COUNTRY)>0">Transitbehörde</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
								<tr>
									<td id="Titel">
										<xsl:value-of select="$BH_TYP"/>
									</td>
								</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="30%"/>
								<col width="70%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Land:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Eingang der Notifizierung am:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:ReceiptDate"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Eingang bestätigt am:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:SentDate"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<xsl:for-each select="wmsg:CompetentAuthority">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="BEHOERDE" select="true()"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile20">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<font id="Titel">20. Schriftliche Zustimmung der Verbringung durch die zuständigen Behörden / 21. Auflagen und Einwände</font>
				</td>
			</tr>
			<xsl:if test="//wmsg:AnyXml/wx:NTZxtra">
				<xsl:for-each select="//wmsg:AnyXml/wx:NTZxtra">
					<tr>
						<td>
							<font id="Titel_klein">Gemeinsamer Zustimmungszeitraum der zuständigen Behörden:  Gültig vom</font>&#160;
							<font id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wx:ValidFrom"/>
								</xsl:call-template>
								&#160;
							</font>
							<font id="Titel_klein">bis</font>&#160;
							<font id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wx:ValidTo"/>
								</xsl:call-template>
							</font>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
		</table>
		<xsl:for-each select="wmsg:Decision">
			<xsl:call-template name="TableOneDashLine"/>
			<xsl:variable name="ACK_COUNTRY">
				<xsl:value-of select="wmsg:CountryID"/>
			</xsl:variable>
			<xsl:variable name="BH_TYP">
				<xsl:choose>
					<xsl:when test="$IMP_COUNTRY_ID=$ACK_COUNTRY">Importbehörde</xsl:when>
					<xsl:when test="$EXP_COUNTRY_ID=$ACK_COUNTRY">Exportbehörde</xsl:when>
					<xsl:otherwise>
						<xsl:if test="string-length($ACK_COUNTRY)>0">Transitbehörde</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
								<tr>
									<td id="Titel">
										<xsl:value-of select="$BH_TYP"/>
									</td>
								</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Land:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Zustimmung erteilt am</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:DecisionDate"/>
									</xsl:call-template>
								</td>
								<td/>
								<td/>
							</tr>
							<tr>
								<td id="Titel_klein">Zustimmung gültig vom</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:ValidFromDate"/>
									</xsl:call-template>
								</td>
								<td id="Titel_klein">bis</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:ValidToDate"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Besondere Auflagen:</td>
								<td id="Titel_klein">Nein:</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'wmsg:SpecificConditionIndicator'"/>
													<xsl:with-param name="invers" select="true()"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
								<td id="Titel_klein">Ja:</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'wmsg:SpecificConditionIndicator'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel_klein">Besondere Auflagen für die Zustimmung zu der Verbringung:</td>
							</tr>
							<tr>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:SpecificConditionDescription/wmsg:Description">
										<xsl:if test="position()>1">
											<br/>
										</xsl:if>
										<xsl:call-template name="getFieldWithLanguage">
											<xsl:with-param name="TheValue" select="."/>
										</xsl:call-template>
									</xsl:for-each>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Erhebung von Einwänden:</td>
								<td id="Titel_klein">Nein:</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'wmsg:ConsentGrantedIndicator'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
								<td>
									<font id="Titel_klein">Ja:</font>
								</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'wmsg:ConsentGrantedIndicator'"/>
													<xsl:with-param name="invers" select="true()"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel_klein">Gründe für die Erhebung von Einwänden:</td>
							</tr>
							<tr>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:ObjectionDescription/wmsg:Description">
										<xsl:if test="position()>1">
											<br/>
										</xsl:if>
										<xsl:call-template name="getFieldWithLanguage">
											<xsl:with-param name="TheValue" select="."/>
										</xsl:call-template>
									</xsl:for-each>
								</td>
							</tr>
						</table>
						<xsl:for-each select="wmsg:CompetentAuthority">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="BEHOERDE" select="true()"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="EndeForm">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="NAME_ADRESSE">
		<xsl:param name="ROLLE_VBF"/>
		<xsl:param name="BEHOERDE" select="false()"/>

		<xsl:if test="$BEHOERDE=false()">
			<table width="100%" id="Tabelle_ohne">
				<tr>
					<td id="Titel">
						<xsl:value-of select="$ROLLE_VBF"/>
					</td>
				</tr>
			</table>
		</xsl:if>

		<xsl:choose>
			<xsl:when test="string-length(wmsg:OrganizationName)>0 or string-length(wmsg:Person)>0">
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<xsl:if test="$BEHOERDE">
							<tr>
								<td id="Titel_klein">Codenummer:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="wmsg:CompetentAuthorityID"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td id="Titel_klein">Registriernummer(n):</td>
							<td id="Aktuell_klein">
								<xsl:for-each select="wmsg:PartyID">
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="concat(., ' (', itu:getLandKuerzel(@identificationSchemeID), ')')"/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Name:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="NAME_1">
									<xsl:choose>
										<xsl:when test="string-length(wmsg:OrganizationName)>0">
											<xsl:value-of select="wmsg:OrganizationName"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="wmsg:Person/wmsg:GivenName"/>
											<xsl:value-of select="$LEERZEICHEN"/>
											<xsl:value-of select="wmsg:Person/wmsg:FamilyName"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:value-of select="$NAME_1"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Anschrift:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="STRASSE">
									<xsl:choose>
										<xsl:when test="string-length(wmsg:Address/wmsg:StreetName) > 0">
											<xsl:value-of select="wmsg:Address/wmsg:StreetName"/>
										</xsl:when>
										<xsl:when test="string-length(wmsg:Address/wmsg:PostOfficeBox)">
											<xsl:value-of select="wmsg:Address/wmsg:PostOfficeBox"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="HAUSNR">
									<xsl:value-of select="wmsg:Address/wmsg:BuildingNumber"/>
								</xsl:variable>
								<xsl:variable name="BLOCK">
									<xsl:if test="string-length(wmsg:Address/wmsg:BlockName)>0">
										<xsl:value-of select="concat(' (Block: ', wmsg:Address/wmsg:BlockName, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="STOCK">
									<xsl:if test="string-length(wmsg:Address/wmsg:StaircaseNumber)>0">
										<xsl:value-of select="concat(' (Stockwerk: ', wmsg:Address/wmsg:StaircaseNumber, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="FLUR">
									<xsl:if test="string-length(wmsg:Address/wmsg:FloorIdentification)>0">
										<xsl:value-of select="concat(' (Flur: ', wmsg:Address/wmsg:FloorIdentification, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="ZIMMER">
									<xsl:if test="string-length(wmsg:Address/wmsg:RoomIdentification)>0">
										<xsl:value-of select="concat(' (Zimmer: ', wmsg:Address/wmsg:RoomIdentification, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR, $BLOCK, $STOCK, $FLUR, $ZIMMER))"/>
							</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell_klein">
								<xsl:value-of select="normalize-space(concat(wmsg:Address/wmsg:Postcode,' ',wmsg:Address/wmsg:CityName,' ',wmsg:Address/wmsg:CitySubDivisionName))"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Land:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="itu:getLandKuerzel(wmsg:Address/wmsg:CountryID)"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Kontaktperson:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="GENDER">
									<xsl:choose>
										<xsl:when test="wmsg:Contact/wmsg:GenderCode=1">Herr</xsl:when>
										<xsl:when test="wmsg:Contact/wmsg:GenderCode=2">Frau</xsl:when>
									</xsl:choose>
								</xsl:variable>
								<xsl:value-of select="normalize-space(concat($GENDER, ' ', wmsg:Contact/wmsg:GivenName, ' ',wmsg:Contact/wmsg:FamilyName))"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Tel.:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:TelephoneCompleteNumber"/>
							</td>
							<td id="Titel_klein">Fax:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:FaxCompleteNumber"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">E-Mail:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:EmailURI"/>&#173;
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Homepage:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:WebsiteURI"/>&#173;
							</td>
						</tr>
					</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="20%"/>
						<col width="30%"/>
					</colgroup>
					<xsl:if test="$BEHOERDE">
						<tr>
							<td id="Titel_klein">Codenummer:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
					<tr>
						<td id="Titel_klein">Registriernummer:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Name:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Anschrift:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Land:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Kontaktperson:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="10%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Tel.:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
						<td id="Titel_klein">Fax:</td>
						<td/>
					</tr>
					<tr>
						<td id="Titel_klein">E-Mail:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Homepage:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
