<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:enx="urn:de:bmu:eanv:ENFXS:ENMore:1:01" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en enx">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="Deckblatt"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Deckblatt">
		<xsl:variable name="ISEN">
			<xsl:call-template name="getBooleanValue">
				<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorEN'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="ISBB">
			<xsl:call-template name="getBooleanValue">
				<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorMitBB'"/>
			</xsl:call-template>
		</xsl:variable>
		<!--xsl:for-each select="//*[@lib:LayerID=$layerID]"-->
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<table id="tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<xsl:choose>
											<xsl:when test="local-name() = 'ENSNVorlageLayerRE'">
												<font id="Nummer">
													Spezielles freies Layer für Register
												</font>
											</xsl:when>
											<xsl:otherwise>
												<font id="Nummer">
													<xsl:choose>
														<xsl:when test="$ISEN='X'">
															<xsl:choose>
																<xsl:when test="$ISBB='X'">
																	Entsorgungsnachweis im Grundverfahren
																</xsl:when>
																<xsl:otherwise>
																	Entsorgungsnachweis im privilegierten Verfahren
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise>
															<xsl:choose>
																<xsl:when test="$ISBB='X'">
																	Sammelentsorgungsnachweis im Grundverfahren
																</xsl:when>
																<xsl:otherwise>
																	Sammelentsorgungsnachweis im privilegierten Verfahren
																</xsl:otherwise>
															</xsl:choose>
														</xsl:otherwise>
													</xsl:choose>
												</font>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="35%" valign="top"/>
												<col width="65%" valign="top"/>
											</colgroup>
											<tr>
												<td>
													<xsl:call-template name="ESNKopfNummerUebersicht"/>
												</td>
												<td>
													<table width="100%">
														<colgroup>
															<col width="30%"/>
															<col width="70%"/>
														</colgroup>
														<tr>
															<td>
																<font id="titel">Laufzeit: </font>
															</td>
															<td>
																<xsl:if test="string-length(//enx:NachweisGueltigVon)>0 or string-length(//enx:NachweisGueltigBis)>0">
																	<font id="Aktuell_notu">
																		<xsl:call-template name="formatDate">
																			<xsl:with-param name="date">
																				<xsl:value-of select="//enx:NachweisGueltigVon"/>
																			</xsl:with-param>
																		</xsl:call-template>
																		&#173;-&#173;
																		<xsl:call-template name="formatDate">
																			<xsl:with-param name="date">
																				<xsl:value-of select="//enx:NachweisGueltigBis"/>
																			</xsl:with-param>
																		</xsl:call-template>
																	</font>
																</xsl:if>
															</td>
														</tr>
														<tr>
															<td>
																<font id="titel">Nachweis nutzbar: </font>
															</td>
															<td>
																<font id="Aktuell_notu">
																	<xsl:if test="//enx:NWxtra">
																		<xsl:choose>
																			<xsl:when test="//enx:NachweisNutzbar='true'">Ja</xsl:when>
																			<xsl:when test="//enx:NachweisNutzbar='false'">Nein</xsl:when>
																			<xsl:otherwise>nicht angegeben</xsl:otherwise>
																		</xsl:choose>
																	</xsl:if>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table id="tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="35%" valign="top"/>
												<col width="65%" valign="top"/>
											</colgroup>
											<tr>
												<td>
													<table width="100%">
														<colgroup>
															<col width="40%"/>
															<col width="60%"/>
														</colgroup>
														<tr>
															<td>
																<font id="Nummer2">Entsorger</font>
															</td>
															<td>
																<!-- Entsorgernummer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Entsorgernummer/lib:BehoerdlicheNr'"/>
																</xsl:call-template>
																&#173;
																<!-- Prüfziffer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Entsorgernummer/lib:Pruefziffer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
												<td>
													<table width="100%">
														<tr>
															<td>
																<!-- Name 1-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name1'"/>
																</xsl:call-template>
																&#173;
																<!-- Name 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name2'"/>
																</xsl:call-template>
																&#173;
																<!-- Name 3-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name3'"/>
																</xsl:call-template>
																&#173;
																<!-- Name 4-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name4'"/>
																</xsl:call-template>
																<br/>
																<!-- Straße 1-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																</xsl:call-template>
																&#173;
																<!-- Straße 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
																&#173;
																<!-- Hausnummer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
																<br/>
																<!-- PLZ-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																</xsl:call-template>
																&#173;
																<!-- Ort 1-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																</xsl:call-template>
																&#173;
																<!-- Ort 2 -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:AE/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<xsl:choose>
								<xsl:when test="$ISEN='X'">
									<table id="tabelle_nicht_unten" width="100%">
										<tr>
											<td>
												<table width="100%">
													<colgroup>
														<col width="35%" valign="top"/>
														<col width="65%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<table width="100%">
																<colgroup>
																	<col width="40%"/>
																	<col width="60%"/>
																</colgroup>
																<tr>
																	<td>
																		<font id="Nummer2">Erzeuger</font>
																	</td>
																	<td>
																		<!-- Entsorgernummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Erzeugernummer/lib:BehoerdlicheNr'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Prüfziffer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Erzeugernummer/lib:Pruefziffer'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
														<td>
															<table width="100%">
																<tr>
																	<td>
																		<!-- Name 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name2'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 3-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name3'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 4-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name4'"/>
																		</xsl:call-template>
																		<br/>
																		<!-- Straße 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Straße 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Hausnummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																		</xsl:call-template>
																		<br/>
																		<!-- PLZ-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Ort 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Ort 2 -->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</xsl:when>
								<xsl:otherwise>
									<table id="tabelle_nicht_unten" width="100%">
										<tr>
											<td>
												<table width="100%">
													<colgroup>
														<col width="35%" valign="top"/>
														<col width="65%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<table width="100%">
																<colgroup>
																	<col width="40%"/>
																	<col width="60%"/>
																</colgroup>
																<tr>
																	<td>
																		<font id="Nummer2">Beförderer</font>
																	</td>
																	<td>
																		<!-- Entsorgernummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Befoerderernummer/lib:BehoerdlicheNr'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Prüfziffer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Befoerderernummer/lib:Pruefziffer'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
														<td>
															<table width="100%">
																<tr>
																	<td>
																		<!-- Name 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name2'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 3-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name3'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 4-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name4'"/>
																		</xsl:call-template>
																		<br/>
																		<!-- Straße 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Straße 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Hausnummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																		</xsl:call-template>
																		<br/>
																		<!-- PLZ-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Ort 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Ort 2 -->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
									<table id="tabelle_nicht_unten" width="100%">
										<tr>
											<td>
												<table width="100%">
													<colgroup>
														<col width="35%" valign="top"/>
														<col width="65%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<font id="Nummer2">Sammelgebiete</font>
														</td>
														<td>
															<font id="titel">Bundesland / Bundesl&#228;nder in dem / denen der Abfall eingesammelt wird</font>
														</td>
													</tr>
													<tr>
														<td/>
														<td>
															<table id="Tabelle_ohne" width="100%">
																<tr>
																	<td id="titel" width="15%">Bundesland</td>
																	<td id="titel" width="25%">Kreiskennung</td>
																	<td id="titel" width="60%">Kreis</td>
																</tr>
															</table>
															<xsl:call-template name="Bundeslaender">
																<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland'"/>
															</xsl:call-template>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</xsl:otherwise>
							</xsl:choose>
							<table id="tabelle" width="100%">
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="35%" valign="top"/>
												<col width="65%" valign="top"/>
											</colgroup>
											<tr>
												<td>
													<table width="100%">
														<colgroup>
															<col width="40%"/>
															<col width="60%"/>
														</colgroup>
														<tr>
															<td>
																<font id="Nummer2">Abfall</font>
															</td>
															<td>
																<!-- Abfallschlüssel -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Abfallschluessel'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
												<td>
													<table width="100%">
														<tr>
															<td>
																<!-- Abfallbezeichnung -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Abfallbezeichnung'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<!-- eigentlich waren die Transportarten gewünscht - wurde aber bei der letzten Besprechung nicht mehr thematisiert -->
							<!-- xsl:if test="count(//enx:Transport)>0">
								<table width="100%" id="tabelle_nicht_oben">
									<tr>
										<td>
											<table width="100%">
												<tr>
													<td id="Ueberschrift2" width="5"></td>
													<td id="Ueberschrift2" width="98%">Ausschließliche Transportarten</td>
												</tr>
												<tr height="5">
													<td width="5"/>
													<td width="98%"/>
												</tr>
												<tr>
													<td width="5"/>
													<td width="98%">
														<table width="100%">
															<tr>
																<td id="titel" width="20%">Beförderernummer</td>
																<td id="titel" width="10%">Code</td>
																<td id="titel" width="70%">Transportart</td>
															</tr>
														</table>
														<xsl:for-each select="//enx:Transport">
															<table id="Tabelle_oben" width="100%">
																<tr>
																	<td id="Aktuell" valign="top" width="20%">
																		<xsl:value-of select="enx:Befoerderernummer"/>
																	</td>
																	<td id="Aktuell" valign="top" width="10%">
																		<xsl:value-of select="enx:Code"/>
																	</td>
																	<td id="Aktuell" valign="top" width="70%">
																		<xsl:value-of select="enx:Art"/>
																	</td>
																</tr>
															</table>
														</xsl:for-each>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</xsl:if -->
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Kreis">
		<xsl:param name="blindex"/>
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index]">
					<table width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Aktuell" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:Kreis[@lib:Index=$index][parent::en:Bundesland[@lib:Index=$blindex]][last()]">
					<table width="100%">
						<tr>
							<td id="Text" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Text" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="Kreise">
		<xsl:param name="blindex"/>
		<xsl:param name="source"/>
		<xsl:for-each select="$source">
			<!--xsl:message>Source<xsl:value-of select="$source"/></xsl:message-->

			<xsl:variable name="sortedKreis">
				<xsl:for-each select="descendant::en:Kreis[parent::en:Bundesland[@lib:Index=$blindex]]">
					<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="xalan:nodeset($sortedKreis)/*">
				<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
				<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:Kreis[1]/@lib:Index)">
					<xsl:variable name="index" select="@lib:Index"/>
					<xsl:for-each select="$source">
						<xsl:call-template name="Kreis">
							<xsl:with-param name="index" select="$index"/>
							<xsl:with-param name="blindex" select="$blindex"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Bundesland">
		<xsl:param name="index"/>
		<!--xsl:message>layer merken</xsl:message-->
		<xsl:variable name="source" select="."/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index]">
					<table id="Tabelle_oben" width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="15%">
								<xsl:value-of select="en:Name"/>
							</td>
							<!--td id="Aktuell" valign="top" width="25%">
								<xsl:for-each select="en:Kreiskennung">
									<xsl:value-of select="."/>
									<xsl:if test="position() != last()"> / </xsl:if>
								</xsl:for-each>
							</td-->
							<td id="Aktuell" valign="top" width="25%">
								<xsl:for-each select="$source">
									<xsl:variable name="maxKennungen">
										<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index]">
											<xsl:sort order="descending" data-type="number" select="count(en:Kreiskennung)"/>
											<xsl:if test="position()=1">
												<xsl:value-of select="count(en:Kreiskennung)"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<!--xsl:message>maxKennungen: <xsl:value-of select="$maxKennungen"/></xsl:message-->
									<xsl:if test="not($maxKennungen=0)">
										<xsl:call-template name="Kreiskennungen">
											<xsl:with-param name="blindex" select="$index"/>
											<xsl:with-param name="maxIndex" select="$maxKennungen"/>
											<xsl:with-param name="pos" select="1"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Text" valign="top" width="60%">
								<xsl:call-template name="Kreise">
									<xsl:with-param name="blindex" select="$index"/>
									<xsl:with-param name="source" select="$source"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index][last()]">
					<table id="Tabelle_unten" width="100%">
						<tr>
							<td id="Text" valign="top" width="15%">
								<xsl:value-of select="en:Name"/>
							</td>
							<!--td id="Text" valign="top" width="25%">
								<xsl:for-each select="en:Kreiskennung">
									<xsl:value-of select="."/>
									<xsl:if test="position() != last()"> / </xsl:if>
								</xsl:for-each>
							</td-->
							<td id="Text" valign="top" width="25%">
								<xsl:for-each select="$source">
									<xsl:variable name="maxKennungen">
										<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index]">
											<xsl:sort order="descending" data-type="number" select="count(en:Kreiskennung)"/>
											<xsl:if test="position()=1">
												<xsl:value-of select="count(en:Kreiskennung)"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<!--xsl:message>maxKennungen: <xsl:value-of select="$maxKennungen"/></xsl:message-->
									<xsl:if test="not($maxKennungen=0)">
										<xsl:call-template name="Kreiskennungen">
											<xsl:with-param name="blindex" select="$index"/>
											<xsl:with-param name="maxIndex" select="$maxKennungen"/>
											<xsl:with-param name="pos" select="1"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Text" valign="top" width="60%">
								<xsl:call-template name="Kreise">
									<xsl:with-param name="blindex" select="$index"/>
									<xsl:with-param name="source" select="$source"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Kreiskennungen">
		<!--xsl:param name="source"/-->
		<xsl:param name="blindex"/>
		<xsl:param name="pos"/>
		<xsl:param name="maxIndex"/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos]">
					<table width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="$pos"/>
							</td>
							<td id="Aktuell" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos])">
				<xsl:for-each select="descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos]">
					<xsl:if test="position()=last()">
						<table width="100%">
							<tr>
								<td id="Text" valign="top" width="10%">
									<xsl:value-of select="$pos"/>
								</td>
								<td id="Text" valign="top" width="90%">
									<xsl:value-of select="."/>
								</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="not($pos=$maxIndex)">
			<xsl:call-template name="Kreiskennungen">
				<xsl:with-param name="blindex" select="$blindex"/>
				<xsl:with-param name="maxIndex" select="$maxIndex"/>
				<xsl:with-param name="pos" select="$pos + 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Bundeslaender">
		<xsl:param name="TagName"/>
		<!--xsl:message>
			Sammelgebiete <xsl:value-of select="dyn:evaluate($TagName)">
			</xsl:value-of>en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland
		</xsl:message-->
		<xsl:variable name="sortedBL">
			<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet]">
				<xsl:sort select="en:Name" data-type="text" order="ascending"/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="source" select="."/>
		<xsl:for-each select="xalan:nodeset($sortedBL)/*">
			<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
			<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:Bundesland[1]/@lib:Index)">
				<xsl:variable name="index" select="@lib:Index"/>
				<xsl:for-each select="$source">
					<xsl:call-template name="Bundesland">
						<xsl:with-param name="index" select="$index"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
