<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="http://www.w3c.org/TR/xhtml1/" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" xmlns:en="uri:BMU_Waste_Interface/EN" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" xmlns:b64="xalan://de.itu.util.Base64" xmlns:crc32="xalan://de.itu.util.CRC32Helper" xmlns:x509="xalan://de.itu.util.X509CertHelper" extension-element-prefixes="b64 crc32 x509" exclude-result-prefixes="xsl lib en ds b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="VE2"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="VE2">
		<!--xsl:for-each select="//*[@lib:LayerID=$layerID]"-->
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<div id="Nummer" align="right">Verantwortliche Erkl&#228;rung (2)</div>
							<table id="tabelle_nicht_unten" width="100%">
								<xsl:call-template name="ESNKopfNummern"/>
								<tr>
									<td>
										<font id="Nummer">
									Verantwortliche Erkl&#228;rung
								</font>
										<font id="Ueberschrift2">
									(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
								</font>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">3</td>
												<td id="Ueberschrift2" width="98%">
		                                                       Abfallbeschreibung                                                      
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Betriebsinterne Bezeichnung</td>
											</tr>
											<tr>
												<td valign="top" id="Ueberschrift2" width="5">3.1</td>
												<td width="98%">
													<!-- Betriebsinterne Bezeichnung-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:InterneBezeichnung'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Nach Abfallverzeichnis-Verordnung (AVV)</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Abfallschl&#252;ssel</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<!-- Abfallschlüssel-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Abfallschluessel'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Abfallbezeichnung</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<!-- Abfallbezeichnung-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Abfallbezeichnung'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr height="2">
												<th/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table>
														<tr>
															<td width="400" id="titel">Abfall wurde vorbehandelt (§ 3 Abs. 2 NachwV):</td>
															<td width="15"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:IndicatorVorbehandlung'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Ja</td>
															<td width="15"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:IndicatorVorbehandlung'"/>
																				<xsl:with-param name="invers" select="true()"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Nein</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Art der Vorbehandlung</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">3.2</td>
												<td width="98%">
													<!-- Art der Vorbehandlung -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Vorbehandlungsart'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">3.3</td>
												<td width="98%">
													<table>
														<tr>
															<td width="100" id="titel">Konsistenz:</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Konsistenz/en:IndicatorFest'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">fest</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Konsistenz/en:IndicatorStichfest'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">stichfest</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Konsistenz/en:IndicatorPastoes'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">past&#246;s/schlammig/breiig</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Konsistenz/en:IndicatorStaub'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">staubf&#246;rmig</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:Konsistenz/en:IndicatorFluessig'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">fl&#252;ssig</td>
															<td width="25"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">3.4</td>
												<td width="98%">
													<table>
														<tr>
															<td width="400" id="titel">Deklarationsanalyse(n) ist/sind beigef&#252;gt:</td>
															<td width="15"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																				<xsl:call-template name="getBooleanValue">
																					<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:IndicatorDABeigefuegt'"/>
																				</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Ja</td>
															<td width="15"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																				<xsl:call-template name="getBooleanValue">
																					<xsl:with-param name="TagName" select="'en:VE/en:Abfallbeschreibung/en:IndicatorDABeigefuegt'"/>
																					<xsl:with-param name="invers" select="true()"/>
																				</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="titel">Nein</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">4</td>
												<td id="Ueberschrift2" width="98%">Anfall und Abgabe des Abfalls</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">4.1</td>
												<td id="titel" width="98%">
                                                         			Menge des Abfalls
                                                         </td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td id="titel" width="98%">
			                                                         bezogen auf die Laufzeit des Entsorgungsnachweises
                                                         </td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td height="3">
													<!-- Menge -->
													<xsl:call-template name="getDoubleValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Gesamtmenge'"/>
													</xsl:call-template>
													&#173;
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Gesamtmenge'"/>
														<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">5</td>
												<td id="Ueberschrift2" width="98%">Beantragte Laufzeit</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="4%"/>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="4%"/>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="62%"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">5.1</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="4%">von</td>
															<td width="15%">
																<!--  Datum von -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:BeantragteLaufzeit/en:DatumVon'"/>
																</xsl:call-template>
															</td>
															<td id="titel" width="4%">bis</td>
															<td width="15%">
																<!--  Datum bis -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:BeantragteLaufzeit/en:DatumBis'"/>
																</xsl:call-template>
															</td>
															<td width="62%"/>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" valign="top" width="5">6</td>
												<td id="Ueberschrift2" width="98%">Verantwortliche Erkl&#228;rung</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" valign="top" width="5">6.1</td>
												<td id="Text_normal" width="98%">
													<!-- Versicherung -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:VerantwortlicheErklaerung/en:Versicherung'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr height="5">
												<th/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="20%">Ort</td>
															<td id="titel" width="10%">Datum</td>
															<td id="titel" width="20%">Name</td>
															<td id="titel" width="20%">Name Bevollmächtige(r)</td>
															<td id="titel" width="30%">Rechtsverbindliche Unterschrift (Signatur)</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="20%">
																<!-- Ort Unterschrift  -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:VerantwortlicheErklaerung/lib:Ort'"/>
																</xsl:call-template>
															</td>
															<td width="10%">
																<!--  Datum -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:VerantwortlicheErklaerung/lib:Datum'"/>
																</xsl:call-template>
															</td>
															<td width="20%">
																<!-- Ort Unterschrift  -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:VerantwortlicheErklaerung/lib:Name'"/>
																</xsl:call-template>
															</td>
															<td width="20%">
																<!-- Ort Unterschrift  -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:VerantwortlicheErklaerung/en:NameBev'"/>
																</xsl:call-template>
															</td>
															<!--  Unterschrift auf der VE -->
															<td width="30%">
																<xsl:variable name="VE_LAYER_ID">
																	<xsl:choose>
																		<xsl:when test="(local-name()='ENSNERZLayer' or (local-name()='ENSNErgaenzungsLayer' and @lib:ATBRolle!='ENT')) and (count(ds:Signature)>0)">
																			<xsl:value-of select="@lib:LayerID"/>
																		</xsl:when>
																		<xsl:when test="count(descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle!='ENT']/ds:Signature) > 0">
																			<xsl:value-of select="descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle!='ENT']/ds:Signature/../@lib:LayerID"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="descendant::en:ENSNERZLayer/@lib:LayerID"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>VE_LAYER_ID: <xsl:value-of select="$VE_LAYER_ID"/></xsl:message-->
																<xsl:variable name="SIG_AKTUELL">
																	<xsl:choose>
																		<xsl:when test="(local-name()='ENSNERZLayer' or (local-name()='ENSNErgaenzungsLayer' and @lib:ATBRolle!='ENT')) and (count(ds:Signature)>0)">
																			<xsl:value-of select="true()"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="false()"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>SIG_AKTUELL: <xsl:value-of select="$SIG_AKTUELL"/></xsl:message-->
																<xsl:choose>
																	<xsl:when test="$SIG_AKTUELL='true'">
																		<xsl:choose>
																			<xsl:when test="count(ds:Signature) > 0">
																				<font id="Aktuell">
																					<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																					<xsl:variable name="SIG_DATE">
																						<xsl:call-template name="formatDate">
																							<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
																					<!--xsl:message>Font: <xsl:value-of select="'Aktuell'"/></xsl:message-->
																				</font>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:if test="count(descendant::*[@lib:LayerID=$VE_LAYER_ID]/ds:Signature) > 0">
																			<font id="Text">
																				<xsl:value-of select="x509:extractCommonName(b64:decode(descendant::*[@lib:LayerID=$VE_LAYER_ID]/ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																				<xsl:variable name="SIG_DATE2">
																					<xsl:call-template name="formatDate">
																						<xsl:with-param name="date" select="descendant::*[@lib:LayerID=$VE_LAYER_ID]/ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
																				<!--xsl:message>Font: <xsl:value-of select="'Text'"/></xsl:message-->
																			</font>
																		</xsl:if>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
