/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplChecksumAlgorithm
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_METHODE = "/descendant::lib:Methode";
    private static final String TECHDOC = "Es wird gepr\u00fcft, ob mit den angegebenen Algorithmen in den Elementen 'Dateianhang/Fehlererkennung/Methode' Instanzen der Klasse 'java.security.MessageDigest' erzeugt werden k\u00f6nnen. Verwendeter XPath: /descendant::lib:Methode";

    public RuleImplChecksumAlgorithm(RuleDef ruleDef) {
        super(ruleDef);
    }

    public static boolean isValid(String algorithm) {
        boolean retVal = true;
        try {
            MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            NodeList nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_METHODE);
            int index = 1;
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nodeMethode = nl.item(i);
                String algorithm = nodeMethode.getTextContent();
                String id = XPathFassade.getInstance().evaluate((Element)nodeMethode, "ancestor::bgs:Dateianhang/@lib:id");
                if (RuleImplChecksumAlgorithm.isValid(algorithm)) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

