/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.util.CertUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignaturePN
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignaturePN.class);
    private static final String TECHDOC = "Pr\u00fcft den 'Common Name' (CN) im Subject-DN des Zertifikats (ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) in allen Signaturen im Dokument auf das Vorkommen von ':PN'";
    private static final String XPATH_SIGNATURE = "/descendant::ds:Signature[@Id]";

    public RuleImplSignaturePN(RuleDef ruleDef) {
        super(ruleDef);
    }

    public static boolean isValid(X509Certificate x509Cert) throws BMUException {
        boolean retVal = true;
        String cn = CertUtils.getSubjectCN(x509Cert);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("CN=" + cn));
        }
        if (cn == null || cn.contains(":PN")) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_SIGNATURE);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node sigNode = nl.item(i);
            if (!(sigNode instanceof Element)) continue;
            Element sigElem = (Element)sigNode;
            String sigID = sigElem.getAttribute("Id");
            NodeList certNodeList = sigElem.getElementsByTagNameNS(Namespace.xmldsig.getUri(), "X509Certificate");
            if (certNodeList == null || certNodeList.getLength() == 0) {
                LOGGER.info((Object)"Kein Element <X509Certificate> gefunden. Dies kann nicht vorkommen!");
                continue;
            }
            if (certNodeList.getLength() > 1) {
                LOGGER.warn((Object)("Die Pr\u00fcfung auf Pseudonym (':PN') kann nicht durchgef\u00fchrt werden, da mehrere Elemente 'X509Certificate' in der Signatur mit der Id=" + sigID + " vorhanden sind!"));
                continue;
            }
            for (int j = 0; j < certNodeList.getLength(); ++j) {
                try {
                    X509Certificate x509Cert = CertUtils.getX509CertificateFromBase64(certNodeList.item(j).getTextContent());
                    if (RuleImplSignaturePN.isValid(x509Cert)) continue;
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error reading X509Certificate", (Throwable)e);
                    throw new BMUException("Error reading X509Certificate", e);
                }
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

