/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureVerificationRA
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureVerificationRA.class);

    public RuleImplSignatureVerificationRA(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        RuleResultImpl ruleResult = null;
        boolean valid = true;
        try {
            nodeList = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), "/descendant::reg:RegisterAuszug/ds:Signature");
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node sigNode = nodeList.item(i);
            String sigId = sigNode.getAttributes().getNamedItem("Id").getTextContent();
            try {
                valid = XmlSecFassade.getInstance().verifySignature(bmuDok.getDocument(), sigId);
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigId);
                if (!valid) {
                    if (svr != null) {
                        svr.setVerificationStatus(SignatureVerificationResult.VerificationStatus.INVALID);
                    }
                    ruleResult = new RuleResultImpl(this.getRuleDef(), index++, sigId);
                    ruleResultList.add(ruleResult);
                    continue;
                }
                if (svr == null) continue;
                svr.setVerificationStatus(SignatureVerificationResult.VerificationStatus.VALID);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Fehler bei der Pr\u00fcfung der Signaturen", (Throwable)e);
                ruleResult = new RuleResultImpl(this.getRuleDef(), index++, sigId);
                ruleResultList.add(ruleResult);
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return "Die umschliessenden Signaturen des Registerauszugs werden mit der xmlsec-Implementierung von apache auf mathematische Unversehrtheit gepr\u00fcft.";
    }
}

