/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureXPathFixed
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureXPathFixed.class);
    private static final String XPATH_SIGNATURE = "/descendant::ds:Signature[@Id]";
    private static final String XPATH_SIGXPATH_INTERSECT = "descendant::dsf:XPath[@Filter='intersect']";
    private static final String XPATH_SIGXPATH_SUBTRACT = "descendant::dsf:XPath[@Filter='subtract']";

    public RuleImplSignatureXPathFixed(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        int index = 1;
        try {
            NodeList nlSig = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_SIGNATURE);
            for (int i = 0; i < nlSig.getLength(); ++i) {
                String xPath;
                Element xPathNode;
                Node sigNode = nlSig.item(i);
                if (!(sigNode instanceof Element)) continue;
                Element sigElem = (Element)sigNode;
                String sigID = sigElem.getAttribute("Id");
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigID);
                if (svr == null || !svr.isEnabled(this.getRuleDef())) continue;
                NodeList nl = xpf.evaluateNodeList(sigElem, XPATH_SIGXPATH_INTERSECT);
                if (nl.getLength() == 1) {
                    xPathNode = (Element)nl.item(0);
                    xPath = xPathNode.getTextContent();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Checking Intersect-XPath of Signature with ID '" + sigID + "': " + xPath));
                    }
                    if (!"here()/ancestor::*[6]".equals(xPath)) {
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
                    }
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Missing or multiple Intersect-XPath in Signature with ID '" + sigID));
                    }
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
                }
                nl = xpf.evaluateNodeList(sigElem, XPATH_SIGXPATH_SUBTRACT);
                if (nl.getLength() == 1) {
                    xPathNode = (Element)nl.item(0);
                    xPath = xPathNode.getTextContent();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Checking Subtract-XPath of Signature with ID '" + sigID + "': " + xPath));
                    }
                    if ("here()/ancestor::*[6]/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']".equals(xPath) || "here()/ancestor::*[5]/following-sibling::*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']".equals(xPath)) continue;
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
                    continue;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Missing or multiple Subtract-XPath in Signature with ID '" + sigID));
                }
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_SIGXPATH_INTERSECT);
        builder.append(", ");
        builder.append(XPATH_SIGXPATH_SUBTRACT);
        builder.append(", die ermittelten XPath-Audr\u00fccke m\u00fcssen den Vorgaben der BMU-Schnittstelle entsprechen.");
        return builder.toString();
    }
}

