package de.consist.bmu.rule;

/**
 * Die BMU-Schnittstellenversion.
 */
public enum BMUVersion {
    
    /**
     * Version 1.03. 
     */
    V103("1.03"),
    /**
     * Version 1.04. 
     */
    V104("1.04"),
    /**
     * Version 1.05. 
     */
    V105("1.05");
    
    BMUVersion(String version) {
        _version = version;
    }

    private String _version;

    /**
     * @return String
     */
    public String getVersion() {
        return _version;
    }
    
    /**
     * @param version String
     * @return BMUVersion
     */
    public static BMUVersion lookupVersion(String version) {
        for (BMUVersion bmuVersion : BMUVersion.values()) {
            if (version.equals(bmuVersion.getVersion())) {
                return bmuVersion;
            }
        }
        return null;
    }
}
