/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.def;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

import de.consist.bmu.rule.BMUVersion;

/**
 * Adapter fuer die Konvertierung einer BMUVersion.
 */
public class XmlBMUVersionAdapter extends XmlAdapter<String, BMUVersion> {
    
    /* (non-Javadoc)
     * @see jakarta.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
     */
    @Override
    public final BMUVersion unmarshal(String version) throws Exception {
        return BMUVersion.lookupVersion(version);
    }
 
    /* (non-Javadoc)
     * @see jakarta.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
     */
    @Override
    public final String marshal(BMUVersion bmuVersion) throws Exception {
        return bmuVersion.getVersion();
    }
}
