package de.consist.bmu.rule.impl;

import jakarta.xml.bind.annotation.XmlTransient;

import org.w3c.dom.Element;

import de.consist.bmu.rule.config.schema.fxs.FXSTYPE;

public class FXSDokument {
	private FXSTYPE _fxsType;
	private String _id;
	private String _nsURI;
	@XmlTransient
	private Element _rootElement;
	
    /**
     * Default Konstruktor fuer JAXB. 
     */
	public FXSDokument() {
	}
	
	public FXSDokument(FXSTYPE fxsType, String id, String nsURI, Element rootElement) {
		_fxsType = fxsType;
		_id = id;
		_nsURI = nsURI;
		_rootElement = rootElement;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FXS-Type:" + _fxsType);
        builder.append(", Id:" + _id);
        builder.append(", NS-URI:" + _nsURI);
        builder.append(", Root-Element-Name:" + _rootElement.getLocalName());
        return builder.toString();
	}

	/**
	 * @return the _fxsType
	 */
	public FXSTYPE getFxsType() {
		return _fxsType;
	}

	/**
	 * @param fxsType the fxsType to set
	 */
	public void setFxsType(FXSTYPE fxsType) {
		this._fxsType = fxsType;
	}

	/**
	 * @return the _id
	 */
	public String getId() {
		return _id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this._id = id;
	}

	/**
	 * @return the _nsURI
	 */
	public String getNsURI() {
		return _nsURI;
	}

	/**
	 * @param nsURI the nsURI to set
	 */
	public void setNsURI(String nsURI) {
		this._nsURI = nsURI;
	}

	/**
	 * @return the rootElement
	 */
	@XmlTransient
	public Element getRootElement() {
		return _rootElement;
	}

	/**
	 * @param rootElement the root-element to set
	 */
	public void setRootElement(Element rootElement) {
		this._rootElement = rootElement;
	}
}
