/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.NodeList;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplBGSATBBefLfdNr extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer die laufenden Nummern der Befoerderer.
     */
    private static final String XPATH_BEFLFDNR = "/descendant::bgs:BGSBEFLayer/@lib:ATBBefLfdNummer";

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplBGSATBBefLfdNr(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_BEFLFDNR);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        Set<Integer> nrSet = new HashSet<Integer>(); 
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            String nrString = nl.item(i).getTextContent();
            Integer nr = Integer.valueOf(nrString);
            if (nrSet.contains(nr)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, nrString));
            } else {
                nrSet.add(nr);
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath: " + XPATH_BEFLFDNR;
    }

}
