/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplBGSIndicatorQuittungsbeleg extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private enum XPathATB {
        ERZ(
                "count(/descendant::bgs:Erzeuger[bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Erzeuger/descendant::*[not(local-name()='IndicatorQuittungsbeleg') "
                        + "and not(local-name()='Versicherung')]"),
        BEF1(
                "count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=1 and bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/descendant::*[not(local-name()='LfdNrBefoerderer') "
                        + "and not(local-name()='IndicatorQuittungsbeleg') "
                        + "and not(local-name()='VersicherungErsterBef') "
                        + "and not(local-name()='VersicherungWeitererBef')]"),
        BEF2(
                "count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=2 and bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/descendant::*[not(local-name()='LfdNrBefoerderer') "
                        + "and not(local-name()='IndicatorQuittungsbeleg') "
                        + "and not(local-name()='VersicherungErsterBef') "
                        + "and not(local-name()='VersicherungWeitererBef')]"),
        BEF3(
                "count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=3 and bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/descendant::*[not(local-name()='LfdNrBefoerderer') "
                        + "and not(local-name()='IndicatorQuittungsbeleg') "
                        + "and not(local-name()='VersicherungErsterBef') "
                        + "and not(local-name()='VersicherungWeitererBef')]"),
        ENT(
                "count(/descendant::bgs:Entsorger[bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Entsorger/descendant::*[not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='Versicherung')]"),
        ZWL(
                "count(/descendant::bgs:Lager[bgs:IndicatorQuittungsbeleg]) > 0",
                "/descendant::bgs:Lager/descendant::*[not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='Versicherung')]");

        private String _xPathQB;
        private String _xPathData;

        XPathATB(String xPathQB, String xPathData) {
            _xPathQB = xPathQB;
            _xPathData = xPathData;
        }
    }

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplBGSIndicatorQuittungsbeleg(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (XPathATB xPathATB : XPathATB.values()) {
            try {
                if (XPathFassade.getInstance().evalBool(
                        bmuDok.getDocument().getDocumentElement(), xPathATB._xPathQB)) {
                    NodeList nl = XPathFassade.getInstance().evaluateNodeList(
                            bmuDok.getDocument(), xPathATB._xPathData);
                    boolean textfound = false;
                    for (int i = 0; i < nl.getLength(); i++) {
                        if (!nl.item(i).getTextContent().equals("")) {
                            textfound = true;
                            break;
                        }
                    }
                    if (!textfound) {
                        ruleResultList.add(new RuleResultImpl(getRuleDef(),
                                index++, xPathATB.toString()));
                    }
                }
            } catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Prfen", e);
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes zur Ermittlung von Abfalltransportbeteiligten mit 'IndicatorQuittungsbeleg' ohne weitere Daten: ");
        for (XPathATB atbXPath : XPathATB.values()) {
            builder.append(RuleImpl.NL);
            builder.append(atbXPath.toString());
            builder.append(", Quittungsbeleg gesetzt: ");
            builder.append(atbXPath._xPathQB);
            builder.append(", weitere Daten vorhanden: \"");
            builder.append(atbXPath._xPathData);
        }
        return builder.toString();
    }

}
