/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplBGSMenge extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer bgs:Menge.
     */
    private static final String XPATH_MENGE = "/descendant::bgs:Menge[parent::bgs:Daten][last()]";

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplBGSMenge(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        double menge;
        try {
            menge = XPathFassade.getInstance().evalNumber(bmuDok.getDocument().getDocumentElement(),
                    XPATH_MENGE);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        if (menge <= 0.0) {
            ruleResultList.add(new RuleResultImpl(getRuleDef(), 1, Double.toString(menge)));
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Ermittlung der Menge: " + XPATH_MENGE;
    }

}
