/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * Diese Regel dient der Prfung auf gltige Algorithmen in der
 * Prfsummenmethode. Es wird geprft, ob mit den angegebenen Algorithmen in den
 * Elementen 'Dateianhang/Fehlererkennung/Methode' Instanzen der Klasse
 * 'java.security.MessageDigest' erzeugt werden knnen.
 * 
 * @author srossbroich
 * 
 */
public final class RuleImplChecksumAlgorithm extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer lib:Pruefsumme.
     */
    private static final String XPATH_METHODE = "/descendant::lib:Methode";

    private static final String TECHDOC = "Es wird geprft, ob mit den angegebenen Algorithmen in den Elementen 'Dateianhang/Fehlererkennung/Methode'"
                + " Instanzen der Klasse 'java.security.MessageDigest' erzeugt werden knnen."
                + " Verwendeter XPath: " + XPATH_METHODE;

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplChecksumAlgorithm(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * @param algorithm
     *            Der zu pruefende Algorithmus
     * @return true wenn der Algorithmus bekannt ist, sonst false
     */
    public static boolean isValid(String algorithm) {
        boolean retVal = true;
        try {
            MessageDigest.getInstance(algorithm);
        } catch (NoSuchAlgorithmException e) {
            retVal = false;
        }
        return retVal;
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(
                    bmuDok.getDocument(), XPATH_METHODE);
            int index = 1;
            for (int i = 0; i < nl.getLength(); i++) {
                Node nodeMethode = nl.item(i);
                String algorithm = nodeMethode.getTextContent();
                String id = XPathFassade.getInstance().evaluate((Element) nodeMethode, "ancestor::bgs:Dateianhang/@lib:id"); 
                if (!isValid(algorithm)) {
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++,
                            id));
                }
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }
}
