/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich TODO Testen unter Linux
 */
public final class RuleImplDateiname extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer lib:dateiname .
     */
    private static final String XPATH_DATEINAME = "/descendant::*[local-name()='Dateianhang' and @lib:id]";

    /**
     * Zeichen, die im dateinamen nicht zulaessig sind.
     */
    private static final char[] PATH_CHARS = { '/', '\\', ':', '*', '?' };

    private static final String TECHDOC = "berprft das Attribut 'dateiname' in allen Dateianhngen (Element 'Dateianhang') "
            + "auf das Vorkommen von " + String.valueOf(PATH_CHARS)
            + " Verwendeter XPath: " + XPATH_DATEINAME;

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplDateiname(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * Ueberprueft den uebergebenen Namen auf das Vorkommen von Zeichen zur
     * Angabe von Dateipfaden.
     * 
     * @param dateiname
     *            Der zu pruefende Dateiname
     * @return boolean
     */
    public boolean isValid(String dateiname) {
        if (dateiname == null) {
            throw new IllegalArgumentException("dateiname must not be null");
        }
        boolean valid = true;
        for (char pathChar : PATH_CHARS) {
            if (dateiname.indexOf(pathChar) >= 0) {
                valid = false;
            }
        }
        return valid;
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(
                    bmuDok.getDocument(), XPATH_DATEINAME);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Element elemDateianhang = (Element) nl.item(i);
            String dateiname = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "dateiname");
            if (!isValid(dateiname)) {
                String id = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++,
                        id));
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }

}
